/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.SchemaViolationException;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BackendTransaction;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.MetaAnnotated;
import org.janusgraph.diskstorage.ReadBuffer;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.indexing.IndexEntry;
import org.janusgraph.diskstorage.indexing.IndexFeatures;
import org.janusgraph.diskstorage.indexing.IndexInformation;
import org.janusgraph.diskstorage.indexing.IndexProvider;
import org.janusgraph.diskstorage.indexing.IndexQuery;
import org.janusgraph.diskstorage.indexing.RawQuery;
import org.janusgraph.diskstorage.indexing.StandardKeyInformation;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.EntryArrayList;
import org.janusgraph.diskstorage.util.HashingUtil;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.EdgeSerializer;
import org.janusgraph.graphdb.database.IndexRecordEntry;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.idhandling.IDHandler;
import org.janusgraph.graphdb.database.index.IndexInfoRetriever;
import org.janusgraph.graphdb.database.index.IndexMutationType;
import org.janusgraph.graphdb.database.index.IndexRecords;
import org.janusgraph.graphdb.database.index.IndexUpdate;
import org.janusgraph.graphdb.database.index.IndexUpdateContainer;
import org.janusgraph.graphdb.database.serialize.Serializer;
import org.janusgraph.graphdb.database.util.IndexAppliesToFunction;
import org.janusgraph.graphdb.database.util.IndexRecordUtil;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.internal.OrderList;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.ConditionUtil;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.query.graph.IndexQueryBuilder;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.query.graph.MultiKeySliceQuery;
import org.janusgraph.graphdb.query.index.IndexSelectionUtil;
import org.janusgraph.graphdb.query.vertex.VertexWithInlineProps;
import org.janusgraph.graphdb.relations.RelationIdentifier;
import org.janusgraph.graphdb.tinkerpop.optimize.step.Aggregation;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.MixedIndexType;
import org.janusgraph.graphdb.types.ParameterIndexField;
import org.janusgraph.graphdb.types.ParameterType;
import org.janusgraph.graphdb.types.TypeInspector;
import org.janusgraph.graphdb.types.indextype.IndexReferenceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSerializer {
    private static final Logger log = LoggerFactory.getLogger(IndexSerializer.class);
    private final EdgeSerializer edgeSerializer;
    private final Serializer serializer;
    private final Configuration configuration;
    private final Map<String, ? extends IndexInformation> mixedIndexes;
    private final boolean hashKeys;
    private final HashingUtil.HashLength hashLength = HashingUtil.HashLength.SHORT;

    public IndexSerializer(Configuration config, EdgeSerializer edgeSerializer, Serializer serializer, Map<String, ? extends IndexInformation> indexes, boolean hashKeys) {
        this.serializer = serializer;
        this.edgeSerializer = edgeSerializer;
        this.configuration = config;
        this.mixedIndexes = indexes;
        this.hashKeys = hashKeys;
        if (hashKeys) {
            log.info("Hashing index keys");
        }
    }

    public boolean containsIndex(String indexName) {
        return this.mixedIndexes.containsKey(indexName);
    }

    public String getDefaultFieldName(PropertyKey key, Parameter[] parameters, String indexName) {
        Preconditions.checkArgument((!ParameterType.MAPPED_NAME.hasParameter(parameters) ? 1 : 0) != 0, (String)"A field name mapping has been specified for key: %s", (Object)key);
        Preconditions.checkArgument((boolean)this.containsIndex(indexName), (String)"Unknown backing index: %s", (Object)indexName);
        String fieldname = this.configuration.get(GraphDatabaseConfiguration.INDEX_NAME_MAPPING, indexName) != false ? key.name() : IndexRecordUtil.keyID2Name(key);
        return this.mixedIndexes.get(indexName).mapKey2Field(fieldname, new StandardKeyInformation(key, parameters));
    }

    public static void clearStore(MixedIndexType index, BackendTransaction tx) throws BackendException {
        tx.getIndexTransaction(index.getBackingIndexName()).clearStore(index.getStoreName());
    }

    public static void register(MixedIndexType index, PropertyKey key, BackendTransaction tx) throws BackendException {
        tx.getIndexTransaction(index.getBackingIndexName()).register(index.getStoreName(), IndexRecordUtil.key2Field(index, key), IndexRecordUtil.getKeyInformation(index.getField(key)));
    }

    public boolean supports(MixedIndexType index, ParameterIndexField field) {
        return this.getMixedIndex(index).supports(IndexRecordUtil.getKeyInformation(field));
    }

    public boolean supports(MixedIndexType index, ParameterIndexField field, JanusGraphPredicate predicate) {
        return this.getMixedIndex(index).supports(IndexRecordUtil.getKeyInformation(field), predicate);
    }

    public boolean supportsExistsQuery(MixedIndexType index, ParameterIndexField field) {
        if (Geoshape.class.equals(IndexRecordUtil.getKeyInformation(field).getDataType())) {
            return this.getMixedIndex(index).getFeatures().supportsGeoExists();
        }
        return true;
    }

    public IndexFeatures features(MixedIndexType index) {
        return this.getMixedIndex(index).getFeatures();
    }

    private IndexInformation getMixedIndex(MixedIndexType index) {
        IndexInformation indexinfo = this.mixedIndexes.get(index.getBackingIndexName());
        Preconditions.checkArgument((indexinfo != null ? 1 : 0) != 0, (String)"Index is unknown or not configured: %s", (Object)index.getBackingIndexName());
        return indexinfo;
    }

    public IndexInfoRetriever getIndexInfoRetriever(StandardJanusGraphTx tx) {
        return new IndexInfoRetriever(tx);
    }

    public Collection<IndexUpdate> getIndexUpdates(InternalRelation relation, TypeInspector typeInspector) {
        return this.getIndexUpdates(relation, IndexRecordUtil.FULL_INDEX_APPLIES_TO_FILTER, typeInspector);
    }

    public Stream<IndexUpdate> getIndexUpdates(InternalVertex vertex, Collection<InternalRelation> updatedProperties, TypeInspector typeInspector) {
        return this.getIndexUpdates(vertex, updatedProperties, IndexRecordUtil.FULL_INDEX_APPLIES_TO_FILTER, typeInspector);
    }

    public Collection<IndexUpdate> getIndexUpdatesNoConstraints(InternalRelation relation, TypeInspector typeInspector) {
        return this.getIndexUpdates(relation, IndexRecordUtil.INDEX_APPLIES_TO_NO_CONSTRAINTS_FILTER, typeInspector);
    }

    public Stream<IndexUpdate> getIndexUpdatesNoConstraints(InternalVertex vertex, Collection<InternalRelation> updatedProperties, TypeInspector typeInspector) {
        return this.getIndexUpdates(vertex, updatedProperties, IndexRecordUtil.INDEX_APPLIES_TO_NO_CONSTRAINTS_FILTER, typeInspector);
    }

    public Collection<IndexUpdate> getIndexUpdates(InternalRelation relation, IndexAppliesToFunction indexFilter, TypeInspector typeInspector) {
        assert (relation.isNew() || relation.isRemoved());
        HashSet<IndexUpdate> updates = new HashSet<IndexUpdate>();
        IndexMutationType updateType = IndexRecordUtil.getUpdateType(relation, false);
        int ttl = updateType == IndexMutationType.DELETE ? 0 : StandardJanusGraph.getTTL(relation);
        for (PropertyKey type : relation.getPropertyKeysDirect()) {
            if (type == null) continue;
            for (IndexType index : ((InternalRelationType)((Object)type)).getKeyIndexes()) {
                IndexUpdate<Object, MetaAnnotated> update;
                if (!indexFilter.indexAppliesTo(index, relation)) continue;
                if (index instanceof CompositeIndexType) {
                    CompositeIndexType iIndex = (CompositeIndexType)index;
                    IndexRecordEntry[] record = IndexRecordUtil.indexMatch(relation, iIndex);
                    if (record == null) continue;
                    update = IndexRecordUtil.getCompositeIndexUpdate(iIndex, updateType, record, relation, this.serializer, typeInspector, this.edgeSerializer, this.hashKeys, this.hashLength);
                } else {
                    assert (relation.valueOrNull(type) != null);
                    if (((MixedIndexType)index).getField(type).getStatus() == SchemaStatus.DISABLED) continue;
                    update = IndexRecordUtil.getMixedIndexUpdate(relation, type, relation.valueOrNull(type), (MixedIndexType)index, updateType);
                }
                if (ttl > 0) {
                    update.setTTL(ttl);
                }
                updates.add(update);
            }
        }
        return updates;
    }

    public Stream<IndexUpdate> getIndexUpdates(InternalVertex vertex, Collection<InternalRelation> updatedProperties, IndexAppliesToFunction indexFilter, TypeInspector typeInspector) {
        if (updatedProperties.isEmpty()) {
            return Stream.empty();
        }
        HashMap<Object, IndexUpdateContainer> updates = new HashMap<Object, IndexUpdateContainer>();
        for (InternalRelation rel : updatedProperties) {
            assert (rel.isProperty());
            JanusGraphVertexProperty p = (JanusGraphVertexProperty)((Object)rel);
            assert (rel.isNew() || rel.isRemoved());
            assert (rel.getVertex(0).equals(vertex));
            for (IndexReferenceType indexRef : ((InternalRelationType)((Object)p.propertyKey())).getKeyIndexesReferences()) {
                IndexMutationType updateType = IndexRecordUtil.getUpdateType(rel, indexRef.isInlined());
                if (vertex.isRemoved() && indexRef.isInlined() || !indexFilter.indexAppliesTo(indexRef.getIndexType(), vertex)) continue;
                if (indexRef.getIndexType().isCompositeIndex()) {
                    CompositeIndexType cIndex = (CompositeIndexType)indexRef.getIndexType();
                    IndexRecords updateRecords = IndexRecordUtil.indexMatches(vertex, cIndex, rel.isRemoved(), p.propertyKey(), new IndexRecordEntry(p));
                    for (IndexRecordEntry[] record : updateRecords) {
                        IndexUpdate<StaticBuffer, Entry> update = IndexRecordUtil.getCompositeIndexUpdate(cIndex, updateType, record, vertex, this.serializer, typeInspector, this.edgeSerializer, this.hashKeys, this.hashLength);
                        int ttl = IndexRecordUtil.getIndexTTL(vertex, IndexRecordUtil.getKeysOfRecords(record));
                        if (ttl > 0 && updateType != IndexMutationType.DELETE) {
                            update.setTTL(ttl);
                        }
                        if (updates.containsKey(update.getKey())) {
                            ((IndexUpdateContainer)updates.get(update.getKey())).add(update);
                            continue;
                        }
                        updates.put(update.getKey(), new IndexUpdateContainer(update));
                    }
                    continue;
                }
                ParameterIndexField field = ((MixedIndexType)indexRef.getIndexType()).getField(p.propertyKey());
                if (field == null) {
                    throw new SchemaViolationException(p.propertyKey() + " is not available in mixed index " + indexRef.getIndexType());
                }
                if (field.getStatus() == SchemaStatus.DISABLED) continue;
                IndexUpdate<String, IndexEntry> update = IndexRecordUtil.getMixedIndexUpdate(vertex, p.propertyKey(), p.value(), (MixedIndexType)indexRef.getIndexType(), updateType);
                int ttl = IndexRecordUtil.getIndexTTL(vertex, p.propertyKey());
                if (ttl > 0 && updateType != IndexMutationType.DELETE) {
                    update.setTTL(ttl);
                }
                if (updates.containsKey(update.getKey())) {
                    ((IndexUpdateContainer)updates.get(update.getKey())).add(update);
                    continue;
                }
                updates.put(update.getKey(), new IndexUpdateContainer(update));
            }
        }
        return updates.values().stream().flatMap(IndexUpdateContainer::getUpdates);
    }

    public boolean reindexElement(JanusGraphElement element, MixedIndexType index, Map<String, Map<String, List<IndexEntry>>> documentsPerStore) {
        if (!IndexRecordUtil.indexAppliesTo(index, element)) {
            return false;
        }
        ArrayList entries = new ArrayList();
        for (ParameterIndexField field : index.getFieldKeys()) {
            PropertyKey key = field.getFieldKey();
            if (field.getStatus() == SchemaStatus.DISABLED) continue;
            if (!element.properties(new String[]{key.name()}).hasNext()) continue;
            element.values(new String[]{key.name()}).forEachRemaining(value -> entries.add(new IndexEntry(IndexRecordUtil.key2Field(field), value)));
        }
        if (entries.isEmpty()) {
            return false;
        }
        this.getDocuments(documentsPerStore, index).put(IndexRecordUtil.element2String(element), entries);
        return true;
    }

    private Map<String, List<IndexEntry>> getDocuments(Map<String, Map<String, List<IndexEntry>>> documentsPerStore, MixedIndexType index) {
        return documentsPerStore.computeIfAbsent(index.getStoreName(), k -> new HashMap());
    }

    public void removeElement(Object elementId, MixedIndexType index, Map<String, Map<String, List<IndexEntry>>> documentsPerStore) {
        Preconditions.checkArgument((index.getElement() == ElementCategory.VERTEX && elementId instanceof Long || index.getElement().isRelation() && elementId instanceof RelationIdentifier ? 1 : 0) != 0, (String)"Invalid element id [%s] provided for index: %s", (Object)elementId, (Object)index);
        this.getDocuments(documentsPerStore, index).put(IndexRecordUtil.element2String(elementId), new ArrayList());
    }

    public Set<IndexUpdate<StaticBuffer, Entry>> reindexElement(JanusGraphElement element, CompositeIndexType index, TypeInspector typeInspector) {
        List<IndexRecordEntry[]> records;
        HashSet<IndexUpdate<StaticBuffer, Entry>> indexEntries = new HashSet<IndexUpdate<StaticBuffer, Entry>>();
        if (!IndexRecordUtil.indexAppliesTo(index, element)) {
            return indexEntries;
        }
        if (element instanceof JanusGraphVertex) {
            records = IndexRecordUtil.indexMatches((JanusGraphVertex)element, index);
        } else {
            assert (element instanceof JanusGraphRelation);
            IndexRecordEntry[] record = IndexRecordUtil.indexMatch((JanusGraphRelation)element, index);
            records = record == null ? Collections.emptyList() : Collections.singletonList(record);
        }
        for (IndexRecordEntry[] record : records) {
            indexEntries.add(IndexRecordUtil.getCompositeIndexUpdate(index, IndexMutationType.ADD, record, element, this.serializer, typeInspector, this.edgeSerializer, this.hashKeys, this.hashLength));
        }
        return indexEntries;
    }

    public Stream<Object> query(JointIndexQuery.Subquery query, BackendTransaction tx, StandardJanusGraphTx standardJanusGraphTx) {
        IndexType index = query.getIndex();
        if (index.isCompositeIndex()) {
            Map<String, SliceQuery> inlineQueries = IndexRecordUtil.getInlinePropertiesQueries((CompositeIndexType)index, standardJanusGraphTx);
            MultiKeySliceQuery sq = query.getCompositeQuery();
            List<EntryList> rs = sq.execute(tx);
            ArrayList<VertexWithInlineProps> results = new ArrayList<VertexWithInlineProps>(rs.get(0).size());
            for (EntryList r : rs) {
                Iterator<Entry> iterator = r.reuseIterator();
                block4: while (iterator.hasNext()) {
                    Entry entry = iterator.next();
                    ReadBuffer readBuffer = entry.asReadBuffer();
                    readBuffer.movePositionTo(entry.getValuePosition());
                    switch (index.getElement()) {
                        case VERTEX: {
                            Object vertexId = IDHandler.readVertexId(readBuffer, true);
                            results.add(new VertexWithInlineProps(vertexId, EntryArrayList.of(IndexRecordUtil.readInlineProperties(readBuffer)), inlineQueries, standardJanusGraphTx));
                            continue block4;
                        }
                    }
                    results.add((VertexWithInlineProps)IndexRecordUtil.bytebuffer2RelationId(readBuffer));
                }
            }
            return results.stream();
        }
        return tx.indexQuery(index.getBackingIndexName(), query.getMixedQuery()).map(IndexRecordUtil::string2ElementId);
    }

    public Number queryAggregation(JointIndexQuery.Subquery query, BackendTransaction tx, Aggregation aggregation) {
        IndexType index = query.getIndex();
        assert (index.isMixedIndex());
        return tx.indexQueryAggregation(index.getBackingIndexName(), query.getMixedQuery(), aggregation);
    }

    public MultiKeySliceQuery getQuery(CompositeIndexType index, List<Object[]> values) {
        ArrayList<KeySliceQuery> ksqs = new ArrayList<KeySliceQuery>(values.size());
        for (Object[] value : values) {
            ksqs.add(new KeySliceQuery(IndexRecordUtil.getIndexKey(index, value, this.serializer, this.hashKeys, this.hashLength), BufferUtil.zeroBuffer(1), BufferUtil.oneBuffer(1)));
        }
        return new MultiKeySliceQuery(ksqs);
    }

    public IndexQuery getQuery(final MixedIndexType index, Condition condition, OrderList orders) {
        Condition<JanusGraphElement> newCondition = ConditionUtil.literalTransformation(condition, new Function<Condition<JanusGraphElement>, Condition<JanusGraphElement>>(){

            @Nullable
            public Condition<JanusGraphElement> apply(Condition<JanusGraphElement> condition) {
                Preconditions.checkArgument((boolean)(condition instanceof PredicateCondition));
                PredicateCondition pc = (PredicateCondition)condition;
                PropertyKey key = (PropertyKey)pc.getKey();
                return new PredicateCondition(IndexRecordUtil.key2Field(index, key), pc.getPredicate(), pc.getValue());
            }
        });
        ImmutableList newOrders = IndexQuery.NO_ORDER;
        if (!orders.isEmpty() && IndexSelectionUtil.indexCoversOrder(index, orders)) {
            ImmutableList.Builder lb = ImmutableList.builder();
            for (int i = 0; i < orders.size(); ++i) {
                lb.add((Object)new IndexQuery.OrderEntry(IndexRecordUtil.key2Field(index, orders.getKey(i)), orders.getOrder(i), orders.getKey(i).dataType()));
            }
            newOrders = lb.build();
        }
        return new IndexQuery(index.getStoreName(), newCondition, newOrders);
    }

    private String createQueryString(IndexQueryBuilder query, ElementCategory resultType, StandardJanusGraphTx transaction, MixedIndexType index) {
        Preconditions.checkArgument((index.getElement() == resultType ? 1 : 0) != 0, (String)"Index is not configured for the desired result type: %s", (Object)((Object)resultType));
        String backingIndexName = index.getBackingIndexName();
        IndexProvider indexInformation = (IndexProvider)this.mixedIndexes.get(backingIndexName);
        StringBuilder qB = new StringBuilder(query.getQuery());
        String prefix = query.getPrefix();
        Preconditions.checkNotNull((Object)prefix);
        int replacements = 0;
        int pos = 0;
        while (pos < qB.length() && (pos = qB.indexOf(prefix, pos)) >= 0) {
            String replacement;
            boolean quoteTerminated;
            int startPos = pos;
            StringBuilder keyBuilder = new StringBuilder();
            boolean bl = quoteTerminated = qB.charAt(pos += prefix.length()) == '\"';
            if (quoteTerminated) {
                ++pos;
            }
            while (pos < qB.length() && (Character.isLetterOrDigit(qB.charAt(pos)) || quoteTerminated && qB.charAt(pos) != '\"' || qB.charAt(pos) == '*')) {
                keyBuilder.append(qB.charAt(pos));
                ++pos;
            }
            if (quoteTerminated) {
                // empty if block
            }
            int endPos = ++pos;
            String keyName = keyBuilder.toString();
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)keyName), (String)"Found reference to empty key at position [%s]", (int)startPos);
            if (keyName.equals("*")) {
                replacement = indexInformation.getFeatures().getWildcardField();
            } else if (transaction.containsRelationType(keyName)) {
                PropertyKey key = transaction.getPropertyKey(keyName);
                Preconditions.checkNotNull((Object)key);
                Preconditions.checkArgument((boolean)index.indexesKey(key), (String)"The used key [%s] is not indexed in the targeted index [%s]", (Object)key.name(), (Object)query.getIndex());
                replacement = IndexRecordUtil.key2Field(index, key);
            } else {
                Preconditions.checkArgument((query.getUnknownKeyName() != null ? 1 : 0) != 0, (String)"Found reference to nonexistent property key in query at position [%s]: %s", (int)startPos, (Object)keyName);
                replacement = query.getUnknownKeyName();
            }
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)replacement));
            qB.replace(startPos, endPos, replacement);
            pos = startPos + replacement.length();
            ++replacements;
        }
        String queryStr = qB.toString();
        if (replacements <= 0) {
            log.warn("Could not convert given {} index query: [{}]", (Object)resultType, (Object)query.getQuery());
        }
        log.info("Converted query string with {} replacements: [{}] => [{}]", new Object[]{replacements, query.getQuery(), queryStr});
        return queryStr;
    }

    private ImmutableList<IndexQuery.OrderEntry> getOrders(IndexQueryBuilder query, ElementCategory resultType, StandardJanusGraphTx transaction, MixedIndexType index) {
        if (query.getOrders() == null) {
            return ImmutableList.of();
        }
        Preconditions.checkArgument((index.getElement() == resultType ? 1 : 0) != 0, (String)"Index is not configured for the desired result type: %s", (Object)((Object)resultType));
        ArrayList<IndexQuery.OrderEntry> orderReplacement = new ArrayList<IndexQuery.OrderEntry>();
        for (Parameter<org.apache.tinkerpop.gremlin.process.traversal.Order> order : query.getOrders()) {
            if (transaction.containsRelationType(order.key())) {
                PropertyKey key = transaction.getPropertyKey(order.key());
                Preconditions.checkNotNull((Object)key);
                Preconditions.checkArgument((boolean)index.indexesKey(key), (String)"The used key [%s] is not indexed in the targeted index [%s]", (Object)key.name(), (Object)query.getIndex());
                orderReplacement.add(new IndexQuery.OrderEntry(IndexRecordUtil.key2Field(index, key), Order.convert(order.value()), key.dataType()));
                continue;
            }
            Preconditions.checkArgument((query.getUnknownKeyName() != null ? 1 : 0) != 0, (String)"Found reference to nonexistent property key in query orders %s", (Object)order.key());
        }
        return ImmutableList.copyOf(orderReplacement);
    }

    public Stream<RawQuery.Result> executeQuery(IndexQueryBuilder query, ElementCategory resultType, BackendTransaction backendTx, StandardJanusGraphTx transaction) {
        MixedIndexType index = IndexRecordUtil.getMixedIndex(query.getIndex(), transaction);
        String queryStr = this.createQueryString(query, resultType, transaction, index);
        ImmutableList<IndexQuery.OrderEntry> orders = this.getOrders(query, resultType, transaction, index);
        RawQuery rawQuery = new RawQuery(index.getStoreName(), queryStr, orders, query.getParameters());
        if (query.hasLimit()) {
            rawQuery.setLimit(query.getLimit());
        }
        rawQuery.setOffset(query.getOffset());
        return backendTx.rawQuery(index.getBackingIndexName(), rawQuery).map(result -> new RawQuery.Result<Object>(IndexRecordUtil.string2ElementId((String)result.getResult()), result.getScore()));
    }

    public Long executeTotals(IndexQueryBuilder query, ElementCategory resultType, BackendTransaction backendTx, StandardJanusGraphTx transaction) {
        MixedIndexType index = IndexRecordUtil.getMixedIndex(query.getIndex(), transaction);
        String queryStr = this.createQueryString(query, resultType, transaction, index);
        RawQuery rawQuery = new RawQuery(index.getStoreName(), queryStr, query.getParameters());
        if (query.hasLimit()) {
            rawQuery.setLimit(query.getLimit());
        }
        rawQuery.setOffset(query.getOffset());
        return backendTx.totals(index.getBackingIndexName(), rawQuery);
    }

    public long getIndexIdFromKey(StaticBuffer key) {
        return IndexRecordUtil.getIndexIdFromKey(key, this.hashKeys, this.hashLength);
    }

    public boolean isHashKeys() {
        return this.hashKeys;
    }

    public HashingUtil.HashLength getHashLength() {
        return this.hashLength;
    }
}

