/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.example;

import com.google.common.base.Preconditions;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.graphdb.database.StandardJanusGraph;

public class GraphOfTheGodsFactory {
    public static final String INDEX_NAME = "search";
    private static final String ERR_NO_INDEXING_BACKEND = "The indexing backend with name \"%s\" is not defined. Specify an existing indexing backend or use GraphOfTheGodsFactory.loadWithoutMixedIndex(graph,true) to load without the use of an indexing backend.";

    public static JanusGraph create(String directory) {
        JanusGraphFactory.Builder config = JanusGraphFactory.build();
        config.set("storage.backend", "berkeleyje");
        config.set("storage.directory", directory);
        config.set("index.search.backend", "elasticsearch");
        JanusGraph graph = config.open();
        GraphOfTheGodsFactory.load(graph);
        return graph;
    }

    public static void loadWithoutMixedIndex(JanusGraph graph, boolean uniqueNameCompositeIndex) {
        GraphOfTheGodsFactory.load(graph, null, uniqueNameCompositeIndex);
    }

    public static void load(JanusGraph graph) {
        GraphOfTheGodsFactory.load(graph, INDEX_NAME, true);
    }

    private static boolean mixedIndexNullOrExists(StandardJanusGraph graph, String indexName) {
        return indexName == null || graph.getIndexSerializer().containsIndex(indexName);
    }

    public static void load(JanusGraph graph, String mixedIndexName, boolean uniqueNameCompositeIndex) {
        if (graph instanceof StandardJanusGraph) {
            Preconditions.checkState((boolean)GraphOfTheGodsFactory.mixedIndexNullOrExists((StandardJanusGraph)graph, mixedIndexName), (String)ERR_NO_INDEXING_BACKEND, (Object)mixedIndexName);
        }
        JanusGraphManagement management = graph.openManagement();
        PropertyKey name = management.makePropertyKey("name").dataType(String.class).make();
        JanusGraphManagement.IndexBuilder nameIndexBuilder = management.buildIndex("name", Vertex.class).addKey(name);
        if (uniqueNameCompositeIndex) {
            nameIndexBuilder.unique();
        }
        JanusGraphIndex nameIndex = nameIndexBuilder.buildCompositeIndex();
        management.setConsistency(nameIndex, ConsistencyModifier.LOCK);
        PropertyKey age = management.makePropertyKey("age").dataType(Integer.class).make();
        if (null != mixedIndexName) {
            management.buildIndex("vertices", Vertex.class).addKey(age).buildMixedIndex(mixedIndexName);
        }
        PropertyKey time = management.makePropertyKey("time").dataType(Integer.class).make();
        PropertyKey reason = management.makePropertyKey("reason").dataType(String.class).make();
        PropertyKey place = management.makePropertyKey("place").dataType(Geoshape.class).make();
        if (null != mixedIndexName) {
            management.buildIndex("edges", Edge.class).addKey(reason).addKey(place).buildMixedIndex(mixedIndexName);
        }
        management.makeEdgeLabel("father").multiplicity(Multiplicity.MANY2ONE).make();
        management.makeEdgeLabel("mother").multiplicity(Multiplicity.MANY2ONE).make();
        EdgeLabel battled = management.makeEdgeLabel("battled").signature(time).make();
        management.buildEdgeIndex(battled, "battlesByTime", Direction.BOTH, Order.desc, time);
        management.makeEdgeLabel("lives").signature(reason).make();
        management.makeEdgeLabel("pet").make();
        management.makeEdgeLabel("brother").make();
        management.makeVertexLabel("titan").make();
        management.makeVertexLabel("location").make();
        management.makeVertexLabel("god").make();
        management.makeVertexLabel("demigod").make();
        management.makeVertexLabel("human").make();
        management.makeVertexLabel("monster").make();
        management.commit();
        JanusGraphTransaction tx = graph.newTransaction();
        JanusGraphVertex saturn = tx.addVertex(T.label, "titan", "name", "saturn", "age", 10000);
        JanusGraphVertex sky = tx.addVertex(T.label, "location", "name", "sky");
        JanusGraphVertex sea = tx.addVertex(T.label, "location", "name", "sea");
        JanusGraphVertex jupiter = tx.addVertex(T.label, "god", "name", "jupiter", "age", 5000);
        JanusGraphVertex neptune = tx.addVertex(T.label, "god", "name", "neptune", "age", 4500);
        JanusGraphVertex hercules = tx.addVertex(T.label, "demigod", "name", "hercules", "age", 30);
        JanusGraphVertex alcmene = tx.addVertex(T.label, "human", "name", "alcmene", "age", 45);
        JanusGraphVertex pluto = tx.addVertex(T.label, "god", "name", "pluto", "age", 4000);
        JanusGraphVertex nemean = tx.addVertex(T.label, "monster", "name", "nemean");
        JanusGraphVertex hydra = tx.addVertex(T.label, "monster", "name", "hydra");
        JanusGraphVertex cerberus = tx.addVertex(T.label, "monster", "name", "cerberus");
        JanusGraphVertex tartarus = tx.addVertex(T.label, "location", "name", "tartarus");
        jupiter.addEdge("father", saturn, new Object[0]);
        jupiter.addEdge("lives", sky, new Object[]{"reason", "loves fresh breezes"});
        jupiter.addEdge("brother", neptune, new Object[0]);
        jupiter.addEdge("brother", pluto, new Object[0]);
        neptune.addEdge("lives", sea, new Object[0]).property("reason", (Object)"loves waves");
        neptune.addEdge("brother", jupiter, new Object[0]);
        neptune.addEdge("brother", pluto, new Object[0]);
        hercules.addEdge("father", jupiter, new Object[0]);
        hercules.addEdge("mother", alcmene, new Object[0]);
        hercules.addEdge("battled", nemean, new Object[]{"time", 1, "place", Geoshape.point((double)38.1f, (double)23.7f)});
        hercules.addEdge("battled", hydra, new Object[]{"time", 2, "place", Geoshape.point((double)37.7f, (double)23.9f)});
        hercules.addEdge("battled", cerberus, new Object[]{"time", 12, "place", Geoshape.point((double)39.0, (double)22.0)});
        pluto.addEdge("brother", jupiter, new Object[0]);
        pluto.addEdge("brother", neptune, new Object[0]);
        pluto.addEdge("lives", tartarus, new Object[]{"reason", "no fear of death"});
        pluto.addEdge("pet", cerberus, new Object[0]);
        cerberus.addEdge("lives", tartarus, new Object[0]);
        tx.commit();
    }

    public static void main(String[] args) {
        if (null == args || 1 != args.length) {
            System.err.println("Usage: GraphOfTheGodsFactory <janusgraph-config-file>");
            System.exit(1);
        }
        JanusGraph g = JanusGraphFactory.open(args[0]);
        GraphOfTheGodsFactory.load(g);
        g.close();
    }
}

