/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.keycolumnvalue.cache;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KCVSProxy;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.MultiKeysQueryGroups;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.cache.CachableStaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.cache.CacheTransaction;
import org.janusgraph.diskstorage.util.CacheMetricsAction;
import org.janusgraph.util.stats.MetricManager;

public abstract class KCVSCache
extends KCVSProxy {
    public static final List<Entry> NO_DELETIONS = Collections.emptyList();
    private final String metricsName;

    protected KCVSCache(KeyColumnValueStore store, String metricsName) {
        super(store);
        this.metricsName = metricsName;
    }

    protected boolean hasValidateKeysOnly() {
        return true;
    }

    protected void incActionBy(int by, CacheMetricsAction action, StoreTransaction txh) {
        assert (by >= 1);
        if (this.metricsName != null && txh.getConfiguration().hasGroupName()) {
            MetricManager.INSTANCE.getCounter(txh.getConfiguration().getGroupName(), this.metricsName, action.getName()).inc((long)by);
        }
    }

    public abstract void clearCache();

    public abstract void invalidate(StaticBuffer var1, List<CachableStaticBuffer> var2);

    public abstract void forceClearExpiredCache();

    @Override
    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws BackendException {
        throw new UnsupportedOperationException("Only supports mutateEntries()");
    }

    public void mutateEntries(StaticBuffer key, List<Entry> additions, List<Entry> deletions, StoreTransaction txh) throws BackendException {
        assert (txh instanceof CacheTransaction);
        ((CacheTransaction)txh).mutate(this, key, additions, deletions);
    }

    @Override
    protected final StoreTransaction unwrapTx(StoreTransaction txh) {
        assert (txh instanceof CacheTransaction);
        return ((CacheTransaction)txh).getWrappedTransaction();
    }

    public EntryList getSliceNoCache(KeySliceQuery query, StoreTransaction txh) throws BackendException {
        return this.store.getSlice(query, this.unwrapTx(txh));
    }

    public Map<StaticBuffer, EntryList> getSliceNoCache(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws BackendException {
        return this.store.getSlice(keys, query, this.unwrapTx(txh));
    }

    public Map<SliceQuery, Map<StaticBuffer, EntryList>> getMultiSlicesNoCache(MultiKeysQueryGroups<StaticBuffer, SliceQuery> multiSliceQueriesWithKeys, StoreTransaction txh) throws BackendException {
        return this.store.getMultiSlices(multiSliceQueriesWithKeys, this.unwrapTx(txh));
    }
}

