/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.configuration;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.lang.reflect.Array;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.idmanagement.ConflictAvoidanceMode;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.janusgraph.graphdb.database.serialize.StandardSerializer;
import org.janusgraph.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigOption<O>
extends ConfigElement {
    private static final Logger log = LoggerFactory.getLogger(ConfigOption.class);
    private static final EnumSet<Type> managedTypes = EnumSet.of(Type.FIXED, Type.GLOBAL_OFFLINE, Type.GLOBAL);
    private static final Set<Class<?>> ACCEPTED_DATATYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(ConflictAvoidanceMode.class, Duration.class, TimestampProviders.class, Instant.class, Boolean.class, Short.class, Integer.class, Byte.class, Long.class, Float.class, Double.class, String.class, String[].class)));
    private static final String ACCEPTED_DATATYPES_STRING;
    private final Type type;
    private final Class<O> datatype;
    private final O defaultValue;
    private final Predicate<O> verificationFct;
    private boolean isHidden = false;
    private ConfigOption<?> supersededBy;

    public ConfigOption(ConfigNamespace parent, String name, String description, Type type, O defaultValue) {
        this(parent, name, description, type, defaultValue, ConfigOption.disallowEmpty(defaultValue.getClass()));
    }

    public ConfigOption(ConfigNamespace parent, String name, String description, Type type, O defaultValue, Predicate<O> verificationFct) {
        this(parent, name, description, type, defaultValue.getClass(), defaultValue, verificationFct);
    }

    public ConfigOption(ConfigNamespace parent, String name, String description, Type type, Class<O> dataType) {
        this(parent, name, description, type, (Class<Predicate<O>>)dataType, ConfigOption.disallowEmpty(dataType));
    }

    public ConfigOption(ConfigNamespace parent, String name, String description, Type type, Class<O> dataType, Predicate<O> verificationFct) {
        this(parent, name, description, type, dataType, null, verificationFct);
    }

    public ConfigOption(ConfigNamespace parent, String name, String description, Type type, Class<O> dataType, O defaultValue) {
        this(parent, name, description, type, dataType, defaultValue, ConfigOption.disallowEmpty(dataType));
    }

    public ConfigOption(ConfigNamespace parent, String name, String description, Type type, Class<O> dataType, O defaultValue, Predicate<O> verificationFct) {
        this(parent, name, description, type, dataType, defaultValue, verificationFct, null);
    }

    public ConfigOption(ConfigNamespace parent, String name, String description, Type type, Class<O> dataType, O defaultValue, Predicate<O> verificationFct, ConfigOption<?> supersededBy) {
        super(parent, name, description);
        Preconditions.checkNotNull((Object)((Object)type));
        Preconditions.checkNotNull(dataType);
        Preconditions.checkNotNull(verificationFct);
        this.type = type;
        this.datatype = dataType;
        this.defaultValue = defaultValue;
        this.verificationFct = verificationFct;
        this.supersededBy = supersededBy;
        if (!ACCEPTED_DATATYPES.contains(dataType)) {
            String msg = String.format("Datatype %s is not one of %s", dataType, ACCEPTED_DATATYPES_STRING);
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    public ConfigOption<O> hide() {
        this.isHidden = true;
        return this;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public Type getType() {
        return this.type;
    }

    public Class<O> getDatatype() {
        return this.datatype;
    }

    public O getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isFixed() {
        return this.type == Type.FIXED;
    }

    public boolean isGlobal() {
        return this.type == Type.FIXED || this.type == Type.GLOBAL_OFFLINE || this.type == Type.GLOBAL || this.type == Type.MASKABLE;
    }

    public boolean isManaged() {
        return managedTypes.contains((Object)this.type);
    }

    public static EnumSet<Type> getManagedTypes() {
        return EnumSet.copyOf(managedTypes);
    }

    public boolean isLocal() {
        return this.type == Type.MASKABLE || this.type == Type.LOCAL;
    }

    public boolean isDeprecated() {
        return null != this.supersededBy;
    }

    public ConfigOption<?> getDeprecationReplacement() {
        return this.supersededBy;
    }

    @Override
    public boolean isOption() {
        return true;
    }

    public O get(Object input) {
        if (input == null) {
            input = this.defaultValue;
        }
        if (input == null) {
            Preconditions.checkState((boolean)this.verificationFct.apply(input), (String)"Need to set configuration value: %s", (Object)this.toString());
            return null;
        }
        return this.verify(input);
    }

    public O verify(Object input) {
        Preconditions.checkNotNull((Object)input);
        Preconditions.checkArgument((boolean)this.datatype.isInstance(input), (String)"Invalid class for configuration value [%s]. Expected [%s] but given [%s]", (Object)this.toString(), this.datatype, input.getClass());
        Object result = input;
        Preconditions.checkArgument((boolean)this.verificationFct.apply(result), (String)"Invalid configuration value for [%s]: %s", (Object)this.toString(), (Object)input);
        return (O)result;
    }

    public static <E extends Enum> E getEnumValue(String str, Class<E> enumClass) {
        String trimmed = str.trim();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)trimmed)) {
            return null;
        }
        return (E)Arrays.stream(enumClass.getEnumConstants()).filter(e -> e.toString().equalsIgnoreCase(trimmed)).findAny().orElseThrow(() -> new IllegalArgumentException("Invalid enum string provided for [" + enumClass + "]: " + trimmed));
    }

    public static <O> Predicate<O> disallowEmpty(Class<O> clazz) {
        return o -> {
            if (o == null) {
                return false;
            }
            if (o instanceof String) {
                return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((String)o));
            }
            return (!o.getClass().isArray() || Array.getLength(o) != 0 && Array.get(o, 0) != null) && (!(o instanceof Collection) || !((Collection)o).isEmpty() && ((Collection)o).iterator().next() != null);
        };
    }

    public static Predicate<Integer> positiveInt() {
        return num -> num != null && num > 0;
    }

    public static Predicate<Integer> nonnegativeInt() {
        return num -> num != null && num >= 0;
    }

    public static Predicate<Long> positiveLong() {
        return num -> num != null && num > 0L;
    }

    public static Predicate<Long> nonnegativeLong() {
        return num -> num != null && num >= 0L;
    }

    static {
        StandardSerializer ss = new StandardSerializer();
        for (Class<?> c : ACCEPTED_DATATYPES) {
            if (ss.validDataType(c)) continue;
            String msg = String.format("%s datatype %s is not accepted by %s", ConfigOption.class.getSimpleName(), c, StandardSerializer.class.getSimpleName());
            log.error(msg);
            throw new IllegalStateException(msg);
        }
        ACCEPTED_DATATYPES_STRING = StringUtils.join(ACCEPTED_DATATYPES, (String)", ");
    }

    public static enum Type {
        FIXED,
        GLOBAL_OFFLINE,
        GLOBAL,
        MASKABLE,
        LOCAL;

    }
}

