/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.EnumMap;
import java.util.function.Function;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.util.encoding.StringEncoding;

public enum EntryMetaData {
    TTL(Integer.class, false, data -> data instanceof Integer && (long)((Integer)data).intValue() >= 0L),
    VISIBILITY(String.class, true, data -> data instanceof String && StringEncoding.isAsciiString((String)data)),
    TIMESTAMP(Long.class, false, data -> data instanceof Long),
    ROW_KEY(StaticBuffer.class, false, data -> data instanceof StaticBuffer);

    public static final java.util.Map<EntryMetaData, Object> EMPTY_METADATA;
    private final Class<?> dataType;
    private final boolean identifying;
    private final Function<Object, Boolean> validator;

    private EntryMetaData(Class<?> dataType, boolean identifying, Function<Object, Boolean> validator) {
        this.dataType = dataType;
        this.identifying = identifying;
        this.validator = validator;
    }

    public Class<?> getDataType() {
        return this.dataType;
    }

    public boolean isIdentifying() {
        return this.identifying;
    }

    public boolean isValidData(Object datum) {
        Preconditions.checkNotNull((Object)datum);
        return this.validator.apply(datum);
    }

    static {
        EMPTY_METADATA = Collections.emptyMap();
    }

    public static class Map
    extends EnumMap<EntryMetaData, Object> {
        public Map() {
            super(EntryMetaData.class);
        }

        @Override
        public Object put(EntryMetaData key, Object value) {
            Preconditions.checkArgument((boolean)key.isValidData(value), (String)"Invalid meta data [%s] for [%s]", (Object)value, (Object)((Object)key));
            return super.put(key, value);
        }
    }
}

