/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema.json.creator.index;

import org.apache.commons.collections.CollectionUtils;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.json.creator.index.AbstractJsonGraphCentricIndexCreator;
import org.janusgraph.core.schema.json.definition.index.JsonCompositeIndexDefinition;

public class JsonCompositeIndexCreator
extends AbstractJsonGraphCentricIndexCreator<JsonCompositeIndexDefinition> {
    @Override
    protected Index buildSpecificIndex(JanusGraphManagement graphManagement, JanusGraphManagement.IndexBuilder indexBuilder, JsonCompositeIndexDefinition definition) {
        if (Boolean.TRUE.equals(definition.getUnique())) {
            indexBuilder.unique();
        }
        if (CollectionUtils.isNotEmpty(definition.getInlinePropertyKeys())) {
            for (String inlinePropertyKey : definition.getInlinePropertyKeys()) {
                PropertyKey propertyKey = graphManagement.getPropertyKey(inlinePropertyKey);
                indexBuilder.addInlinePropertyKey(propertyKey);
            }
        }
        JanusGraphIndex index = indexBuilder.buildCompositeIndex();
        if (definition.getConsistency() != null) {
            graphManagement.setConsistency(index, definition.getConsistency());
        }
        return index;
    }
}

