/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema.json.creator.index;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.JanusGraphSchemaType;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.json.creator.JsonSchemaCreationContext;
import org.janusgraph.core.schema.json.creator.SchemaCreationException;
import org.janusgraph.core.schema.json.creator.index.AbstractJsonIndexCreator;
import org.janusgraph.core.schema.json.definition.index.AbstractJsonGraphCentricIndexDefinition;
import org.janusgraph.core.schema.json.definition.index.AbstractJsonIndexDefinition;
import org.janusgraph.core.schema.json.parser.JsonParameterDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonGraphCentricIndexCreator<T extends AbstractJsonGraphCentricIndexDefinition>
extends AbstractJsonIndexCreator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJsonGraphCentricIndexCreator.class);
    private final JsonParameterDefinitionParser jsonParameterDefinitionParser = new JsonParameterDefinitionParser();

    @Override
    protected Index buildIndex(T definition, JsonSchemaCreationContext context) {
        JanusGraphManagement graphManagement = context.getGraphManagement();
        Class<Element> typeClass = this.toClass(((AbstractJsonGraphCentricIndexDefinition)definition).getTypeClass());
        JanusGraphManagement.IndexBuilder indexBuilder = graphManagement.buildIndex(((AbstractJsonIndexDefinition)definition).getName(), typeClass);
        this.addKeys(graphManagement, indexBuilder, definition);
        this.addIndexOnly(graphManagement, indexBuilder, definition, typeClass);
        return this.buildSpecificIndex(graphManagement, indexBuilder, definition);
    }

    @Override
    protected boolean containsIndex(T definition, JsonSchemaCreationContext context) {
        return context.getGraphManagement().containsGraphIndex(((AbstractJsonIndexDefinition)definition).getName());
    }

    protected void addKeys(JanusGraphManagement graphManagement, JanusGraphManagement.IndexBuilder builder, T definition) {
        if (CollectionUtils.isEmpty(((AbstractJsonGraphCentricIndexDefinition)definition).getKeys())) {
            return;
        }
        ((AbstractJsonGraphCentricIndexDefinition)definition).getKeys().forEach(entry -> {
            if (CollectionUtils.isEmpty(entry.getParameters())) {
                builder.addKey(graphManagement.getPropertyKey(entry.getPropertyKey()));
            } else {
                Parameter[] parameters = (Parameter[])entry.getParameters().stream().map(this.jsonParameterDefinitionParser::parse).toArray(Parameter[]::new);
                builder.addKey(graphManagement.getPropertyKey(entry.getPropertyKey()), parameters);
            }
        });
    }

    protected void addIndexOnly(JanusGraphManagement graphManagement, JanusGraphManagement.IndexBuilder indexBuilder, T definition, Class<? extends Element> typeClass) {
        if (StringUtils.isNotEmpty((CharSequence)((AbstractJsonGraphCentricIndexDefinition)definition).getIndexOnly())) {
            JanusGraphSchemaType schemaLabel;
            if (Vertex.class.isAssignableFrom(typeClass)) {
                schemaLabel = graphManagement.getVertexLabel(((AbstractJsonGraphCentricIndexDefinition)definition).getIndexOnly());
            } else if (Edge.class.isAssignableFrom(typeClass)) {
                schemaLabel = graphManagement.getEdgeLabel(((AbstractJsonGraphCentricIndexDefinition)definition).getIndexOnly());
            } else {
                throw new SchemaCreationException("No implementation for type " + typeClass.getName());
            }
            indexBuilder.indexOnly(schemaLabel);
        }
    }

    private Class<? extends Element> toClass(String type) {
        try {
            return Class.forName(type);
        }
        catch (Exception e) {
            LOGGER.error("Class [{}] is not a child of {}", (Object)type, (Object)Element.class.getName());
            throw new SchemaCreationException(e);
        }
    }

    protected abstract Index buildSpecificIndex(JanusGraphManagement var1, JanusGraphManagement.IndexBuilder var2, T var3);
}

