/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema;

import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.DisableDefaultSchemaMaker;
import org.janusgraph.core.schema.PropertyKeyMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnorePropertySchemaMaker
extends DisableDefaultSchemaMaker {
    public static final IgnorePropertySchemaMaker INSTANCE = new IgnorePropertySchemaMaker();
    private static final Logger log = LoggerFactory.getLogger(IgnorePropertySchemaMaker.class);
    private boolean loggingEnabled;

    @Override
    public void enableLogging(Boolean enabled) {
        if (Boolean.TRUE.equals(enabled)) {
            this.loggingEnabled = true;
        }
    }

    @Override
    public PropertyKey makePropertyKey(PropertyKeyMaker factory) {
        if (this.loggingEnabled) {
            log.warn("Property key '{}' does not exist, will ignore", (Object)factory.getName());
        }
        return null;
    }
}

