/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.util;

import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.websocket.common.util.ReflectUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReflectUtilsTest {
    @Test
    public void testTrimClassName() {
        Assertions.assertEquals((Object)"+~Z", (Object)ReflectUtils.trimClassName((String)"NbcbeUUm$+~Z"));
    }

    @Test
    public void testToShortNameWithNull() {
        Assertions.assertEquals((Object)"<null>", (Object)ReflectUtils.toShortName(null));
    }

    @Test
    public void testToShortNameWithIntegerClass() {
        Assertions.assertEquals((Object)"Integer", (Object)ReflectUtils.toShortName(Integer.class));
    }

    @Test
    public void testFindGenericClassForObjectReturningNull() {
        Assertions.assertNull((Object)ReflectUtils.findGenericClassFor(Object.class, Object.class));
    }

    @Test
    public void testFindGenericClassForWithNullParameters() {
        Assertions.assertNull((Object)ReflectUtils.findGenericClassFor(null, null));
    }

    @Test
    public void testIsDefaultConstructableWithIntegerClass() {
        Assertions.assertFalse((boolean)ReflectUtils.isDefaultConstructable(Integer.class));
    }

    @Test
    public void testIsDefaultConstructableWithAbstractClass() {
        Assertions.assertFalse((boolean)ReflectUtils.isDefaultConstructable(AbstractConnection.class));
    }

    @Test
    public void testIsDefaultConstructableWithObjectClass() {
        Assertions.assertTrue((boolean)ReflectUtils.isDefaultConstructable(Object.class));
    }

    @Test
    public void testFindGenericClassForStringClassTwice() {
        Assertions.assertNull((Object)ReflectUtils.findGenericClassFor(String.class, String.class));
    }
}

