/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.test;

import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.LeakTrackingByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.common.Parser;

public class UnitParser
extends Parser {
    public UnitParser() {
        this(WebSocketPolicy.newServerPolicy());
    }

    public UnitParser(WebSocketPolicy policy) {
        super(policy, (ByteBufferPool)new LeakTrackingByteBufferPool((ByteBufferPool)new MappedByteBufferPool.Tagged()));
    }

    private void parsePartial(ByteBuffer buf, int numBytes) {
        int len = Math.min(numBytes, buf.remaining());
        byte[] arr = new byte[len];
        buf.get(arr, 0, len);
        this.parse(ByteBuffer.wrap(arr));
    }

    public void parseQuietly(ByteBuffer buf) {
        try (StacklessLogging suppress = new StacklessLogging(new Class[]{Parser.class});){
            this.parse(buf);
        }
    }

    public void parseSlowly(ByteBuffer buf, int segmentSize) {
        while (buf.remaining() > 0) {
            this.parsePartial(buf, segmentSize);
        }
    }
}

