/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.test;

import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingDeque;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class OutgoingFramesCapture
implements OutgoingFrames {
    private LinkedBlockingDeque<WebSocketFrame> frames = new LinkedBlockingDeque();

    public void assertFrameCount(int expectedCount) {
        MatcherAssert.assertThat((String)"Captured frame count", (Object)this.frames.size(), (Matcher)Matchers.is((Object)expectedCount));
    }

    public void assertHasFrame(byte op) {
        MatcherAssert.assertThat((String)OpCode.name((byte)op), (Object)this.getFrameCount(op), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
    }

    public void assertHasFrame(byte op, int expectedCount) {
        MatcherAssert.assertThat((String)OpCode.name((byte)op), (Object)this.getFrameCount(op), (Matcher)Matchers.is((Object)expectedCount));
    }

    public void assertHasNoFrames() {
        MatcherAssert.assertThat((String)"Has no frames", (Object)this.frames.size(), (Matcher)Matchers.is((Object)0));
    }

    public void dump() {
        System.out.printf("Captured %d outgoing writes%n", this.frames.size());
        int i = 0;
        for (WebSocketFrame frame : this.frames) {
            System.out.printf("[%3d] %s%n", i, frame);
            System.out.printf("      %s%n", BufferUtil.toDetailString((ByteBuffer)frame.getPayload()));
            ++i;
        }
    }

    public int getFrameCount(byte op) {
        int count = 0;
        for (WebSocketFrame frame : this.frames) {
            if (frame.getOpCode() != op) continue;
            ++count;
        }
        return count;
    }

    public LinkedBlockingDeque<WebSocketFrame> getFrames() {
        return this.frames;
    }

    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        this.frames.add(WebSocketFrame.copy((Frame)frame));
        if (callback != null) {
            callback.writeSuccess();
        }
    }
}

