/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.test;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class IncomingFramesCapture
implements IncomingFrames {
    private LinkedBlockingQueue<WebSocketFrame> frames = new LinkedBlockingQueue();

    public void assertFrameCount(int expectedCount) {
        if (this.frames.size() != expectedCount) {
            System.err.printf("Expected %d frame(s)%n", expectedCount);
            System.err.printf("But actually captured %d frame(s)%n", this.frames.size());
            int i = 0;
            for (Frame frame : this.frames) {
                System.err.printf(" [%d] Frame[%s] - %s%n", i++, OpCode.name((byte)frame.getOpCode()), BufferUtil.toDetailString((ByteBuffer)frame.getPayload()));
            }
        }
        MatcherAssert.assertThat((String)"Captured frame count", (Object)this.frames.size(), (Matcher)Matchers.is((Object)expectedCount));
    }

    public void assertHasFrame(byte op) {
        MatcherAssert.assertThat((String)OpCode.name((byte)op), (Object)this.getFrameCount(op), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
    }

    public void assertHasFrame(byte op, int expectedCount) {
        String msg = String.format("%s frame count", OpCode.name((byte)op));
        MatcherAssert.assertThat((String)msg, (Object)this.getFrameCount(op), (Matcher)Matchers.is((Object)expectedCount));
    }

    public void assertHasNoFrames() {
        MatcherAssert.assertThat((String)"Frame count", (Object)this.frames.size(), (Matcher)Matchers.is((Object)0));
    }

    public void clear() {
        this.frames.clear();
    }

    public void dump() {
        System.err.printf("Captured %d incoming frames%n", this.frames.size());
        int i = 0;
        for (Frame frame : this.frames) {
            System.err.printf("[%3d] %s%n", i++, frame);
            System.err.printf("          payload: %s%n", BufferUtil.toDetailString((ByteBuffer)frame.getPayload()));
        }
    }

    public int getFrameCount(byte op) {
        int count = 0;
        for (WebSocketFrame frame : this.frames) {
            if (frame.getOpCode() != op) continue;
            ++count;
        }
        return count;
    }

    public Queue<WebSocketFrame> getFrames() {
        return this.frames;
    }

    public void incomingFrame(Frame frame) {
        WebSocketFrame copy = WebSocketFrame.copy((Frame)frame);
        this.frames.add(copy);
    }

    public int size() {
        return this.frames.size();
    }
}

