/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.test;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class ByteBufferAssert {
    public static void assertEquals(String message, byte[] expected, byte[] actual) {
        MatcherAssert.assertThat((String)(message + " byte[].length"), (Object)actual.length, (Matcher)Matchers.is((Object)expected.length));
        int len = expected.length;
        for (int i = 0; i < len; ++i) {
            MatcherAssert.assertThat((String)(message + " byte[" + i + "]"), (Object)actual[i], (Matcher)Matchers.is((Object)expected[i]));
        }
    }

    public static void assertEquals(ByteBuffer expectedBuffer, ByteBuffer actualBuffer, String message) {
        ByteBufferAssert.assertEquals(message, expectedBuffer, actualBuffer);
    }

    public static void assertEquals(String message, ByteBuffer expectedBuffer, ByteBuffer actualBuffer) {
        if (expectedBuffer == null) {
            MatcherAssert.assertThat((String)message, (Object)actualBuffer, (Matcher)Matchers.nullValue());
        } else {
            byte[] expectedBytes = BufferUtil.toArray((ByteBuffer)expectedBuffer);
            byte[] actualBytes = BufferUtil.toArray((ByteBuffer)actualBuffer);
            ByteBufferAssert.assertEquals(message, expectedBytes, actualBytes);
        }
    }

    public static void assertEquals(String message, String expectedString, ByteBuffer actualBuffer) {
        String actualString = BufferUtil.toString((ByteBuffer)actualBuffer);
        MatcherAssert.assertThat((String)message, (Object)actualString, (Matcher)Matchers.is((Object)expectedString));
    }

    public static void assertSize(String message, int expectedSize, ByteBuffer buffer) {
        if (expectedSize == 0 && buffer == null) {
            return;
        }
        MatcherAssert.assertThat((String)(message + " buffer.remaining"), (Object)buffer.remaining(), (Matcher)Matchers.is((Object)expectedSize));
    }
}

