/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.test;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.common.WebSocketSessionListener;
import org.eclipse.jetty.websocket.common.extensions.WebSocketExtensionFactory;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.eclipse.jetty.websocket.common.test.BlockheadClientRequest;

public class BlockheadClient
extends HttpClient
implements WebSocketContainerScope {
    private WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.CLIENT);
    private ByteBufferPool bufferPool = new MappedByteBufferPool();
    private ExtensionFactory extensionFactory;
    private DecoratedObjectFactory objectFactory = new DecoratedObjectFactory();
    private List<WebSocketSessionListener> listeners = new ArrayList<WebSocketSessionListener>();

    public BlockheadClient() {
        this.setName("Blockhead-CLIENT");
        this.extensionFactory = new WebSocketExtensionFactory((WebSocketContainerScope)this);
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public DecoratedObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionFactory;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public void addSessionListener(WebSocketSessionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSessionListener(WebSocketSessionListener listener) {
        this.listeners.remove(listener);
    }

    public Collection<WebSocketSessionListener> getSessionListeners() {
        return this.listeners;
    }

    public BlockheadClientRequest newWsRequest(URI destURI) {
        return new BlockheadClientRequest(this, destURI);
    }
}

