/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.common.message.Utf8CharBuffer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class Utf8CharBufferTest {
    private static String asString(ByteBuffer buffer) {
        return BufferUtil.toUTF8String((ByteBuffer)buffer);
    }

    private static byte[] asUTF(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    @Test
    public void testAppendGetAppendGet() {
        ByteBuffer buf = ByteBuffer.allocate(128);
        Utf8CharBuffer utf = Utf8CharBuffer.wrap((ByteBuffer)buf);
        byte[] hellobytes = Utf8CharBufferTest.asUTF("Hello ");
        byte[] worldbytes = Utf8CharBufferTest.asUTF("World!");
        utf.append(hellobytes, 0, hellobytes.length);
        ByteBuffer hellobuf = utf.getByteBuffer();
        utf.append(worldbytes, 0, worldbytes.length);
        ByteBuffer worldbuf = utf.getByteBuffer();
        MatcherAssert.assertThat((String)"Hello buffer", (Object)Utf8CharBufferTest.asString(hellobuf), (Matcher)Matchers.is((Object)"Hello "));
        MatcherAssert.assertThat((String)"World buffer", (Object)Utf8CharBufferTest.asString(worldbuf), (Matcher)Matchers.is((Object)"Hello World!"));
    }

    @Test
    public void testAppendGetClearAppendGet() {
        int bufsize = 128;
        ByteBuffer buf = ByteBuffer.allocate(bufsize);
        Utf8CharBuffer utf = Utf8CharBuffer.wrap((ByteBuffer)buf);
        int expectedSize = bufsize / 2;
        MatcherAssert.assertThat((String)"Remaining (initial)", (Object)utf.remaining(), (Matcher)Matchers.is((Object)expectedSize));
        byte[] hellobytes = Utf8CharBufferTest.asUTF("Hello World");
        utf.append(hellobytes, 0, hellobytes.length);
        ByteBuffer hellobuf = utf.getByteBuffer();
        MatcherAssert.assertThat((String)"Remaining (after append)", (Object)utf.remaining(), (Matcher)Matchers.is((Object)(expectedSize - hellobytes.length)));
        MatcherAssert.assertThat((String)"Hello buffer", (Object)Utf8CharBufferTest.asString(hellobuf), (Matcher)Matchers.is((Object)"Hello World"));
        utf.clear();
        MatcherAssert.assertThat((String)"Remaining (after clear)", (Object)utf.remaining(), (Matcher)Matchers.is((Object)expectedSize));
        byte[] whatnowbytes = Utf8CharBufferTest.asUTF("What Now?");
        utf.append(whatnowbytes, 0, whatnowbytes.length);
        ByteBuffer whatnowbuf = utf.getByteBuffer();
        MatcherAssert.assertThat((String)"Remaining (after 2nd append)", (Object)utf.remaining(), (Matcher)Matchers.is((Object)(expectedSize - whatnowbytes.length)));
        MatcherAssert.assertThat((String)"What buffer", (Object)Utf8CharBufferTest.asString(whatnowbuf), (Matcher)Matchers.is((Object)"What Now?"));
    }

    @Test
    public void testAppendUnicodeGetBuffer() {
        ByteBuffer buf = ByteBuffer.allocate(64);
        Utf8CharBuffer utf = Utf8CharBuffer.wrap((ByteBuffer)buf);
        byte[] bb = Utf8CharBufferTest.asUTF("Hello A\u00ea\u00f1\u00fcC");
        utf.append(bb, 0, bb.length);
        ByteBuffer actual = utf.getByteBuffer();
        MatcherAssert.assertThat((String)"Buffer length should be retained", (Object)actual.remaining(), (Matcher)Matchers.is((Object)bb.length));
        MatcherAssert.assertThat((String)"Message", (Object)Utf8CharBufferTest.asString(actual), (Matcher)Matchers.is((Object)"Hello A\u00ea\u00f1\u00fcC"));
    }

    @Test
    public void testSimpleGetBuffer() {
        int bufsize = 64;
        ByteBuffer buf = ByteBuffer.allocate(bufsize);
        Utf8CharBuffer utf = Utf8CharBuffer.wrap((ByteBuffer)buf);
        int expectedSize = bufsize / 2;
        MatcherAssert.assertThat((String)"Remaining (initial)", (Object)utf.remaining(), (Matcher)Matchers.is((Object)expectedSize));
        byte[] bb = Utf8CharBufferTest.asUTF("Hello World");
        utf.append(bb, 0, bb.length);
        MatcherAssert.assertThat((String)"Remaining (after append)", (Object)utf.remaining(), (Matcher)Matchers.is((Object)(expectedSize -= bb.length)));
        ByteBuffer actual = utf.getByteBuffer();
        MatcherAssert.assertThat((String)"Buffer length", (Object)actual.remaining(), (Matcher)Matchers.is((Object)bb.length));
        MatcherAssert.assertThat((String)"Message", (Object)Utf8CharBufferTest.asString(actual), (Matcher)Matchers.is((Object)"Hello World"));
    }
}

