/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.common.message.MessageDebug;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;

public class TrackingSocket
extends WebSocketAdapter {
    private static final Logger LOG = Log.getLogger(TrackingSocket.class);
    private final String id;
    public int closeCode = -1;
    public StringBuilder closeMessage = new StringBuilder();
    public CountDownLatch openLatch = new CountDownLatch(1);
    public CountDownLatch closeLatch = new CountDownLatch(1);
    public CountDownLatch dataLatch = new CountDownLatch(1);
    public LinkedBlockingQueue<String> messageQueue = new LinkedBlockingQueue();
    public LinkedBlockingQueue<Throwable> errorQueue = new LinkedBlockingQueue();

    public TrackingSocket() {
        this("socket");
    }

    public TrackingSocket(String id) {
        this.id = id;
    }

    public void assertClose(int expectedStatusCode, String expectedReason) throws InterruptedException {
        this.assertCloseCode(expectedStatusCode);
        this.assertCloseReason(expectedReason);
    }

    public void assertCloseCode(int expectedCode) throws InterruptedException {
        MatcherAssert.assertThat((String)"Was Closed", (Object)this.closeLatch.await(50L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"Close Code", (Object)this.closeCode, (Matcher)Matchers.is((Object)expectedCode));
    }

    private void assertCloseReason(String expectedReason) {
        MatcherAssert.assertThat((String)"Close Reason", (Object)this.closeMessage.toString(), (Matcher)Matchers.is((Object)expectedReason));
    }

    public void assertIsOpen() throws InterruptedException {
        this.assertWasOpened();
        this.assertNotClosed();
    }

    public void assertMessage(String expected) {
        String actual = this.messageQueue.poll();
        Assertions.assertEquals((Object)expected, (Object)actual, (String)"Message");
    }

    public void assertNotClosed() {
        MatcherAssert.assertThat((String)"Closed Latch", (Object)this.closeLatch.getCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1L)));
    }

    public void assertNotOpened() {
        MatcherAssert.assertThat((String)"Open Latch", (Object)this.openLatch.getCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1L)));
    }

    public void assertWasOpened() throws InterruptedException {
        MatcherAssert.assertThat((String)"Was Opened", (Object)this.openLatch.await(30L, TimeUnit.SECONDS), (Matcher)Matchers.is((Object)true));
    }

    public void clear() {
        this.messageQueue.clear();
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        LOG.debug("{} onWebSocketBinary(byte[{}],{},{})", new Object[]{this.id, payload.length, offset, len});
        this.messageQueue.offer(MessageDebug.toDetailHint(payload, offset, len));
        this.dataLatch.countDown();
    }

    public void onWebSocketClose(int statusCode, String reason) {
        LOG.debug("{} onWebSocketClose({},{})", new Object[]{this.id, statusCode, reason});
        super.onWebSocketClose(statusCode, reason);
        this.closeCode = statusCode;
        this.closeMessage.append(reason);
        this.closeLatch.countDown();
    }

    public void onWebSocketConnect(Session session) {
        super.onWebSocketConnect(session);
        this.openLatch.countDown();
    }

    public void onWebSocketError(Throwable cause) {
        LOG.debug("{} onWebSocketError", new Object[]{this.id, cause});
        MatcherAssert.assertThat((String)"Error capture", (Object)this.errorQueue.offer(cause), (Matcher)Matchers.is((Object)true));
    }

    public void onWebSocketText(String message) {
        LOG.debug("{} onWebSocketText({})", new Object[]{this.id, message});
        this.messageQueue.offer(message);
        this.dataLatch.countDown();
    }

    public void waitForClose(int timeoutDuration, TimeUnit timeoutUnit) throws InterruptedException {
        MatcherAssert.assertThat((String)"Client Socket Closed", (Object)this.closeLatch.await(timeoutDuration, timeoutUnit), (Matcher)Matchers.is((Object)true));
    }

    public void waitForConnected(int timeoutDuration, TimeUnit timeoutUnit) throws InterruptedException {
        MatcherAssert.assertThat((String)"Client Socket Connected", (Object)this.openLatch.await(timeoutDuration, timeoutUnit), (Matcher)Matchers.is((Object)true));
    }

    public void waitForMessage(int timeoutDuration, TimeUnit timeoutUnit) throws InterruptedException {
        LOG.debug("{} Waiting for message", new Object[]{this.id});
        MatcherAssert.assertThat((String)"Message Received", (Object)this.dataLatch.await(timeoutDuration, timeoutUnit), (Matcher)Matchers.is((Object)true));
    }
}

