/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

@WebSocket
public class TrackingInputStreamSocket {
    private static final Logger LOG = Log.getLogger(TrackingInputStreamSocket.class);
    private final String id;
    public int closeCode = -1;
    public StringBuilder closeMessage = new StringBuilder();
    public CountDownLatch closeLatch = new CountDownLatch(1);
    public LinkedBlockingQueue<String> messageQueue = new LinkedBlockingQueue();
    public LinkedBlockingQueue<Throwable> errorQueue = new LinkedBlockingQueue();

    public TrackingInputStreamSocket() {
        this("socket");
    }

    public TrackingInputStreamSocket(String id) {
        this.id = id;
    }

    public void assertClose(int expectedStatusCode, String expectedReason) throws InterruptedException {
        this.assertCloseCode(expectedStatusCode);
        this.assertCloseReason(expectedReason);
    }

    public void assertCloseCode(int expectedCode) throws InterruptedException {
        MatcherAssert.assertThat((String)"Was Closed", (Object)this.closeLatch.await(50L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"Close Code", (Object)this.closeCode, (Matcher)Matchers.is((Object)expectedCode));
    }

    private void assertCloseReason(String expectedReason) {
        MatcherAssert.assertThat((String)"Close Reason", (Object)this.closeMessage.toString(), (Matcher)Matchers.is((Object)expectedReason));
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onClose({},{})", new Object[]{this.id, statusCode, reason});
        }
        this.closeCode = statusCode;
        this.closeMessage.append(reason);
        this.closeLatch.countDown();
    }

    @OnWebSocketError
    public void onError(Throwable cause) {
        this.errorQueue.add(cause);
    }

    @OnWebSocketMessage
    public void onInputStream(InputStream stream) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onInputStream({})", new Object[]{this.id, stream});
        }
        try {
            String msg = IO.toString((InputStream)stream);
            this.messageQueue.add(msg);
        }
        catch (IOException e) {
            this.errorQueue.add(e);
        }
    }

    public void waitForClose(int timeoutDuration, TimeUnit timeoutUnit) throws InterruptedException {
        MatcherAssert.assertThat((String)"Client Socket Closed", (Object)this.closeLatch.await(timeoutDuration, timeoutUnit), (Matcher)Matchers.is((Object)true));
    }
}

