/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io.http;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.common.io.http.HttpResponseHeaderParseListener;
import org.eclipse.jetty.websocket.common.io.http.HttpResponseHeaderParser;
import org.eclipse.jetty.websocket.common.io.http.HttpResponseParseCapture;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class HttpResponseHeaderParserTest {
    private void appendUtf8(ByteBuffer buf, String line) {
        buf.put(ByteBuffer.wrap(StringUtil.getUtf8Bytes((String)line)));
    }

    @Test
    public void testParseNotFound() {
        StringBuilder resp = new StringBuilder();
        resp.append("HTTP/1.1 404 Not Found\r\n");
        resp.append("Date: Fri, 26 Apr 2013 21:43:08 GMT\r\n");
        resp.append("Content-Type: text/html; charset=ISO-8859-1\r\n");
        resp.append("Cache-Control: must-revalidate,no-cache,no-store\r\n");
        resp.append("Content-Length: 38\r\n");
        resp.append("Server: Jetty(9.0.0.v20130308)\r\n");
        resp.append("\r\n");
        resp.append("What you are looking for is not here\r\n");
        ByteBuffer buf = BufferUtil.toBuffer((String)resp.toString(), (Charset)StandardCharsets.UTF_8);
        HttpResponseParseCapture capture = new HttpResponseParseCapture();
        HttpResponseHeaderParser parser = new HttpResponseHeaderParser((HttpResponseHeaderParseListener)capture);
        MatcherAssert.assertThat((String)"Parser.parse", (Object)parser.parse(buf), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Response.statusCode", (Object)capture.getStatusCode(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((String)"Response.statusReason", (Object)capture.getStatusReason(), (Matcher)Matchers.is((Object)"Not Found"));
        MatcherAssert.assertThat((String)"Response.headers[Content-Length]", (Object)capture.getHeader("Content-Length"), (Matcher)Matchers.is((Object)"38"));
        MatcherAssert.assertThat((String)"Response.remainingBuffer", (Object)capture.getRemainingBuffer().remaining(), (Matcher)Matchers.is((Object)38));
    }

    @Test
    public void testParseRealWorldResponse() {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("HTTP/1.0 200 OK");
        expected.add("Date: Thu, 09 Aug 2012 16:16:39 GMT");
        expected.add("Content-Length: 35");
        expected.add("X-Content-Type-Options: nosniff");
        expected.add("Pragma: no-cache");
        expected.add("Expires: Wed, 19 Apr 2000 11:43:00 GMT");
        expected.add("Last-Modified: Wed, 21 Jan 2004 19:51:30 GMT");
        expected.add("Content-Type: image/gif");
        expected.add("Cache-Control: private, no-cache, no-cache=Set-Cookie, proxy-revalidate");
        expected.add("Age: 518097");
        expected.add("Server: GFE/2.0");
        expected.add("Connection: Keep-Alive");
        expected.add("");
        ByteBuffer buf = ByteBuffer.allocate(512);
        for (String line : expected) {
            this.appendUtf8(buf, line + "\r\n");
        }
        BufferUtil.flipToFlush((ByteBuffer)buf, (int)0);
        HttpResponseParseCapture capture = new HttpResponseParseCapture();
        HttpResponseHeaderParser parser = new HttpResponseHeaderParser((HttpResponseHeaderParseListener)capture);
        MatcherAssert.assertThat((String)"Parser.parse", (Object)parser.parse(buf), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Response.statusCode", (Object)capture.getStatusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"Response.statusReason", (Object)capture.getStatusReason(), (Matcher)Matchers.is((Object)"OK"));
        MatcherAssert.assertThat((String)"Response.header[age]", (Object)capture.getHeader("age"), (Matcher)Matchers.is((Object)"518097"));
    }

    @Test
    public void testParseRealWorldResponseSmallBuffers() {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("HTTP/1.0 200 OK");
        expected.add("Date: Thu, 09 Aug 2012 16:16:39 GMT");
        expected.add("Content-Length: 35");
        expected.add("X-Content-Type-Options: nosniff");
        expected.add("Pragma: no-cache");
        expected.add("Expires: Wed, 19 Apr 2000 11:43:00 GMT");
        expected.add("Last-Modified: Wed, 21 Jan 2004 19:51:30 GMT");
        expected.add("Content-Type: image/gif");
        expected.add("Cache-Control: private, no-cache, no-cache=Set-Cookie, proxy-revalidate");
        expected.add("Age: 518097");
        expected.add("Server: GFE/2.0");
        expected.add("Connection: Keep-Alive");
        expected.add("");
        ByteBuffer buf = ByteBuffer.allocate(512);
        for (String line : expected) {
            this.appendUtf8(buf, line + "\r\n");
        }
        BufferUtil.flipToFlush((ByteBuffer)buf, (int)0);
        ByteBuffer small1 = buf.slice();
        ByteBuffer small2 = buf.slice();
        ByteBuffer small3 = buf.slice();
        small1.limit(50);
        small2.position(50);
        small2.limit(70);
        small3.position(70);
        HttpResponseParseCapture capture = new HttpResponseParseCapture();
        HttpResponseHeaderParser parser = new HttpResponseHeaderParser((HttpResponseHeaderParseListener)capture);
        MatcherAssert.assertThat((String)"Parser.parse", (Object)parser.parse(buf), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Small 1", (Object)parser.parse(small1), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((String)"Small 2", (Object)parser.parse(small2), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((String)"Small 3", (Object)parser.parse(small3), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Response.statusCode", (Object)capture.getStatusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"Response.statusReason", (Object)capture.getStatusReason(), (Matcher)Matchers.is((Object)"OK"));
        MatcherAssert.assertThat((String)"Response.header[age]", (Object)capture.getHeader("age"), (Matcher)Matchers.is((Object)"518097"));
    }

    @Test
    public void testParseUpgrade() {
        StringBuilder resp = new StringBuilder();
        resp.append("HTTP/1.1 101 Switching Protocols\r\n");
        resp.append("Upgrade: websocket\r\n");
        resp.append("Connection: Upgrade\r\n");
        resp.append("Sec-WebSocket-Accept: s3pPLMBiTxaQ9kYGzzhZRbK+xOo=\r\n");
        resp.append("Sec-WebSocket-Protocol: chat\r\n");
        resp.append("\r\n");
        ByteBuffer buf = BufferUtil.toBuffer((String)resp.toString(), (Charset)StandardCharsets.UTF_8);
        HttpResponseParseCapture capture = new HttpResponseParseCapture();
        HttpResponseHeaderParser parser = new HttpResponseHeaderParser((HttpResponseHeaderParseListener)capture);
        MatcherAssert.assertThat((String)"Parser.parse", (Object)parser.parse(buf), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)"Response.statusCode", (Object)capture.getStatusCode(), (Matcher)Matchers.is((Object)101));
        MatcherAssert.assertThat((String)"Response.statusReason", (Object)capture.getStatusReason(), (Matcher)Matchers.is((Object)"Switching Protocols"));
        MatcherAssert.assertThat((String)"Response.headers[Upgrade]", (Object)capture.getHeader("Upgrade"), (Matcher)Matchers.is((Object)"websocket"));
        MatcherAssert.assertThat((String)"Response.headers[Connection]", (Object)capture.getHeader("Connection"), (Matcher)Matchers.is((Object)"Upgrade"));
        MatcherAssert.assertThat((String)"Buffer.remaining", (Object)buf.remaining(), (Matcher)Matchers.is((Object)0));
    }
}

