/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.net.URI;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.io.LocalWebSocketConnection;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.eclipse.jetty.websocket.common.test.OutgoingFramesCapture;

public class LocalWebSocketSession
extends WebSocketSession {
    private String id;
    private OutgoingFramesCapture outgoingCapture;

    public LocalWebSocketSession(WebSocketContainerScope containerScope, String id, EventDriver driver) {
        super(containerScope, URI.create("ws://localhost/LocalWebSocketSesssion/" + id), driver, (LogicalConnection)new LocalWebSocketConnection(id, containerScope.getBufferPool()));
        this.id = id;
        this.outgoingCapture = new OutgoingFramesCapture();
        this.setOutgoingHandler(this.outgoingCapture);
    }

    public void dispatch(Runnable runnable) {
        runnable.run();
    }

    public OutgoingFramesCapture getOutgoingCapture() {
        return this.outgoingCapture;
    }

    public String toString() {
        return String.format("%s[%s]", LocalWebSocketSession.class.getSimpleName(), this.id);
    }
}

