/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.toolchain.test.ByteBufferAssert;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.compression.InflaterPool;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.ProtocolException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtensionTest;
import org.eclipse.jetty.websocket.common.extensions.ExtensionTool;
import org.eclipse.jetty.websocket.common.extensions.compress.CompressExtension;
import org.eclipse.jetty.websocket.common.extensions.compress.PerMessageDeflateExtension;
import org.eclipse.jetty.websocket.common.frames.ContinuationFrame;
import org.eclipse.jetty.websocket.common.frames.PingFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.IncomingFramesCapture;
import org.eclipse.jetty.websocket.common.test.OutgoingFramesCapture;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PerMessageDeflateExtensionTest
extends AbstractExtensionTest {
    public ByteBufferPool bufferPool = new MappedByteBufferPool();
    public DeflaterPool deflaterPool = new DeflaterPool(-1, -1, true);
    public InflaterPool inflaterPool = new InflaterPool(-1, true);

    private void assertEndsWithTail(String hexStr, boolean expectedResult) {
        ByteBuffer buf = ByteBuffer.wrap(TypeUtil.fromHexString((String)hexStr));
        MatcherAssert.assertThat((String)("endsWithTail([" + hexStr + "])"), (Object)CompressExtension.endsWithTail((ByteBuffer)buf), (Matcher)Matchers.is((Object)expectedResult));
    }

    @Test
    public void testEndsWithTailBytes() {
        this.assertEndsWithTail("11223344", false);
        this.assertEndsWithTail("00", false);
        this.assertEndsWithTail("0000", false);
        this.assertEndsWithTail("FFFF0000", false);
        this.assertEndsWithTail("880000FFFF", true);
        this.assertEndsWithTail("0000FFFF", true);
    }

    @Test
    public void testDraft21HelloUnCompressedBlock() {
        ExtensionTool.Tester tester = this.clientExtensions.newTester("permessage-deflate");
        tester.assertNegotiated("permessage-deflate");
        tester.parseIncomingHex("0xc1 0x07", "0xf2 0x48 0xcd 0xc9 0xc9 0x07 0x00");
        tester.assertHasFrames("Hello");
    }

    @Test
    public void testDraft21HelloUnCompressedBlockFragmented() {
        ExtensionTool.Tester tester = this.clientExtensions.newTester("permessage-deflate");
        tester.assertNegotiated("permessage-deflate");
        tester.parseIncomingHex("0x41 0x03 0xf2 0x48 0xcd", "0x80 0x04 0xc9 0xc9 0x07 0x00");
        tester.assertHasFrames(new Frame[]{new TextFrame().setPayload("He").setFin(false), new ContinuationFrame().setPayload("llo").setFin(true)});
    }

    @Test
    public void testDraft21SharingL77SlidingWindowContextTakeover() {
        ExtensionTool.Tester tester = this.clientExtensions.newTester("permessage-deflate");
        tester.assertNegotiated("permessage-deflate");
        tester.parseIncomingHex("0xc1 0x07", "0xf2 0x48 0xcd 0xc9 0xc9 0x07 0x00", "0xc1 0x07", "0xf2 0x48 0xcd 0xc9 0xc9 0x07 0x00");
        tester.assertHasFrames("Hello", "Hello");
    }

    @Test
    public void testDraft21SharingL77SlidingWindowNoContextTakeover() {
        ExtensionTool.Tester tester = this.clientExtensions.newTester("permessage-deflate");
        tester.assertNegotiated("permessage-deflate");
        tester.parseIncomingHex("0xc1 0x07", "0xf2 0x48 0xcd 0xc9 0xc9 0x07 0x00", "0xc1 0x05", "0xf2 0x00 0x11 0x00 0x00");
        tester.assertHasFrames("Hello", "Hello");
    }

    @Test
    public void testDraft21DeflateBlockWithNoCompression() {
        ExtensionTool.Tester tester = this.clientExtensions.newTester("permessage-deflate");
        tester.assertNegotiated("permessage-deflate");
        tester.parseIncomingHex("0xc1 0x0b 0x00 0x05 0x00 0xfa 0xff 0x48 0x65 0x6c 0x6c 0x6f 0x00");
        tester.assertHasFrames("Hello");
    }

    @Test
    public void testDraft21DeflateBlockWithBFinal1() {
        ExtensionTool.Tester tester = this.clientExtensions.newTester("permessage-deflate");
        tester.assertNegotiated("permessage-deflate");
        tester.parseIncomingHex("0xc1 0x08", "0xf3 0x48 0xcd 0xc9 0xc9 0x07 0x00 0x00");
        tester.assertHasFrames("Hello");
    }

    @Test
    public void testDraft21TwoDeflateBlocksOneMessage() {
        ExtensionTool.Tester tester = this.clientExtensions.newTester("permessage-deflate");
        tester.assertNegotiated("permessage-deflate");
        tester.parseIncomingHex("0xc1 0x0d", "0xf2 0x48 0x05 0x00 0x00 0x00 0xff 0xff 0xca 0xc9 0xc9 0x07 0x00");
        tester.assertHasFrames("Hello");
    }

    @Test
    public void testParseFragmentedMessageGood() {
        ExtensionTool.Tester tester = this.clientExtensions.newTester("permessage-deflate");
        tester.assertNegotiated("permessage-deflate");
        tester.parseIncomingHex("410C", "F248CDC9C95700000000FFFF", "000B", "0ACF2FCA4901000000FFFF", "8003", "520400");
        WebSocketFrame txtFrame = new TextFrame().setPayload("Hello ").setFin(false);
        WebSocketFrame con1Frame = new ContinuationFrame().setPayload("World").setFin(false);
        WebSocketFrame con2Frame = new ContinuationFrame().setPayload("!").setFin(true);
        tester.assertHasFrames(new Frame[]{txtFrame, con1Frame, con2Frame});
    }

    @Test
    public void testParseFragmentedMessageBadRsv1() {
        ExtensionTool.Tester tester = this.clientExtensions.newTester("permessage-deflate");
        tester.assertNegotiated("permessage-deflate");
        Assertions.assertThrows(ProtocolException.class, () -> tester.parseIncomingHex("410C", "F248CDC9C95700000000FFFF", "400B", "0ACF2FCA4901000000FFFF", "C003", "520400"));
    }

    @Test
    public void testIncomingPing() {
        PerMessageDeflateExtension ext = new PerMessageDeflateExtension();
        ext.setBufferPool(this.bufferPool);
        ext.setDeflaterPool(this.deflaterPool);
        ext.setInflaterPool(this.inflaterPool);
        ext.setPolicy(WebSocketPolicy.newServerPolicy());
        ExtensionConfig config = ExtensionConfig.parse((String)"permessage-deflate");
        ext.setConfig(config);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        ext.setNextIncomingFrames((IncomingFrames)capture);
        String payload = "Are you there?";
        PingFrame ping = new PingFrame().setPayload(payload);
        ext.incomingFrame((Frame)ping);
        capture.assertFrameCount(1);
        capture.assertHasFrame((byte)9, 1);
        WebSocketFrame actual = capture.getFrames().poll();
        MatcherAssert.assertThat((String)"Frame.opcode", (Object)actual.getOpCode(), (Matcher)Matchers.is((Object)9));
        MatcherAssert.assertThat((String)"Frame.fin", (Object)actual.isFin(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"Frame.rsv1", (Object)actual.isRsv1(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv2", (Object)actual.isRsv2(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv3", (Object)actual.isRsv3(), (Matcher)Matchers.is((Object)false));
        ByteBuffer expected = BufferUtil.toBuffer((String)payload, (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((String)"Frame.payloadLength", (Object)actual.getPayloadLength(), (Matcher)Matchers.is((Object)expected.remaining()));
        ByteBufferAssert.assertEquals((String)"Frame.payload", (ByteBuffer)expected, (ByteBuffer)actual.getPayload().slice());
    }

    @Test
    public void testIncomingFragmented() {
        PerMessageDeflateExtension ext = new PerMessageDeflateExtension();
        ext.setBufferPool(this.bufferPool);
        ext.setDeflaterPool(this.deflaterPool);
        ext.setInflaterPool(this.inflaterPool);
        ext.setPolicy(WebSocketPolicy.newServerPolicy());
        ExtensionConfig config = ExtensionConfig.parse((String)"permessage-deflate");
        ext.setConfig(config);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        ext.setNextIncomingFrames((IncomingFrames)capture);
        String payload = "Are you there?";
        PingFrame ping = new PingFrame().setPayload(payload);
        ext.incomingFrame((Frame)ping);
        capture.assertFrameCount(1);
        capture.assertHasFrame((byte)9, 1);
        WebSocketFrame actual = capture.getFrames().poll();
        MatcherAssert.assertThat((String)"Frame.opcode", (Object)actual.getOpCode(), (Matcher)Matchers.is((Object)9));
        MatcherAssert.assertThat((String)"Frame.fin", (Object)actual.isFin(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"Frame.rsv1", (Object)actual.isRsv1(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv2", (Object)actual.isRsv2(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv3", (Object)actual.isRsv3(), (Matcher)Matchers.is((Object)false));
        ByteBuffer expected = BufferUtil.toBuffer((String)payload, (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((String)"Frame.payloadLength", (Object)actual.getPayloadLength(), (Matcher)Matchers.is((Object)expected.remaining()));
        ByteBufferAssert.assertEquals((String)"Frame.payload", (ByteBuffer)expected, (ByteBuffer)actual.getPayload().slice());
    }

    @Test
    public void testIncomingUncompressedFrames() {
        PerMessageDeflateExtension ext = new PerMessageDeflateExtension();
        ext.setBufferPool(this.bufferPool);
        ext.setDeflaterPool(this.deflaterPool);
        ext.setInflaterPool(this.inflaterPool);
        ext.setPolicy(WebSocketPolicy.newServerPolicy());
        ExtensionConfig config = ExtensionConfig.parse((String)"permessage-deflate");
        ext.setConfig(config);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        ext.setNextIncomingFrames((IncomingFrames)capture);
        ArrayList<String> quote = new ArrayList<String>();
        quote.add("No amount of experimentation can ever prove me right;");
        quote.add("a single experiment can prove me wrong.");
        quote.add("-- Albert Einstein");
        for (String q : quote) {
            TextFrame frame = new TextFrame().setPayload(q);
            frame.setRsv1(false);
            ext.incomingFrame((Frame)frame);
        }
        int len = quote.size();
        capture.assertFrameCount(len);
        capture.assertHasFrame((byte)1, len);
        int i = 0;
        for (WebSocketFrame actual : capture.getFrames()) {
            String prefix = "Frame[" + i + "]";
            MatcherAssert.assertThat((String)(prefix + ".opcode"), (Object)actual.getOpCode(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((String)(prefix + ".fin"), (Object)actual.isFin(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((String)(prefix + ".rsv1"), (Object)actual.isRsv1(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((String)(prefix + ".rsv2"), (Object)actual.isRsv2(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((String)(prefix + ".rsv3"), (Object)actual.isRsv3(), (Matcher)Matchers.is((Object)false));
            ByteBuffer expected = BufferUtil.toBuffer((String)((String)quote.get(i)), (Charset)StandardCharsets.UTF_8);
            MatcherAssert.assertThat((String)(prefix + ".payloadLength"), (Object)actual.getPayloadLength(), (Matcher)Matchers.is((Object)expected.remaining()));
            ByteBufferAssert.assertEquals((String)(prefix + ".payload"), (ByteBuffer)expected, (ByteBuffer)actual.getPayload().slice());
            ++i;
        }
    }

    @Test
    public void testOutgoingPing() throws IOException {
        PerMessageDeflateExtension ext = new PerMessageDeflateExtension();
        ext.setBufferPool(this.bufferPool);
        ext.setDeflaterPool(this.deflaterPool);
        ext.setInflaterPool(this.inflaterPool);
        ext.setPolicy(WebSocketPolicy.newServerPolicy());
        ExtensionConfig config = ExtensionConfig.parse((String)"permessage-deflate");
        ext.setConfig(config);
        OutgoingFramesCapture capture = new OutgoingFramesCapture();
        ext.setNextOutgoingFrames((OutgoingFrames)capture);
        String payload = "Are you there?";
        PingFrame ping = new PingFrame().setPayload(payload);
        ext.outgoingFrame((Frame)ping, null, BatchMode.OFF);
        capture.assertFrameCount(1);
        capture.assertHasFrame((byte)9, 1);
        WebSocketFrame actual = capture.getFrames().getFirst();
        MatcherAssert.assertThat((String)"Frame.opcode", (Object)actual.getOpCode(), (Matcher)Matchers.is((Object)9));
        MatcherAssert.assertThat((String)"Frame.fin", (Object)actual.isFin(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"Frame.rsv1", (Object)actual.isRsv1(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv2", (Object)actual.isRsv2(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv3", (Object)actual.isRsv3(), (Matcher)Matchers.is((Object)false));
        ByteBuffer expected = BufferUtil.toBuffer((String)payload, (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((String)"Frame.payloadLength", (Object)actual.getPayloadLength(), (Matcher)Matchers.is((Object)expected.remaining()));
        ByteBufferAssert.assertEquals((String)"Frame.payload", (ByteBuffer)expected, (ByteBuffer)actual.getPayload().slice());
    }

    @Test
    public void testOutgoingFragmentedMessage() throws IOException, InterruptedException {
        PerMessageDeflateExtension ext = new PerMessageDeflateExtension();
        ext.setBufferPool(this.bufferPool);
        ext.setDeflaterPool(this.deflaterPool);
        ext.setInflaterPool(this.inflaterPool);
        ext.setPolicy(WebSocketPolicy.newServerPolicy());
        ExtensionConfig config = ExtensionConfig.parse((String)"permessage-deflate");
        ext.setConfig(config);
        OutgoingFramesCapture capture = new OutgoingFramesCapture();
        ext.setNextOutgoingFrames((OutgoingFrames)capture);
        WebSocketFrame txtFrame = new TextFrame().setPayload("Hello ").setFin(false);
        WebSocketFrame con1Frame = new ContinuationFrame().setPayload("World").setFin(false);
        WebSocketFrame con2Frame = new ContinuationFrame().setPayload("!").setFin(true);
        ext.outgoingFrame((Frame)txtFrame, null, BatchMode.OFF);
        ext.outgoingFrame((Frame)con1Frame, null, BatchMode.OFF);
        ext.outgoingFrame((Frame)con2Frame, null, BatchMode.OFF);
        capture.assertFrameCount(3);
        WebSocketFrame capturedFrame = capture.getFrames().poll(1L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((String)"Frame.opcode", (Object)capturedFrame.getOpCode(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"Frame.fin", (Object)capturedFrame.isFin(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv1", (Object)capturedFrame.isRsv1(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"Frame.rsv2", (Object)capturedFrame.isRsv2(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv3", (Object)capturedFrame.isRsv3(), (Matcher)Matchers.is((Object)false));
        capturedFrame = capture.getFrames().poll(1L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((String)"Frame.opcode", (Object)capturedFrame.getOpCode(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((String)"Frame.fin", (Object)capturedFrame.isFin(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv1", (Object)capturedFrame.isRsv1(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv2", (Object)capturedFrame.isRsv2(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv3", (Object)capturedFrame.isRsv3(), (Matcher)Matchers.is((Object)false));
        capturedFrame = capture.getFrames().poll(1L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((String)"Frame.opcode", (Object)capturedFrame.getOpCode(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((String)"Frame.fin", (Object)capturedFrame.isFin(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"Frame.rsv1", (Object)capturedFrame.isRsv1(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv2", (Object)capturedFrame.isRsv2(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv3", (Object)capturedFrame.isRsv3(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testPyWebSocketClientNoContextTakeoverThreeOra() {
        ExtensionTool.Tester tester = this.clientExtensions.newTester("permessage-deflate; client_max_window_bits; client_no_context_takeover");
        tester.assertNegotiated("permessage-deflate");
        tester.parseIncomingHex("c1 09 0a c9 2f 4a 0c 01  62 00 00", "c1 0b 72 2c c9 2f 4a 74  cb 01 12 00 00", "c1 0b 0a c8 c8 c9 2f 4a  0c 01 62 00 00");
        tester.assertHasFrames("ToraTora", "AtoraFlora", "PhloraTora");
    }

    @Test
    public void testPyWebSocketClientToraToraTora() {
        ExtensionTool.Tester tester = this.clientExtensions.newTester("permessage-deflate; client_max_window_bits");
        tester.assertNegotiated("permessage-deflate");
        tester.parseIncomingHex("c1 06 2a c9 2f 4a 04 00", "c1 05 2a 01 62 00 00", "c1 04 02 61 00 00");
        tester.assertHasFrames("tora", "tora", "tora");
    }

    @Test
    public void testPyWebSocketServerNoContextTakeoverThreeOra() {
        ExtensionTool.Tester tester = this.serverExtensions.newTester("permessage-deflate; client_max_window_bits; client_no_context_takeover");
        tester.assertNegotiated("permessage-deflate");
        tester.parseIncomingHex("c1 89 88 bc 1b b1 82 75  34 fb 84 bd 79 b1 88", "c1 8b 50 86 88 b2 22 aa  41 9d 1a f2 43 b3 42 86 88", "c1 8b e2 3e 05 53 e8 f6  cd 9a cd 74 09 52 80 3e 05");
        tester.assertHasFrames("ToraTora", "AtoraFlora", "PhloraTora");
    }

    @Test
    public void testPyWebSocketServerToraToraTora() {
        ExtensionTool.Tester tester = this.serverExtensions.newTester("permessage-deflate; client_max_window_bits");
        tester.assertNegotiated("permessage-deflate");
        tester.parseIncomingHex("c1 86 69 39 fe 91 43 f0  d1 db 6d 39", "c1 85 2d f3 eb 96 07 f2  89 96 2d", "c1 84 53 ad a5 34 51 cc  a5 34");
        tester.assertHasFrames("tora", "tora", "tora");
    }
}

