/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.extensions.identity.IdentityExtension;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.ByteBufferAssert;
import org.eclipse.jetty.websocket.common.test.IncomingFramesCapture;
import org.eclipse.jetty.websocket.common.test.OutgoingFramesCapture;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class IdentityExtensionTest {
    @Test
    public void testIncomingFrames() {
        IncomingFramesCapture capture = new IncomingFramesCapture();
        IdentityExtension ext = new IdentityExtension();
        ext.setNextIncomingFrames((IncomingFrames)capture);
        TextFrame frame = new TextFrame().setPayload("hello");
        ext.incomingFrame((Frame)frame);
        capture.assertFrameCount(1);
        capture.assertHasFrame((byte)1, 1);
        WebSocketFrame actual = capture.getFrames().poll();
        MatcherAssert.assertThat((String)"Frame.opcode", (Object)actual.getOpCode(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"Frame.fin", (Object)actual.isFin(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"Frame.rsv1", (Object)actual.isRsv1(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv2", (Object)actual.isRsv2(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv3", (Object)actual.isRsv3(), (Matcher)Matchers.is((Object)false));
        ByteBuffer expected = BufferUtil.toBuffer((String)"hello", (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((String)"Frame.payloadLength", (Object)actual.getPayloadLength(), (Matcher)Matchers.is((Object)expected.remaining()));
        ByteBufferAssert.assertEquals("Frame.payload", expected, actual.getPayload().slice());
    }

    @Test
    public void testOutgoingFrames() throws IOException {
        OutgoingFramesCapture capture = new OutgoingFramesCapture();
        IdentityExtension ext = new IdentityExtension();
        ext.setNextOutgoingFrames((OutgoingFrames)capture);
        TextFrame frame = new TextFrame().setPayload("hello");
        ext.outgoingFrame((Frame)frame, null, BatchMode.OFF);
        capture.assertFrameCount(1);
        capture.assertHasFrame((byte)1, 1);
        WebSocketFrame actual = capture.getFrames().getFirst();
        MatcherAssert.assertThat((String)"Frame.opcode", (Object)actual.getOpCode(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"Frame.fin", (Object)actual.isFin(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"Frame.rsv1", (Object)actual.isRsv1(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv2", (Object)actual.isRsv2(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv3", (Object)actual.isRsv3(), (Matcher)Matchers.is((Object)false));
        ByteBuffer expected = BufferUtil.toBuffer((String)"hello", (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((String)"Frame.payloadLength", (Object)actual.getPayloadLength(), (Matcher)Matchers.is((Object)expected.remaining()));
        ByteBufferAssert.assertEquals("Frame.payload", expected, actual.getPayload().slice());
    }
}

