/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Extension;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.common.Parser;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.extensions.WebSocketExtensionFactory;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.scopes.SimpleContainerScope;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.eclipse.jetty.websocket.common.test.ByteBufferAssert;
import org.eclipse.jetty.websocket.common.test.IncomingFramesCapture;
import org.eclipse.jetty.websocket.common.test.UnitParser;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class ExtensionTool {
    private final WebSocketPolicy policy;
    private final ExtensionFactory factory;

    public ExtensionTool(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this.policy = policy;
        SimpleContainerScope container = new SimpleContainerScope(policy, bufferPool);
        WebSocketExtensionFactory extFactory = new WebSocketExtensionFactory((WebSocketContainerScope)container);
        this.factory = extFactory;
    }

    public Tester newTester(String parameterizedExtension) {
        return new Tester(parameterizedExtension);
    }

    public class Tester {
        private String requestedExtParams;
        private ExtensionConfig extConfig;
        private Extension ext;
        private Parser parser;
        private IncomingFramesCapture capture;

        private Tester(String parameterizedExtension) {
            this.requestedExtParams = parameterizedExtension;
            this.extConfig = ExtensionConfig.parse((String)parameterizedExtension);
            Class extClass = ExtensionTool.this.factory.getExtension(this.extConfig.getName());
            MatcherAssert.assertThat((String)"extClass", (Object)extClass, (Matcher)Matchers.notNullValue());
            this.parser = new UnitParser(ExtensionTool.this.policy);
        }

        public String getRequestedExtParams() {
            return this.requestedExtParams;
        }

        public void assertNegotiated(String expectedNegotiation) {
            this.ext = ExtensionTool.this.factory.newInstance(this.extConfig);
            this.capture = new IncomingFramesCapture();
            this.ext.setNextIncomingFrames((IncomingFrames)this.capture);
            this.parser.configureFromExtensions(Collections.singletonList(this.ext));
            this.parser.setIncomingFramesHandler((IncomingFrames)this.ext);
        }

        public void parseIncomingHex(String ... rawhex) {
            int parts = rawhex.length;
            for (int i = 0; i < parts; ++i) {
                String hex = rawhex[i].replaceAll("\\s*(0x)?", "");
                byte[] net = TypeUtil.fromHexString((String)hex);
                this.parser.parse(ByteBuffer.wrap(net));
            }
        }

        public void assertHasFrames(String ... textFrames) {
            Frame[] frames = new Frame[textFrames.length];
            for (int i = 0; i < frames.length; ++i) {
                frames[i] = new TextFrame().setPayload(textFrames[i]);
            }
            this.assertHasFrames(frames);
        }

        public void assertHasFrames(Frame ... expectedFrames) {
            int expectedCount = expectedFrames.length;
            this.capture.assertFrameCount(expectedCount);
            for (int i = 0; i < expectedCount; ++i) {
                WebSocketFrame actual = this.capture.getFrames().poll();
                String prefix = String.format("frame[%d]", i);
                MatcherAssert.assertThat((String)(prefix + ".opcode"), (Object)actual.getOpCode(), (Matcher)Matchers.is((Object)expectedFrames[i].getOpCode()));
                MatcherAssert.assertThat((String)(prefix + ".fin"), (Object)actual.isFin(), (Matcher)Matchers.is((Object)expectedFrames[i].isFin()));
                MatcherAssert.assertThat((String)(prefix + ".rsv1"), (Object)actual.isRsv1(), (Matcher)Matchers.is((Object)false));
                MatcherAssert.assertThat((String)(prefix + ".rsv2"), (Object)actual.isRsv2(), (Matcher)Matchers.is((Object)false));
                MatcherAssert.assertThat((String)(prefix + ".rsv3"), (Object)actual.isRsv3(), (Matcher)Matchers.is((Object)false));
                ByteBuffer expected = expectedFrames[i].getPayload().slice();
                MatcherAssert.assertThat((String)(prefix + ".payloadLength"), (Object)actual.getPayloadLength(), (Matcher)Matchers.is((Object)expected.remaining()));
                ByteBufferAssert.assertEquals(prefix + ".payload", expected, actual.getPayload().slice());
            }
        }
    }
}

