/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Extension;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.extensions.DummyIncomingFrames;
import org.eclipse.jetty.websocket.common.extensions.DummyOutgoingFrames;
import org.eclipse.jetty.websocket.common.extensions.ExtensionStack;
import org.eclipse.jetty.websocket.common.extensions.WebSocketExtensionFactory;
import org.eclipse.jetty.websocket.common.extensions.identity.IdentityExtension;
import org.eclipse.jetty.websocket.common.scopes.SimpleContainerScope;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExtensionStackTest {
    private static final Logger LOG = Log.getLogger(ExtensionStackTest.class);
    public ByteBufferPool bufferPool = new MappedByteBufferPool();

    private <T> T assertIsExtension(String msg, Object obj, Class<T> clazz) {
        if (clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        Assertions.assertEquals((Object)clazz.getName(), (Object)obj.getClass().getName(), (String)("Expected " + msg + " class"));
        return null;
    }

    private ExtensionStack createExtensionStack() {
        WebSocketPolicy policy = WebSocketPolicy.newClientPolicy();
        SimpleContainerScope container = new SimpleContainerScope(policy, this.bufferPool);
        WebSocketExtensionFactory factory = new WebSocketExtensionFactory((WebSocketContainerScope)container);
        return new ExtensionStack((ExtensionFactory)factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartIdentity() throws Exception {
        ExtensionStack stack = this.createExtensionStack();
        try {
            ArrayList<ExtensionConfig> configs = new ArrayList<ExtensionConfig>();
            configs.add(ExtensionConfig.parse((String)"identity"));
            stack.negotiate(configs);
            DummyIncomingFrames session = new DummyIncomingFrames("Session");
            DummyOutgoingFrames connection = new DummyOutgoingFrames("Connection");
            stack.setNextOutgoing((OutgoingFrames)connection);
            stack.setNextIncoming((IncomingFrames)session);
            stack.start();
            LOG.debug("{}", new Object[]{stack.dump()});
            Extension actualIncomingExtension = (Extension)this.assertIsExtension("Incoming", stack.getNextIncoming(), IdentityExtension.class);
            Extension actualOutgoingExtension = (Extension)this.assertIsExtension("Outgoing", stack.getNextOutgoing(), IdentityExtension.class);
            Assertions.assertEquals((Object)actualIncomingExtension, (Object)actualOutgoingExtension);
        }
        finally {
            stack.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartIdentityTwice() throws Exception {
        ExtensionStack stack = this.createExtensionStack();
        try {
            ArrayList<ExtensionConfig> configs = new ArrayList<ExtensionConfig>();
            configs.add(ExtensionConfig.parse((String)"identity; id=A"));
            configs.add(ExtensionConfig.parse((String)"identity; id=B"));
            stack.negotiate(configs);
            DummyIncomingFrames session = new DummyIncomingFrames("Session");
            DummyOutgoingFrames connection = new DummyOutgoingFrames("Connection");
            stack.setNextOutgoing((OutgoingFrames)connection);
            stack.setNextIncoming((IncomingFrames)session);
            stack.start();
            LOG.debug("{}", new Object[]{stack.dump()});
            IdentityExtension actualIncomingExtension = this.assertIsExtension("Incoming", stack.getNextIncoming(), IdentityExtension.class);
            IdentityExtension actualOutgoingExtension = this.assertIsExtension("Outgoing", stack.getNextOutgoing(), IdentityExtension.class);
            MatcherAssert.assertThat((String)"Incoming[identity].id", (Object)actualIncomingExtension.getParam("id"), (Matcher)Matchers.is((Object)"A"));
            MatcherAssert.assertThat((String)"Outgoing[identity].id", (Object)actualOutgoingExtension.getParam("id"), (Matcher)Matchers.is((Object)"B"));
        }
        finally {
            stack.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartNothing() throws Exception {
        ExtensionStack stack = this.createExtensionStack();
        try {
            ArrayList configs = new ArrayList();
            stack.negotiate(configs);
            DummyIncomingFrames session = new DummyIncomingFrames("Session");
            DummyOutgoingFrames connection = new DummyOutgoingFrames("Connection");
            stack.setNextOutgoing((OutgoingFrames)connection);
            stack.setNextIncoming((IncomingFrames)session);
            stack.start();
            LOG.debug("{}", new Object[]{stack.dump()});
            Assertions.assertEquals((Object)stack.getNextIncoming(), (Object)session, (String)"Incoming Handler");
            Assertions.assertEquals((Object)stack.getNextOutgoing(), (Object)connection, (String)"Outgoing Handler");
        }
        finally {
            stack.stop();
        }
    }

    @Test
    public void testToString() {
        ExtensionStack stack = this.createExtensionStack();
        LOG.debug("Shouldn't cause a NPE: {}", new Object[]{stack.toString()});
    }

    @Test
    public void testNegotiateChrome32() {
        ExtensionStack stack = this.createExtensionStack();
        String chromeRequest = "permessage-deflate; client_max_window_bits, x-webkit-deflate-frame";
        List requestedConfigs = ExtensionConfig.parseList((String[])new String[]{chromeRequest});
        stack.negotiate(requestedConfigs);
        List negotiated = stack.getNegotiatedExtensions();
        String response = ExtensionConfig.toHeaderValue((List)negotiated);
        MatcherAssert.assertThat((String)"Negotiated Extensions", (Object)response, (Matcher)Matchers.is((Object)"permessage-deflate"));
        LOG.debug("Shouldn't cause a NPE: {}", new Object[]{stack.toString()});
    }
}

