/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.events;

import examples.AdapterConnectCloseSocket;
import examples.AnnotatedBinaryArraySocket;
import examples.AnnotatedBinaryStreamSocket;
import examples.AnnotatedFramesSocket;
import examples.AnnotatedTextSocket;
import examples.ListenerBasicSocket;
import examples.ListenerPingPongSocket;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.frames.BinaryFrame;
import org.eclipse.jetty.websocket.common.frames.PingFrame;
import org.eclipse.jetty.websocket.common.frames.PongFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.io.CloseableLocalWebSocketSession;
import org.eclipse.jetty.websocket.common.scopes.SimpleContainerScope;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.eclipse.jetty.websocket.common.test.MoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class EventDriverTest {
    public ByteBufferPool bufferPool = new MappedByteBufferPool();
    private WebSocketContainerScope container;

    @BeforeEach
    public void initContainer() {
        this.container = new SimpleContainerScope(WebSocketPolicy.newClientPolicy());
    }

    private Frame makeBinaryFrame(String content, boolean fin) {
        return new BinaryFrame().setPayload(content).setFin(fin);
    }

    @Test
    public void testAdapterConnectClose(TestInfo testInfo) throws Exception {
        AdapterConnectCloseSocket socket = new AdapterConnectCloseSocket();
        EventDriver driver = this.wrap((Object)socket);
        try (CloseableLocalWebSocketSession conn = new CloseableLocalWebSocketSession(this.container, testInfo.getDisplayName(), driver);){
            conn.open();
            driver.incomingFrame((Frame)new CloseInfo(1000).asFrame());
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onWebSocketConnect"));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onWebSocketClose"));
        }
    }

    @Test
    public void testAnnotatedByteArray(TestInfo testInfo) throws Exception {
        AnnotatedBinaryArraySocket socket = new AnnotatedBinaryArraySocket();
        EventDriver driver = this.wrap(socket);
        try (CloseableLocalWebSocketSession conn = new CloseableLocalWebSocketSession(this.container, testInfo.getDisplayName(), driver);){
            conn.open();
            driver.incomingFrame(this.makeBinaryFrame("Hello World", true));
            driver.incomingFrame((Frame)new CloseInfo(1000).asFrame());
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onConnect"));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.containsString((String)"onBinary([11],0,11)"));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onClose(1000,"));
        }
    }

    @Test
    public void testAnnotatedError(TestInfo testInfo) throws Exception {
        AnnotatedTextSocket socket = new AnnotatedTextSocket();
        EventDriver driver = this.wrap(socket);
        try (CloseableLocalWebSocketSession conn = new CloseableLocalWebSocketSession(this.container, testInfo.getDisplayName(), driver);){
            conn.open();
            driver.onError((Throwable)new WebSocketException("oof"));
            driver.incomingFrame((Frame)new CloseInfo(1000).asFrame());
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onConnect"));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onError(WebSocketException: oof)"));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onClose(1000,"));
        }
    }

    @Test
    public void testAnnotatedFrames(TestInfo testInfo) throws Exception {
        AnnotatedFramesSocket socket = new AnnotatedFramesSocket();
        EventDriver driver = this.wrap(socket);
        try (CloseableLocalWebSocketSession conn = new CloseableLocalWebSocketSession(this.container, testInfo.getDisplayName(), driver);){
            conn.open();
            driver.incomingFrame((Frame)new PingFrame().setPayload("PING"));
            driver.incomingFrame((Frame)new TextFrame().setPayload("Text Me"));
            driver.incomingFrame((Frame)new BinaryFrame().setPayload("Hello Bin"));
            driver.incomingFrame((Frame)new CloseInfo(1001, "testcase").asFrame());
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onConnect("));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onFrame(PING["));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onFrame(TEXT["));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onFrame(BINARY["));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onFrame(CLOSE["));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onClose(1001,"));
        }
    }

    @Test
    public void testAnnotatedInputStream(TestInfo testInfo) throws InterruptedException {
        AnnotatedBinaryStreamSocket socket = new AnnotatedBinaryStreamSocket();
        EventDriver driver = this.wrap(socket);
        try (CloseableLocalWebSocketSession conn = new CloseableLocalWebSocketSession(this.container, testInfo.getDisplayName(), driver);){
            conn.open();
            driver.incomingFrame(this.makeBinaryFrame("Hello World", true));
            driver.incomingFrame((Frame)new CloseInfo(1000).asFrame());
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onConnect"));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), MoreMatchers.regex("^onBinary\\(.*InputStream.*"));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onClose(1000,"));
        }
    }

    @Test
    public void testListenerBasicText(TestInfo testInfo) throws Exception {
        ListenerBasicSocket socket = new ListenerBasicSocket();
        EventDriver driver = this.wrap(socket);
        try (CloseableLocalWebSocketSession conn = new CloseableLocalWebSocketSession(this.container, testInfo.getDisplayName(), driver);){
            conn.start();
            conn.open();
            driver.incomingFrame((Frame)new TextFrame().setPayload("Hello World"));
            driver.incomingFrame((Frame)new CloseInfo(1000).asFrame());
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onWebSocketConnect"));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onWebSocketText(\"Hello World\")"));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onWebSocketClose(1000,"));
        }
    }

    @Test
    public void testListenerPingPong(TestInfo testInfo) throws Exception {
        ListenerPingPongSocket socket = new ListenerPingPongSocket();
        EventDriver driver = this.wrap(socket);
        try (CloseableLocalWebSocketSession conn = new CloseableLocalWebSocketSession(this.container, testInfo.getDisplayName(), driver);){
            conn.start();
            conn.open();
            driver.incomingFrame((Frame)new PingFrame().setPayload("PING"));
            driver.incomingFrame((Frame)new PongFrame().setPayload("PONG"));
            driver.incomingFrame((Frame)new CloseInfo(1000).asFrame());
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onWebSocketConnect"));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onWebSocketPing("));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onWebSocketPong("));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onWebSocketClose(1000,"));
        }
    }

    @Test
    public void testListenerEmptyPingPong(TestInfo testInfo) throws Exception {
        ListenerPingPongSocket socket = new ListenerPingPongSocket();
        EventDriver driver = this.wrap(socket);
        try (CloseableLocalWebSocketSession conn = new CloseableLocalWebSocketSession(this.container, testInfo.getDisplayName(), driver);){
            conn.start();
            conn.open();
            driver.incomingFrame((Frame)new PingFrame());
            driver.incomingFrame((Frame)new PongFrame());
            driver.incomingFrame((Frame)new CloseInfo(1000).asFrame());
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onWebSocketConnect"));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onWebSocketPing("));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onWebSocketPong("));
            MatcherAssert.assertThat((Object)socket.capture.safePoll(), (Matcher)Matchers.startsWith((String)"onWebSocketClose(1000,"));
        }
    }

    private EventDriver wrap(Object websocket) {
        WebSocketPolicy policy = WebSocketPolicy.newServerPolicy();
        EventDriverFactory factory = new EventDriverFactory((WebSocketContainerScope)new SimpleContainerScope(policy));
        return factory.wrap(websocket);
    }
}

