/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.ab;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.eclipse.jetty.websocket.api.ProtocolException;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.common.Parser;
import org.eclipse.jetty.websocket.common.test.IncomingFramesCapture;
import org.eclipse.jetty.websocket.common.test.UnitParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestABCase4 {
    private WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.CLIENT);

    @Test
    public void testParserControlOpCode11Case421() throws Exception {
        ByteBuffer expected = ByteBuffer.allocate(32);
        expected.put(new byte[]{-117, 0});
        expected.flip();
        IncomingFramesCapture capture = new IncomingFramesCapture();
        try (StacklessLogging ignore = new StacklessLogging(new Class[]{Parser.class});){
            UnitParser parser = new UnitParser(this.policy);
            parser.setIncomingFramesHandler(capture);
            Assertions.assertThrows(ProtocolException.class, () -> parser.parse(expected));
        }
    }

    @Test
    public void testParserControlOpCode12WithPayloadCase422() throws Exception {
        ByteBuffer expected = ByteBuffer.allocate(32);
        expected.put(new byte[]{-116, 1, 0});
        expected.flip();
        IncomingFramesCapture capture = new IncomingFramesCapture();
        try (StacklessLogging ignore = new StacklessLogging(new Class[]{Parser.class});){
            UnitParser parser = new UnitParser(this.policy);
            parser.setIncomingFramesHandler(capture);
            Assertions.assertThrows(ProtocolException.class, () -> parser.parse(expected));
        }
    }

    @Test
    public void testParserNonControlOpCode3Case411() throws Exception {
        ByteBuffer expected = ByteBuffer.allocate(32);
        expected.put(new byte[]{-125, 0});
        expected.flip();
        IncomingFramesCapture capture = new IncomingFramesCapture();
        try (StacklessLogging ignore = new StacklessLogging(new Class[]{Parser.class});){
            UnitParser parser = new UnitParser(this.policy);
            parser.setIncomingFramesHandler(capture);
            Assertions.assertThrows(ProtocolException.class, () -> parser.parse(expected));
        }
    }

    @Test
    public void testParserNonControlOpCode4WithPayloadCase412() throws Exception {
        ByteBuffer expected = ByteBuffer.allocate(32);
        expected.put(new byte[]{-124, 1, 0});
        expected.flip();
        IncomingFramesCapture capture = new IncomingFramesCapture();
        try (StacklessLogging ignore = new StacklessLogging(new Class[]{Parser.class});){
            UnitParser parser = new UnitParser(this.policy);
            parser.setIncomingFramesHandler(capture);
            Assertions.assertThrows(ProtocolException.class, () -> parser.parse(expected));
        }
    }
}

