/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.ab;

import java.util.stream.Stream;
import org.eclipse.jetty.websocket.api.ProtocolException;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.PingFrame;
import org.eclipse.jetty.websocket.common.frames.PongFrame;
import org.eclipse.jetty.websocket.common.test.UnitGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestABCase3 {
    public static Stream<Arguments> badFrames() {
        return Stream.of(new PingFrame().setFin(false), new PingFrame().setRsv1(true), new PingFrame().setRsv2(true), new PingFrame().setRsv3(true), new PongFrame().setFin(false), new PingFrame().setRsv1(true), new PongFrame().setRsv2(true), new PongFrame().setRsv3(true), new CloseInfo().asFrame().setFin(false), new CloseInfo().asFrame().setRsv1(true), new CloseInfo().asFrame().setRsv2(true), new CloseInfo().asFrame().setRsv3(true)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"badFrames"})
    public void testGenerateInvalidControlFrame(WebSocketFrame invalidFrame) {
        Assertions.assertThrows(ProtocolException.class, () -> UnitGenerator.generate((Frame)invalidFrame));
    }
}

