/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.ab;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.frames.BinaryFrame;
import org.eclipse.jetty.websocket.common.test.ByteBufferAssert;
import org.eclipse.jetty.websocket.common.test.IncomingFramesCapture;
import org.eclipse.jetty.websocket.common.test.UnitGenerator;
import org.eclipse.jetty.websocket.common.test.UnitParser;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class TestABCase12 {
    private WebSocketPolicy policy = WebSocketPolicy.newClientPolicy();

    @Test
    public void testGenerate125ByteBinaryCase122() {
        int length = 125;
        ByteBuffer bb = ByteBuffer.allocate(length);
        for (int i = 0; i < length; ++i) {
            bb.put("*".getBytes());
        }
        bb.flip();
        BinaryFrame binaryFrame = new BinaryFrame().setPayload(bb);
        ByteBuffer actual = UnitGenerator.generate((Frame)binaryFrame);
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-126});
        byte b = 0;
        b = (byte)(b | length & 0x7F);
        expected.put(b);
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        BufferUtil.flipToFlush((ByteBuffer)expected, (int)0);
        ByteBufferAssert.assertEquals(expected, actual, "buffers do not match");
    }

    @Test
    public void testGenerate126ByteBinaryCase123() {
        int length = 126;
        ByteBuffer bb = ByteBuffer.allocate(length);
        for (int i = 0; i < length; ++i) {
            bb.put("*".getBytes());
        }
        bb.flip();
        BinaryFrame binaryFrame = new BinaryFrame().setPayload(bb);
        ByteBuffer actual = UnitGenerator.generate((Frame)binaryFrame);
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-126});
        byte b = 0;
        b = (byte)(b | length & 0x7E);
        expected.put(b);
        expected.putShort((short)length);
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        BufferUtil.flipToFlush((ByteBuffer)expected, (int)0);
        ByteBufferAssert.assertEquals(expected, actual, "buffers do not match");
    }

    @Test
    public void testGenerate127ByteBinaryCase124() {
        int length = 127;
        ByteBuffer bb = ByteBuffer.allocate(length);
        for (int i = 0; i < length; ++i) {
            bb.put("*".getBytes());
        }
        bb.flip();
        BinaryFrame binaryFrame = new BinaryFrame().setPayload(bb);
        ByteBuffer actual = UnitGenerator.generate((Frame)binaryFrame);
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-126});
        byte b = 0;
        b = (byte)(b | length & 0x7E);
        expected.put(b);
        expected.putShort((short)length);
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        BufferUtil.flipToFlush((ByteBuffer)expected, (int)0);
        ByteBufferAssert.assertEquals(expected, actual, "buffers do not match");
    }

    @Test
    public void testGenerate128ByteBinaryCase125() {
        int length = 128;
        ByteBuffer bb = ByteBuffer.allocate(length);
        for (int i = 0; i < length; ++i) {
            bb.put("*".getBytes());
        }
        bb.flip();
        BinaryFrame binaryFrame = new BinaryFrame().setPayload(bb);
        ByteBuffer actual = UnitGenerator.generate((Frame)binaryFrame);
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-126});
        byte b = 0;
        b = (byte)(b | 0x7E);
        expected.put(b);
        expected.put((byte)(length >> 8));
        expected.put((byte)(length & 0xFF));
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        BufferUtil.flipToFlush((ByteBuffer)expected, (int)0);
        ByteBufferAssert.assertEquals(expected, actual, "buffers do not match");
    }

    @Test
    public void testGenerate65535ByteBinaryCase126() {
        int length = 65535;
        ByteBuffer bb = ByteBuffer.allocate(length);
        for (int i = 0; i < length; ++i) {
            bb.put("*".getBytes());
        }
        bb.flip();
        BinaryFrame binaryFrame = new BinaryFrame().setPayload(bb);
        ByteBuffer actual = UnitGenerator.generate((Frame)binaryFrame);
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-126});
        byte b = 0;
        b = (byte)(b | 0x7E);
        expected.put(b);
        expected.put(new byte[]{-1, -1});
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        BufferUtil.flipToFlush((ByteBuffer)expected, (int)0);
        ByteBufferAssert.assertEquals(expected, actual, "buffers do not match");
    }

    @Test
    public void testGenerate65536ByteBinaryCase127() {
        int length = 65536;
        ByteBuffer bb = ByteBuffer.allocate(length);
        for (int i = 0; i < length; ++i) {
            bb.put("*".getBytes());
        }
        bb.flip();
        BinaryFrame binaryFrame = new BinaryFrame().setPayload(bb);
        ByteBuffer actual = UnitGenerator.generate((Frame)binaryFrame);
        ByteBuffer expected = ByteBuffer.allocate(length + 11);
        expected.put(new byte[]{-126});
        byte b = 0;
        b = (byte)(b | 0x7F);
        expected.put(b);
        expected.put(new byte[]{0, 0, 0, 0, 0, 1, 0, 0});
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        BufferUtil.flipToFlush((ByteBuffer)expected, (int)0);
        ByteBufferAssert.assertEquals(expected, actual, "buffers do not match");
    }

    @Test
    public void testGenerateEmptyBinaryCase121() {
        BinaryFrame binaryFrame = new BinaryFrame().setPayload(new byte[0]);
        ByteBuffer actual = UnitGenerator.generate((Frame)binaryFrame);
        ByteBuffer expected = ByteBuffer.allocate(5);
        expected.put(new byte[]{-126, 0});
        BufferUtil.flipToFlush((ByteBuffer)expected, (int)0);
        ByteBufferAssert.assertEquals(expected, actual, "buffers do not match");
    }

    @Test
    public void testParse125ByteBinaryCase122() {
        int length = 125;
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-126});
        byte b = 0;
        b = (byte)(b | length & 0x7F);
        expected.put(b);
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)2, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"BinaryFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)length));
    }

    @Test
    public void testParse126ByteBinaryCase123() {
        int length = 126;
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-126});
        byte b = 0;
        b = (byte)(b | length & 0x7E);
        expected.put(b);
        expected.putShort((short)length);
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)2, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"BinaryFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)length));
    }

    @Test
    public void testParse127ByteBinaryCase124() {
        int length = 127;
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-126});
        byte b = 0;
        b = (byte)(b | length & 0x7E);
        expected.put(b);
        expected.putShort((short)length);
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)2, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"BinaryFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)length));
    }

    @Test
    public void testParse128ByteBinaryCase125() {
        int length = 128;
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-126});
        byte b = 0;
        b = (byte)(b | 0x7E);
        expected.put(b);
        expected.putShort((short)length);
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)2, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"BinaryFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)length));
    }

    @Test
    public void testParse65535ByteBinaryCase126() {
        int length = 65535;
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-126});
        byte b = 0;
        b = (byte)(b | 0x7E);
        expected.put(b);
        expected.put(new byte[]{-1, -1});
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        expected.flip();
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.CLIENT);
        policy.setMaxBinaryMessageSize(length);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)2, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"BinaryFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)length));
    }

    @Test
    public void testParse65536ByteBinaryCase127() {
        int length = 65536;
        ByteBuffer expected = ByteBuffer.allocate(length + 11);
        expected.put(new byte[]{-126});
        byte b = 0;
        b = (byte)(b | 0x7F);
        expected.put(b);
        expected.put(new byte[]{0, 0, 0, 0, 0, 1, 0, 0});
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        expected.flip();
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.CLIENT);
        policy.setMaxBinaryMessageSize(length);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)2, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"BinaryFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)length));
    }

    @Test
    public void testParseEmptyBinaryCase121() {
        ByteBuffer expected = ByteBuffer.allocate(5);
        expected.put(new byte[]{-126, 0});
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)2, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"BinaryFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)0));
    }
}

