/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.ab;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.ByteBufferAssert;
import org.eclipse.jetty.websocket.common.test.IncomingFramesCapture;
import org.eclipse.jetty.websocket.common.test.UnitGenerator;
import org.eclipse.jetty.websocket.common.test.UnitParser;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class TestABCase11 {
    private WebSocketPolicy policy = WebSocketPolicy.newClientPolicy();

    @Test
    public void testGenerate125ByteTextCase112() {
        int length = 125;
        byte[] buf = new byte[length];
        Arrays.fill(buf, (byte)42);
        String text = new String(buf, StandardCharsets.UTF_8);
        TextFrame textFrame = new TextFrame().setPayload(text);
        ByteBuffer actual = UnitGenerator.generate((Frame)textFrame);
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-127});
        byte b = 0;
        b = (byte)(b | length & 0x7F);
        expected.put(b);
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        expected.flip();
        ByteBufferAssert.assertEquals(expected, actual, "buffers do not match");
    }

    @Test
    public void testGenerate126ByteTextCase113() {
        int length = 126;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append("*");
        }
        TextFrame textFrame = new TextFrame().setPayload(builder.toString());
        ByteBuffer actual = UnitGenerator.generate((Frame)textFrame);
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-127});
        byte b = 0;
        b = (byte)(b | length & 0x7E);
        expected.put(b);
        expected.putShort((short)length);
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        expected.flip();
        ByteBufferAssert.assertEquals(expected, actual, "buffers do not match");
    }

    @Test
    public void testGenerate127ByteTextCase114() {
        int length = 127;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append("*");
        }
        TextFrame textFrame = new TextFrame().setPayload(builder.toString());
        ByteBuffer actual = UnitGenerator.generate((Frame)textFrame);
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-127});
        byte b = 0;
        b = (byte)(b | length & 0x7E);
        expected.put(b);
        expected.putShort((short)length);
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        expected.flip();
        ByteBufferAssert.assertEquals(expected, actual, "buffers do not match");
    }

    @Test
    public void testGenerate128ByteTextCase115() {
        int length = 128;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append("*");
        }
        TextFrame textFrame = new TextFrame().setPayload(builder.toString());
        ByteBuffer actual = UnitGenerator.generate((Frame)textFrame);
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-127});
        byte b = 0;
        b = (byte)(b | 0x7E);
        expected.put(b);
        expected.put((byte)(length >> 8));
        expected.put((byte)(length & 0xFF));
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        expected.flip();
        ByteBufferAssert.assertEquals(expected, actual, "buffers do not match");
    }

    @Test
    public void testGenerate65535ByteTextCase116() {
        int length = 65535;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append("*");
        }
        TextFrame textFrame = new TextFrame().setPayload(builder.toString());
        ByteBuffer actual = UnitGenerator.generate((Frame)textFrame);
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-127});
        byte b = 0;
        b = (byte)(b | 0x7E);
        expected.put(b);
        expected.put(new byte[]{-1, -1});
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        expected.flip();
        ByteBufferAssert.assertEquals(expected, actual, "buffers do not match");
    }

    @Test
    public void testGenerate65536ByteTextCase117() {
        int length = 65536;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append("*");
        }
        TextFrame textFrame = new TextFrame().setPayload(builder.toString());
        ByteBuffer actual = UnitGenerator.generate((Frame)textFrame);
        ByteBuffer expected = ByteBuffer.allocate(length + 11);
        expected.put(new byte[]{-127});
        byte b = 0;
        b = (byte)(b | 0x7F);
        expected.put(b);
        expected.put(new byte[]{0, 0, 0, 0, 0, 1, 0, 0});
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        expected.flip();
        ByteBufferAssert.assertEquals(expected, actual, "buffers do not match");
    }

    @Test
    public void testGenerateEmptyTextCase111() {
        TextFrame textFrame = new TextFrame().setPayload("");
        ByteBuffer actual = UnitGenerator.generate((Frame)textFrame);
        ByteBuffer expected = ByteBuffer.allocate(5);
        expected.put(new byte[]{-127, 0});
        expected.flip();
        ByteBufferAssert.assertEquals(expected, actual, "buffers do not match");
    }

    @Test
    public void testParse125ByteTextCase112() {
        int length = 125;
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-127});
        byte b = 0;
        b = (byte)(b | length & 0x7F);
        expected.put(b);
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)1, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"TextFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)length));
    }

    @Test
    public void testParse126ByteTextCase113() {
        int length = 126;
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-127});
        byte b = 0;
        b = (byte)(b | length & 0x7E);
        expected.put(b);
        expected.putShort((short)length);
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)1, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"TextFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)length));
    }

    @Test
    public void testParse127ByteTextCase114() {
        int length = 127;
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-127});
        byte b = 0;
        b = (byte)(b | length & 0x7E);
        expected.put(b);
        expected.putShort((short)length);
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)1, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"TextFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)length));
    }

    @Test
    public void testParse128ByteTextCase115() {
        int length = 128;
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-127});
        byte b = 0;
        b = (byte)(b | 0x7E);
        expected.put(b);
        expected.putShort((short)length);
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)1, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"TextFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)length));
    }

    @Test
    public void testParse65535ByteTextCase116() {
        int length = 65535;
        ByteBuffer expected = ByteBuffer.allocate(length + 5);
        expected.put(new byte[]{-127});
        byte b = 0;
        b = (byte)(b | 0x7E);
        expected.put(b);
        expected.put(new byte[]{-1, -1});
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        expected.flip();
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.CLIENT);
        policy.setMaxTextMessageSize(length);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)1, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"TextFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)length));
    }

    @Test
    public void testParse65536ByteTextCase117() {
        int length = 65536;
        ByteBuffer expected = ByteBuffer.allocate(length + 11);
        expected.put(new byte[]{-127});
        byte b = 0;
        b = (byte)(b | 0x7F);
        expected.put(b);
        expected.put(new byte[]{0, 0, 0, 0, 0, 1, 0, 0});
        for (int i = 0; i < length; ++i) {
            expected.put("*".getBytes());
        }
        expected.flip();
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.CLIENT);
        policy.setMaxTextMessageSize(length);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)1, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"TextFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)length));
    }

    @Test
    public void testParseEmptyTextCase111() {
        ByteBuffer expected = ByteBuffer.allocate(5);
        expected.put(new byte[]{-127, 0});
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)1, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"TextFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)0));
    }
}

