/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.jetty.websocket.api.MessageTooLargeException;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.test.IncomingFramesCapture;
import org.eclipse.jetty.websocket.common.test.UnitParser;
import org.eclipse.jetty.websocket.common.util.MaskedByteBuffer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TextPayloadParserTest {
    @Test
    public void testFrameTooLargeDueToPolicy() throws Exception {
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        policy.setInputBufferSize(1024);
        policy.setMaxTextMessageBufferSize(1024);
        policy.setMaxTextMessageSize(1024);
        byte[] utf = new byte[2048];
        Arrays.fill(utf, (byte)97);
        MatcherAssert.assertThat((String)"Must be a medium length payload", (Object)utf.length, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(126)), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(65535))));
        ByteBuffer buf = ByteBuffer.allocate(utf.length + 8);
        buf.put((byte)-127);
        buf.put((byte)-2);
        buf.putShort((short)utf.length);
        MaskedByteBuffer.putMask(buf);
        MaskedByteBuffer.putPayload(buf, utf);
        buf.flip();
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        Assertions.assertThrows(MessageTooLargeException.class, () -> parser.parseQuietly(buf));
    }

    @Test
    public void testLongMaskedText() throws Exception {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 3500; ++i) {
            sb.append("Hell\uff4f Big W\uff4frld ");
        }
        sb.append(". The end.");
        String expectedText = sb.toString();
        byte[] utf = expectedText.getBytes(StandardCharsets.UTF_8);
        MatcherAssert.assertThat((String)"Must be a long length payload", (Object)utf.length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(65535)));
        ByteBuffer buf = ByteBuffer.allocate(utf.length + 32);
        buf.put((byte)-127);
        buf.put((byte)-1);
        buf.putLong(utf.length);
        MaskedByteBuffer.putMask(buf);
        MaskedByteBuffer.putPayload(buf, utf);
        buf.flip();
        WebSocketPolicy policy = WebSocketPolicy.newServerPolicy();
        policy.setMaxTextMessageSize(100000);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(buf);
        capture.assertHasFrame((byte)1, 1);
        WebSocketFrame txt = capture.getFrames().poll();
        MatcherAssert.assertThat((String)"TextFrame.data", (Object)txt.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)expectedText));
    }

    @Test
    public void testMediumMaskedText() throws Exception {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 14; ++i) {
            sb.append("Hell\uff4f Medium W\uff4frld ");
        }
        sb.append(". The end.");
        String expectedText = sb.toString();
        byte[] utf = expectedText.getBytes(StandardCharsets.UTF_8);
        MatcherAssert.assertThat((String)"Must be a medium length payload", (Object)utf.length, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(126)), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(65535))));
        ByteBuffer buf = ByteBuffer.allocate(utf.length + 10);
        buf.put((byte)-127);
        buf.put((byte)-2);
        buf.putShort((short)utf.length);
        MaskedByteBuffer.putMask(buf);
        MaskedByteBuffer.putPayload(buf, utf);
        buf.flip();
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(buf);
        capture.assertHasFrame((byte)1, 1);
        WebSocketFrame txt = capture.getFrames().poll();
        MatcherAssert.assertThat((String)"TextFrame.data", (Object)txt.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)expectedText));
    }

    @Test
    public void testShortMaskedFragmentedText() throws Exception {
        String part1 = "Hello ";
        String part2 = "World";
        byte[] b1 = part1.getBytes(StandardCharsets.UTF_8);
        byte[] b2 = part2.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buf = ByteBuffer.allocate(32);
        buf.put((byte)1);
        buf.put((byte)(0x80 | b1.length));
        MaskedByteBuffer.putMask(buf);
        MaskedByteBuffer.putPayload(buf, b1);
        buf.put((byte)-128);
        buf.put((byte)(0x80 | b2.length));
        MaskedByteBuffer.putMask(buf);
        MaskedByteBuffer.putPayload(buf, b2);
        buf.flip();
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(buf);
        capture.assertHasFrame((byte)1, 1);
        capture.assertHasFrame((byte)0, 1);
        WebSocketFrame txt = capture.getFrames().poll();
        MatcherAssert.assertThat((String)"TextFrame[0].data", (Object)txt.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)part1));
        txt = capture.getFrames().poll();
        MatcherAssert.assertThat((String)"TextFrame[1].data", (Object)txt.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)part2));
    }

    @Test
    public void testShortMaskedText() throws Exception {
        String expectedText = "Hello World";
        byte[] utf = expectedText.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buf = ByteBuffer.allocate(24);
        buf.put((byte)-127);
        buf.put((byte)(0x80 | utf.length));
        MaskedByteBuffer.putMask(buf);
        MaskedByteBuffer.putPayload(buf, utf);
        buf.flip();
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(buf);
        capture.assertHasFrame((byte)1, 1);
        WebSocketFrame txt = capture.getFrames().poll();
        MatcherAssert.assertThat((String)"TextFrame.data", (Object)txt.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)expectedText));
    }

    @Test
    public void testShortMaskedUtf8Text() throws Exception {
        String expectedText = "Hell\uff4f W\uff4frld";
        byte[] utf = expectedText.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buf = ByteBuffer.allocate(24);
        buf.put((byte)-127);
        buf.put((byte)(0x80 | utf.length));
        MaskedByteBuffer.putMask(buf);
        MaskedByteBuffer.putPayload(buf, utf);
        buf.flip();
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(buf);
        capture.assertHasFrame((byte)1, 1);
        WebSocketFrame txt = capture.getFrames().poll();
        MatcherAssert.assertThat((String)"TextFrame.data", (Object)txt.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)expectedText));
    }
}

