/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.OpCode;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;

public class SaneFrameOrderingAssertion
implements OutgoingFrames {
    boolean priorDataFrame = false;
    public int frameCount = 0;

    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        byte opcode = frame.getOpCode();
        MatcherAssert.assertThat((String)("OpCode.isKnown(" + opcode + ")"), (Object)OpCode.isKnown((byte)opcode), (Matcher)Matchers.is((Object)true));
        switch (opcode) {
            case 1: {
                Assertions.assertFalse((boolean)this.priorDataFrame, (String)("Unexpected " + OpCode.name((byte)opcode) + " frame, was expecting CONTINUATION"));
                break;
            }
            case 2: {
                Assertions.assertFalse((boolean)this.priorDataFrame, (String)("Unexpected " + OpCode.name((byte)opcode) + " frame, was expecting CONTINUATION"));
                break;
            }
            case 0: {
                Assertions.assertTrue((boolean)this.priorDataFrame, (String)"CONTINUATION frame without prior !FIN");
                break;
            }
            case 8: {
                Assertions.assertFalse((boolean)frame.isFin(), (String)("Fragmented Close Frame [" + OpCode.name((byte)opcode) + "]"));
                break;
            }
            case 9: {
                Assertions.assertFalse((boolean)frame.isFin(), (String)("Fragmented Close Frame [" + OpCode.name((byte)opcode) + "]"));
                break;
            }
            case 10: {
                Assertions.assertFalse((boolean)frame.isFin(), (String)("Fragmented Close Frame [" + OpCode.name((byte)opcode) + "]"));
            }
        }
        if (OpCode.isDataFrame((byte)opcode)) {
            this.priorDataFrame = !frame.isFin();
        }
        ++this.frameCount;
        if (callback != null) {
            callback.writeSuccess();
        }
    }
}

