/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.api.ProtocolException;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.ContinuationFrame;
import org.eclipse.jetty.websocket.common.frames.PingFrame;
import org.eclipse.jetty.websocket.common.frames.PongFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.IncomingFramesCapture;
import org.eclipse.jetty.websocket.common.test.UnitGenerator;
import org.eclipse.jetty.websocket.common.test.UnitParser;
import org.eclipse.jetty.websocket.common.util.Hex;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ParserTest {
    @Test
    public void testParseCase515() {
        ArrayList<WebSocketFrame> send = new ArrayList<WebSocketFrame>();
        send.add(new TextFrame().setPayload("fragment1").setFin(false));
        send.add(new ContinuationFrame().setPayload("fragment2").setFin(true));
        send.add(new ContinuationFrame().setPayload("fragment3").setFin(false));
        send.add(new TextFrame().setPayload("fragment4").setFin(true));
        send.add((WebSocketFrame)new CloseInfo(1000).asFrame());
        ByteBuffer completeBuf = UnitGenerator.generate(send);
        UnitParser parser = new UnitParser();
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        ProtocolException x = (ProtocolException)Assertions.assertThrows(ProtocolException.class, () -> parser.parseQuietly(completeBuf));
        MatcherAssert.assertThat((Object)x.getMessage(), (Matcher)Matchers.containsString((String)"CONTINUATION frame without prior !FIN"));
    }

    @Test
    public void testParseCase518() {
        ArrayList<WebSocketFrame> send = new ArrayList<WebSocketFrame>();
        send.add(new TextFrame().setPayload("fragment1").setFin(false));
        send.add(new TextFrame().setPayload("fragment2").setFin(true));
        send.add((WebSocketFrame)new CloseInfo(1000).asFrame());
        ByteBuffer completeBuf = UnitGenerator.generate(send);
        UnitParser parser = new UnitParser();
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        ProtocolException x = (ProtocolException)Assertions.assertThrows(ProtocolException.class, () -> parser.parseQuietly(completeBuf));
        MatcherAssert.assertThat((Object)x.getMessage(), (Matcher)Matchers.containsString((String)"Unexpected TEXT frame"));
    }

    @Test
    public void testParseCase519() {
        ArrayList<WebSocketFrame> send = new ArrayList<WebSocketFrame>();
        send.add(new TextFrame().setPayload("f1").setFin(false));
        send.add(new ContinuationFrame().setPayload(",f2").setFin(false));
        send.add((WebSocketFrame)new PingFrame().setPayload("pong-1"));
        send.add(new ContinuationFrame().setPayload(",f3").setFin(false));
        send.add(new ContinuationFrame().setPayload(",f4").setFin(false));
        send.add((WebSocketFrame)new PingFrame().setPayload("pong-2"));
        send.add(new ContinuationFrame().setPayload(",f5").setFin(true));
        send.add((WebSocketFrame)new CloseInfo(1000).asFrame());
        ByteBuffer completeBuf = UnitGenerator.generate(send);
        UnitParser parser = new UnitParser();
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parseQuietly(completeBuf);
        capture.assertHasFrame((byte)1, 1);
        capture.assertHasFrame((byte)0, 4);
        capture.assertHasFrame((byte)8, 1);
        capture.assertHasFrame((byte)9, 2);
    }

    @Test
    public void testParseCase56() {
        ArrayList<WebSocketFrame> send = new ArrayList<WebSocketFrame>();
        send.add((WebSocketFrame)new PongFrame().setPayload("ping"));
        send.add((WebSocketFrame)new TextFrame().setPayload("hello, world"));
        send.add((WebSocketFrame)new CloseInfo(1000).asFrame());
        ByteBuffer completeBuf = UnitGenerator.generate(send);
        UnitParser parser = new UnitParser();
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(completeBuf);
        capture.assertHasFrame((byte)1, 1);
        capture.assertHasFrame((byte)8, 1);
        capture.assertHasFrame((byte)10, 1);
    }

    @Test
    public void testParseCase623() {
        String utf8 = "Hello-\uc2b5@\uc39f\uc3a4\uc3bc\uc3a0\uc3a1-UTF-8!!";
        byte[] msg = StringUtil.getUtf8Bytes((String)utf8);
        ArrayList<WebSocketFrame> send = new ArrayList<WebSocketFrame>();
        int textCount = 0;
        int continuationCount = 0;
        int len = msg.length;
        boolean continuation = false;
        for (int i = 0; i < len; ++i) {
            ContinuationFrame frame = null;
            if (continuation) {
                frame = new ContinuationFrame();
                ++continuationCount;
            } else {
                frame = new TextFrame();
                ++textCount;
            }
            byte[] mini = new byte[]{msg[i]};
            frame.setPayload(ByteBuffer.wrap(mini));
            boolean isLast = i >= len - 1;
            frame.setFin(isLast);
            send.add((WebSocketFrame)frame);
            continuation = true;
        }
        send.add((WebSocketFrame)new CloseInfo(1000).asFrame());
        ByteBuffer completeBuf = UnitGenerator.generate(send);
        UnitParser parser = new UnitParser();
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(completeBuf);
        capture.assertHasFrame((byte)1, textCount);
        capture.assertHasFrame((byte)0, continuationCount);
        capture.assertHasFrame((byte)8, 1);
    }

    @Test
    public void testParseNothing() {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.flip();
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(buf);
        MatcherAssert.assertThat((String)"Frame Count", (Object)capture.getFrames().size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testWindowedParseLargeFrame() {
        byte[] payload = new byte[65536];
        Arrays.fill(payload, (byte)42);
        ArrayList<WebSocketFrame> frames = new ArrayList<WebSocketFrame>();
        TextFrame text = new TextFrame();
        text.setPayload(ByteBuffer.wrap(payload));
        text.setMask(Hex.asByteArray("11223344"));
        frames.add((WebSocketFrame)text);
        frames.add((WebSocketFrame)new CloseInfo(1000).asFrame());
        ByteBuffer networkBytes = UnitGenerator.generate(frames);
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        while (networkBytes.remaining() > 0) {
            ByteBuffer window = networkBytes.slice();
            int windowSize = Math.min(window.remaining(), 4096);
            window.limit(windowSize);
            parser.parse(window);
            networkBytes.position(networkBytes.position() + windowSize);
        }
        MatcherAssert.assertThat((String)"Frame Count", (Object)capture.getFrames().size(), (Matcher)Matchers.is((Object)2));
        WebSocketFrame frame = capture.getFrames().poll();
        MatcherAssert.assertThat((String)"Frame[0].opcode", (Object)frame.getOpCode(), (Matcher)Matchers.is((Object)1));
        ByteBuffer actualPayload = frame.getPayload();
        MatcherAssert.assertThat((String)"Frame[0].payload.length", (Object)actualPayload.remaining(), (Matcher)Matchers.is((Object)payload.length));
        for (int i = actualPayload.position(); i < actualPayload.remaining(); ++i) {
            MatcherAssert.assertThat((String)"Frame[0].payload[i]", (Object)actualPayload.get(i), (Matcher)Matchers.is((Object)42));
        }
    }
}

