/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.examples;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.LeakTrackingByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class TestClient {
    private static boolean _verbose = false;
    private static final Random __random = new Random();
    private static LeakTrackingByteBufferPool bufferPool = new LeakTrackingByteBufferPool((ByteBufferPool)new MappedByteBufferPool());
    private final String _host;
    private final int _port;
    private final String _protocol;
    private final int _timeout;
    private static int __framesSent;
    private static int __messagesSent;
    private static AtomicInteger __framesReceived;
    private static AtomicInteger __messagesReceived;
    private static AtomicLong __totalTime;
    private static AtomicLong __minDuration;
    private static AtomicLong __maxDuration;
    private static long __start;
    private BlockingQueue<Long> _starts = new LinkedBlockingQueue<Long>();
    int _messageBytes;
    int _frames;
    byte _opcode = (byte)-1;
    private WebSocketClient client;
    private TestSocket socket;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int i;
        String host = "localhost";
        int port = 8080;
        String protocol = null;
        int count = 10;
        int size = 64;
        int fragment = 4000;
        boolean binary = false;
        int clients = 1;
        int delay = 1000;
        for (int i2 = 0; i2 < args.length; ++i2) {
            String a = args[i2];
            if ("-p".equals(a) || "--port".equals(a)) {
                port = Integer.parseInt(args[++i2]);
                continue;
            }
            if ("-h".equals(a) || "--host".equals(a)) {
                host = args[++i2];
                continue;
            }
            if ("-c".equals(a) || "--count".equals(a)) {
                count = Integer.parseInt(args[++i2]);
                continue;
            }
            if ("-s".equals(a) || "--size".equals(a)) {
                size = Integer.parseInt(args[++i2]);
                continue;
            }
            if ("-f".equals(a) || "--fragment".equals(a)) {
                fragment = Integer.parseInt(args[++i2]);
                continue;
            }
            if ("-P".equals(a) || "--protocol".equals(a)) {
                protocol = args[++i2];
                continue;
            }
            if ("-v".equals(a) || "--verbose".equals(a)) {
                _verbose = true;
                continue;
            }
            if ("-b".equals(a) || "--binary".equals(a)) {
                binary = true;
                continue;
            }
            if ("-C".equals(a) || "--clients".equals(a)) {
                clients = Integer.parseInt(args[++i2]);
                continue;
            }
            if ("-d".equals(a) || "--delay".equals(a)) {
                delay = Integer.parseInt(args[++i2]);
                continue;
            }
            if (!a.startsWith("-")) continue;
            TestClient.usage(args);
        }
        TestClient[] client = new TestClient[clients];
        WebSocketClient wsclient = new WebSocketClient((ByteBufferPool)bufferPool);
        try {
            wsclient.start();
            __start = System.currentTimeMillis();
            protocol = protocol == null ? "echo" : protocol;
            for (i = 0; i < clients; ++i) {
                client[i] = new TestClient(wsclient, host, port, protocol, 60000);
                client[i].open();
            }
            System.out.println("Jetty WebSocket PING " + host + ":" + port + " (" + new InetSocketAddress(host, port) + ") " + clients + " clients " + protocol);
            for (int p = 0; p < count; ++p) {
                long next = System.currentTimeMillis() + (long)delay;
                byte op = 1;
                if (binary) {
                    op = 2;
                }
                byte[] data = null;
                switch (op) {
                    case 1: {
                        StringBuilder b = new StringBuilder();
                        while (b.length() < size) {
                            b.append(65 + __random.nextInt(26));
                        }
                        data = b.toString().getBytes(StandardCharsets.UTF_8);
                        break;
                    }
                    case 2: {
                        data = new byte[size];
                        __random.nextBytes(data);
                    }
                }
                for (int i3 = 0; i3 < clients; ++i3) {
                    client[i3].send(op, data, fragment);
                }
                while (System.currentTimeMillis() < next) {
                    Thread.sleep(10L);
                }
            }
        }
        catch (Throwable throwable) {
            for (int i4 = 0; i4 < clients; ++i4) {
                if (client[i4] == null) continue;
                client[i4].disconnect();
            }
            long duration = System.currentTimeMillis() - __start;
            System.out.println("--- " + host + " websocket ping statistics using " + clients + " connection" + (clients > 1 ? "s" : "") + " ---");
            System.out.printf("%d/%d frames sent/recv, %d/%d mesg sent/recv, time %dms %dm/s %.2fbps%n", __framesSent, __framesReceived.get(), __messagesSent, __messagesReceived.get(), duration, 1000L * (long)__messagesReceived.get() / duration, 1000.0 * (double)__messagesReceived.get() * 8.0 * (double)size / (double)duration / 1024.0 / 1024.0);
            System.out.printf("rtt min/ave/max = %.3f/%.3f/%.3f ms\n", (double)__minDuration.get() / 1000000.0, __messagesReceived.get() == 0 ? 0.0 : (double)(__totalTime.get() / (long)__messagesReceived.get()) / 1000000.0, (double)__maxDuration.get() / 1000000.0);
            wsclient.stop();
            throw throwable;
        }
        for (i = 0; i < clients; ++i) {
            if (client[i] == null) continue;
            client[i].disconnect();
        }
        long duration = System.currentTimeMillis() - __start;
        System.out.println("--- " + host + " websocket ping statistics using " + clients + " connection" + (clients > 1 ? "s" : "") + " ---");
        System.out.printf("%d/%d frames sent/recv, %d/%d mesg sent/recv, time %dms %dm/s %.2fbps%n", __framesSent, __framesReceived.get(), __messagesSent, __messagesReceived.get(), duration, 1000L * (long)__messagesReceived.get() / duration, 1000.0 * (double)__messagesReceived.get() * 8.0 * (double)size / (double)duration / 1024.0 / 1024.0);
        System.out.printf("rtt min/ave/max = %.3f/%.3f/%.3f ms\n", (double)__minDuration.get() / 1000000.0, __messagesReceived.get() == 0 ? 0.0 : (double)(__totalTime.get() / (long)__messagesReceived.get()) / 1000000.0, (double)__maxDuration.get() / 1000000.0);
        wsclient.stop();
    }

    private static void usage(String[] args) {
        System.err.println("ERROR: " + Arrays.asList(args));
        System.err.println("USAGE: java -cp CLASSPATH " + TestClient.class + " [ OPTIONS ]");
        System.err.println("  -h|--host HOST  (default localhost)");
        System.err.println("  -p|--port PORT  (default 8080)");
        System.err.println("  -b|--binary");
        System.err.println("  -v|--verbose");
        System.err.println("  -c|--count n    (default 10)");
        System.err.println("  -s|--size n     (default 64)");
        System.err.println("  -f|--fragment n (default 4000) ");
        System.err.println("  -P|--protocol echo|echo-assemble|echo-fragment|echo-broadcast");
        System.err.println("  -C|--clients n  (default 1) ");
        System.err.println("  -d|--delay n    (default 1000ms) ");
        System.exit(1);
    }

    public TestClient(WebSocketClient client, String host, int port, String protocol, int timeoutMS) throws Exception {
        this.client = client;
        this._host = host;
        this._port = port;
        this._protocol = protocol;
        this._timeout = timeoutMS;
    }

    private void disconnect() {
    }

    private void open() throws Exception {
        this.client.getPolicy().setIdleTimeout((long)this._timeout);
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        request.setSubProtocols(new String[]{this._protocol});
        this.socket = new TestSocket();
        URI wsUri = new URI("ws://" + this._host + ":" + this._port + "/");
        this.client.connect((Object)this.socket, wsUri, request).get(10L, TimeUnit.SECONDS);
    }

    private void send(byte op, byte[] data, int fragment) {
        this.socket.send(op, data, fragment);
    }

    static {
        __framesReceived = new AtomicInteger();
        __messagesReceived = new AtomicInteger();
        __totalTime = new AtomicLong();
        __minDuration = new AtomicLong(Long.MAX_VALUE);
        __maxDuration = new AtomicLong(Long.MIN_VALUE);
    }

    public class TestSocket
    extends WebSocketAdapter {
        public void onWebSocketBinary(byte[] payload, int offset, int len) {
        }

        public void onWebSocketClose(int statusCode, String reason) {
            super.onWebSocketClose(statusCode, reason);
        }

        public void onWebSocketConnect(Session session) {
            if (_verbose) {
                System.err.printf("%s#onWebSocketConnect %s %s\n", ((Object)((Object)this)).getClass().getSimpleName(), session, session.getClass().getSimpleName());
            }
        }

        public void send(byte op, byte[] data, int maxFragmentLength) {
            TestClient.this._starts.add(System.nanoTime());
            int off = 0;
            int len = data.length;
            if (maxFragmentLength > 0 && len > maxFragmentLength) {
                len = maxFragmentLength;
            }
            __messagesSent++;
            while (off < data.length) {
                __framesSent++;
                if (data.length - (off += len) > len) {
                    len = data.length - off;
                }
                if (maxFragmentLength <= 0 || len <= maxFragmentLength) continue;
                len = maxFragmentLength;
            }
        }
    }
}

