/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class WebSocketClientInitTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitHttpClientStartedOutside() throws Exception {
        HttpClient http = new HttpClient();
        http.start();
        try {
            WebSocketClient ws = new WebSocketClient(http);
            ws.start();
            try {
                MatcherAssert.assertThat((String)"HttpClient", (Object)ws.getHttpClient(), (Matcher)Matchers.is((Object)http));
                MatcherAssert.assertThat((String)"WebSocketClient started", (Object)ws.isStarted(), (Matcher)Matchers.is((Object)true));
                MatcherAssert.assertThat((String)"HttpClient started", (Object)http.isStarted(), (Matcher)Matchers.is((Object)true));
                HttpClient httpBean = (HttpClient)ws.getBean(HttpClient.class);
                MatcherAssert.assertThat((String)"HttpClient bean is managed", (Object)ws.isManaged((Object)httpBean), (Matcher)Matchers.is((Object)false));
                MatcherAssert.assertThat((String)"WebSocketClient should not be found in HttpClient", (Object)((WebSocketClient)http.getBean(WebSocketClient.class)), (Matcher)Matchers.nullValue());
            }
            finally {
                ws.stop();
            }
            MatcherAssert.assertThat((String)"WebSocketClient stopped", (Object)ws.isStopped(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((String)"HttpClient stopped", (Object)http.isStopped(), (Matcher)Matchers.is((Object)false));
        }
        finally {
            http.stop();
        }
        MatcherAssert.assertThat((String)"HttpClient stopped", (Object)http.isStopped(), (Matcher)Matchers.is((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitHttpClientSyntheticStart() throws Exception {
        HttpClient http = null;
        WebSocketClient ws = new WebSocketClient();
        ws.start();
        try {
            http = ws.getHttpClient();
            MatcherAssert.assertThat((String)"WebSocketClient started", (Object)ws.isStarted(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((String)"HttpClient started", (Object)http.isStarted(), (Matcher)Matchers.is((Object)true));
            HttpClient httpBean = (HttpClient)ws.getBean(HttpClient.class);
            MatcherAssert.assertThat((String)"HttpClient bean found in WebSocketClient", (Object)httpBean, (Matcher)Matchers.is((Object)http));
            MatcherAssert.assertThat((String)"HttpClient bean is managed", (Object)ws.isManaged((Object)httpBean), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((String)"WebSocketClient should not be found in HttpClient", (Object)((WebSocketClient)http.getBean(WebSocketClient.class)), (Matcher)Matchers.nullValue());
        }
        finally {
            ws.stop();
        }
        MatcherAssert.assertThat((String)"WebSocketClient stopped", (Object)ws.isStopped(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"HttpClient stopped", (Object)http.isStopped(), (Matcher)Matchers.is((Object)true));
    }
}

