/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.eclipse.jetty.websocket.client.JettyTrackingSocket;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class WebSocketClientBadUriTest {
    private WebSocketClient client;

    public static Stream<Arguments> data() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        data.add(new String[]{"http://localhost"});
        data.add(new String[]{"https://localhost"});
        data.add(new String[]{"file://localhost"});
        data.add(new String[]{"content://localhost"});
        data.add(new String[]{"jar://localhost"});
        data.add(new String[]{"/mysocket"});
        data.add(new String[]{"/sockets/echo"});
        data.add(new String[]{"#echo"});
        data.add(new String[]{"localhost:8080/echo"});
        return data.stream().map(Arguments::of);
    }

    @BeforeEach
    public void startClient() throws Exception {
        this.client = new WebSocketClient();
        this.client.start();
    }

    @AfterEach
    public void stopClient() throws Exception {
        this.client.stop();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testBadURI(String uriStr) throws Exception {
        JettyTrackingSocket wsocket = new JettyTrackingSocket();
        URI uri = URI.create(uriStr);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.client.connect((Object)wsocket, uri));
        wsocket.assertNotOpened();
    }
}

