/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.common.test.BlockheadConnection;
import org.eclipse.jetty.websocket.common.test.BlockheadServer;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TomcatServerQuirksTest {
    private static BlockheadServer server;

    @BeforeAll
    public static void startServer() throws Exception {
        server = new BlockheadServer();
        server.start();
    }

    @AfterAll
    public static void stopServer() throws Exception {
        server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTomcat7032WithTransferEncoding() throws Exception {
        WebSocketClient client = new WebSocketClient();
        server.setRequestHandling((req, resp) -> {
            resp.setHeader("Transfer-Encoding", "chunked");
            return false;
        });
        try {
            int bufferSize = 512;
            client.start();
            LatchedSocket websocket = new LatchedSocket();
            CompletableFuture serverConnFut = new CompletableFuture();
            server.addConnectFuture(serverConnFut);
            URI wsURI = server.getWsUri();
            client.connect((Object)websocket, wsURI);
            Assertions.assertTrue((boolean)websocket.openLatch.await(1L, TimeUnit.SECONDS), (String)"Timed out waiting for Client side WebSocket open event");
            try (BlockheadConnection serverConn = (BlockheadConnection)serverConnFut.get(2L, Timeouts.CONNECT_UNIT);){
                byte[] payload = new byte[256];
                Arrays.fill(payload, (byte)120);
                ByteBuffer serverFrame = BufferUtil.allocate((int)512);
                BufferUtil.flipToFill((ByteBuffer)serverFrame);
                serverFrame.put((byte)-127);
                serverFrame.put((byte)126);
                serverFrame.put((byte)(payload.length >> 8));
                serverFrame.put((byte)(payload.length & 0xFF));
                serverFrame.put(payload);
                BufferUtil.flipToFlush((ByteBuffer)serverFrame, (int)0);
                serverConn.writeRaw(serverFrame);
            }
            Assertions.assertTrue((boolean)websocket.dataLatch.await(1000L, TimeUnit.SECONDS));
        }
        finally {
            client.stop();
        }
    }

    public static class LatchedSocket
    extends WebSocketAdapter {
        final CountDownLatch openLatch = new CountDownLatch(1);
        final CountDownLatch dataLatch = new CountDownLatch(1);
        final CountDownLatch closeLatch = new CountDownLatch(1);

        public void onWebSocketClose(int statusCode, String reason) {
            this.closeLatch.countDown();
        }

        public void onWebSocketConnect(Session session) {
            this.openLatch.countDown();
        }

        public void onWebSocketText(String message) {
            this.dataLatch.countDown();
        }
    }
}

