/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;

@WebSocket(maxTextMessageSize=102400)
public class MaxMessageSocket {
    private static final Logger LOG = Log.getLogger(MaxMessageSocket.class);
    private Session session;
    public CountDownLatch openLatch = new CountDownLatch(1);
    public CountDownLatch closeLatch = new CountDownLatch(1);
    public CountDownLatch dataLatch = new CountDownLatch(1);
    public LinkedBlockingQueue<String> messageQueue = new LinkedBlockingQueue();
    public LinkedBlockingQueue<Throwable> errorQueue = new LinkedBlockingQueue();
    public int closeCode = -1;
    public StringBuilder closeMessage = new StringBuilder();

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.session = session;
        this.openLatch.countDown();
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        LOG.debug("onWebSocketClose({},{})", new Object[]{statusCode, reason});
        this.closeCode = statusCode;
        this.closeMessage.append(reason);
        this.closeLatch.countDown();
    }

    @OnWebSocketMessage
    public void onMessage(String message) {
        LOG.debug("onWebSocketText({})", new Object[]{message});
        this.messageQueue.offer(message);
        this.dataLatch.countDown();
    }

    @OnWebSocketError
    public void onError(Throwable cause) {
        LOG.debug("onWebSocketError", cause);
        MatcherAssert.assertThat((String)"Error capture", (Object)this.errorQueue.offer(cause), (Matcher)Matchers.is((Object)true));
    }

    public Session getSession() {
        return this.session;
    }

    public void awaitConnect(int duration, TimeUnit unit) throws InterruptedException {
        MatcherAssert.assertThat((String)"Client Socket connected", (Object)this.openLatch.await(duration, unit), (Matcher)Matchers.is((Object)true));
    }

    public void waitForMessage(int timeoutDuration, TimeUnit timeoutUnit) throws InterruptedException {
        LOG.debug("Waiting for message", new Object[0]);
        MatcherAssert.assertThat((String)"Message Received", (Object)this.dataLatch.await(timeoutDuration, timeoutUnit), (Matcher)Matchers.is((Object)true));
    }

    public void assertMessage(String expected) {
        String actual = this.messageQueue.poll();
        Assertions.assertEquals((Object)expected, (Object)actual, (String)"Message");
    }
}

