/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Exchanger;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class JettyTrackingSocket
extends WebSocketAdapter {
    private static final Logger LOG = Log.getLogger(JettyTrackingSocket.class);
    public int closeCode = -1;
    public Exchanger<String> messageExchanger;
    public UpgradeRequest connectUpgradeRequest;
    public UpgradeResponse connectUpgradeResponse;
    public StringBuilder closeMessage = new StringBuilder();
    public CountDownLatch openLatch = new CountDownLatch(1);
    public CountDownLatch closeLatch = new CountDownLatch(1);
    public CountDownLatch dataLatch = new CountDownLatch(1);
    public LinkedBlockingQueue<String> messageQueue = new LinkedBlockingQueue();
    public LinkedBlockingQueue<Throwable> errorQueue = new LinkedBlockingQueue();

    public void assertClose(int expectedStatusCode, String expectedReason) throws InterruptedException {
        this.assertCloseCode(expectedStatusCode);
        this.assertCloseReason(expectedReason);
    }

    public void assertCloseCode(int expectedCode) throws InterruptedException {
        MatcherAssert.assertThat((String)"Was Closed", (Object)this.closeLatch.await(50L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)("Close Code / Received [" + this.closeMessage + "]"), (Object)this.closeCode, (Matcher)Matchers.is((Object)expectedCode));
    }

    private void assertCloseReason(String expectedReason) {
        MatcherAssert.assertThat((String)"Close Reason", (Object)this.closeMessage.toString(), (Matcher)Matchers.is((Object)expectedReason));
    }

    public void assertIsOpen() throws InterruptedException {
        this.assertWasOpened();
        this.assertNotClosed();
    }

    public void assertNotClosed() {
        LOG.debug("assertNotClosed() - {}", this.closeLatch.getCount());
        MatcherAssert.assertThat((String)"Closed Latch", (Object)this.closeLatch.getCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1L)));
    }

    public void assertNotOpened() {
        LOG.debug("assertNotOpened() - {}", this.openLatch.getCount());
        MatcherAssert.assertThat((String)"Open Latch", (Object)this.openLatch.getCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1L)));
    }

    public void assertWasOpened() throws InterruptedException {
        LOG.debug("assertWasOpened() - {}", this.openLatch.getCount());
        MatcherAssert.assertThat((String)"Was Opened", (Object)this.openLatch.await(30L, TimeUnit.SECONDS), (Matcher)Matchers.is((Object)true));
    }

    public void clear() {
        this.messageQueue.clear();
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        LOG.debug("onWebSocketBinary()", new Object[0]);
        this.dataLatch.countDown();
    }

    public void onWebSocketClose(int statusCode, String reason) {
        LOG.debug("onWebSocketClose({},{})", new Object[]{statusCode, reason});
        super.onWebSocketClose(statusCode, reason);
        this.closeCode = statusCode;
        this.closeMessage.append(reason);
        this.closeLatch.countDown();
    }

    public void onWebSocketConnect(Session session) {
        super.onWebSocketConnect(session);
        MatcherAssert.assertThat((String)"Session", (Object)session, (Matcher)Matchers.notNullValue());
        this.connectUpgradeRequest = session.getUpgradeRequest();
        this.connectUpgradeResponse = session.getUpgradeResponse();
        this.openLatch.countDown();
    }

    public void onWebSocketError(Throwable cause) {
        LOG.debug("onWebSocketError", cause);
        MatcherAssert.assertThat((String)"Error capture", (Object)this.errorQueue.offer(cause), (Matcher)Matchers.is((Object)true));
    }

    public void onWebSocketText(String message) {
        LOG.debug("onWebSocketText({})", new Object[]{message});
        this.messageQueue.offer(message);
        this.dataLatch.countDown();
        if (this.messageExchanger != null) {
            try {
                this.messageExchanger.exchange(message);
            }
            catch (InterruptedException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    public void waitForClose(int timeoutDuration, TimeUnit timeoutUnit) throws InterruptedException {
        MatcherAssert.assertThat((String)"Client Socket Closed", (Object)this.closeLatch.await(timeoutDuration, timeoutUnit), (Matcher)Matchers.is((Object)true));
    }

    public void waitForConnected() throws InterruptedException {
        MatcherAssert.assertThat((String)"Client Socket Connected", (Object)this.openLatch.await(2L, Timeouts.CONNECT_UNIT), (Matcher)Matchers.is((Object)true));
    }

    public void waitForMessage(int timeoutDuration, TimeUnit timeoutUnit) throws InterruptedException {
        LOG.debug("Waiting for message", new Object[0]);
        MatcherAssert.assertThat((String)"Message Received", (Object)this.dataLatch.await(timeoutDuration, timeoutUnit), (Matcher)Matchers.is((Object)true));
    }

    public void close() {
        this.getSession().close();
    }
}

