/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadClassLoaderScope;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Test;

public class HttpClientInitTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultInit() throws Exception {
        WebSocketClient client = new WebSocketClient();
        try {
            client.start();
            HttpClient httpClient = client.getHttpClient();
            MatcherAssert.assertThat((String)"HttpClient exists", (Object)httpClient, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)"HttpClient is started", (Object)httpClient.isStarted(), (Matcher)Is.is((Object)true));
            Executor executor = httpClient.getExecutor();
            MatcherAssert.assertThat((String)"Executor exists", (Object)executor, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)"Executor instanceof", (Object)executor, (Matcher)Matchers.instanceOf(QueuedThreadPool.class));
            QueuedThreadPool threadPool = (QueuedThreadPool)executor;
            MatcherAssert.assertThat((String)"QueuedThreadPool.name", (Object)threadPool.getName(), (Matcher)Matchers.startsWith((String)"WebSocketClient@"));
        }
        finally {
            client.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManualInit() throws Exception {
        HttpClient http = new HttpClient();
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("ManualWSClient@" + http.hashCode());
        http.setExecutor((Executor)threadPool);
        http.setConnectTimeout(7777L);
        WebSocketClient client = new WebSocketClient(http);
        client.addBean((Object)http);
        try {
            client.start();
            HttpClient httpClient = client.getHttpClient();
            MatcherAssert.assertThat((String)"HttpClient exists", (Object)httpClient, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)"HttpClient is started", (Object)httpClient.isStarted(), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((String)"HttpClient.connectTimeout", (Object)httpClient.getConnectTimeout(), (Matcher)Is.is((Object)7777L));
            Executor executor = httpClient.getExecutor();
            MatcherAssert.assertThat((String)"Executor exists", (Object)executor, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)"Executor instanceof", (Object)executor, (Matcher)Matchers.instanceOf(QueuedThreadPool.class));
            QueuedThreadPool threadPool2 = (QueuedThreadPool)executor;
            MatcherAssert.assertThat((String)"QueuedThreadPool.name", (Object)threadPool2.getName(), (Matcher)Matchers.startsWith((String)"ManualWSClient@"));
        }
        finally {
            client.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXmlResourceInit() throws Exception {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        URL[] urls = new URL[]{MavenTestingUtils.getTestResourceDir((String)"httpclient/simple").toURI().toURL()};
        URLClassLoader classLoader = new URLClassLoader(urls, parent);
        try (ThreadClassLoaderScope scope = new ThreadClassLoaderScope((ClassLoader)classLoader);){
            WebSocketClient client = new WebSocketClient();
            try {
                client.start();
                HttpClient httpClient = client.getHttpClient();
                MatcherAssert.assertThat((String)"HttpClient exists", (Object)httpClient, (Matcher)Matchers.notNullValue());
                MatcherAssert.assertThat((String)"HttpClient is started", (Object)httpClient.isStarted(), (Matcher)Is.is((Object)true));
                MatcherAssert.assertThat((String)"HttpClient.connectTimeout", (Object)httpClient.getConnectTimeout(), (Matcher)Is.is((Object)5555L));
                SslContextFactory sslContextFactory = httpClient.getSslContextFactory();
                List<String> actualExcludedProtocols = Arrays.asList(sslContextFactory.getExcludeProtocols());
                MatcherAssert.assertThat((String)"HttpClient.sslContextFactory.excludedProtocols", actualExcludedProtocols, (Matcher)Matchers.hasItem((Object)"TLS/0.1"));
                Executor executor = httpClient.getExecutor();
                MatcherAssert.assertThat((String)"Executor exists", (Object)executor, (Matcher)Matchers.notNullValue());
                MatcherAssert.assertThat((String)"Executor instanceof", (Object)executor, (Matcher)Matchers.instanceOf(QueuedThreadPool.class));
                QueuedThreadPool threadPool = (QueuedThreadPool)executor;
                MatcherAssert.assertThat((String)"QueuedThreadPool.name", (Object)threadPool.getName(), (Matcher)Matchers.startsWith((String)"XmlBasedClient@"));
            }
            finally {
                client.stop();
            }
        }
    }
}

