/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.net.CookieManager;
import java.net.HttpCookie;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.BlockheadConnection;
import org.eclipse.jetty.websocket.common.test.BlockheadServer;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CookieTest {
    private static final Logger LOG = Log.getLogger(CookieTest.class);
    private static BlockheadServer server;
    private WebSocketClient client;

    @BeforeEach
    public void startClient() throws Exception {
        this.client = new WebSocketClient();
        this.client.start();
    }

    @BeforeAll
    public static void startServer() throws Exception {
        server = new BlockheadServer();
        server.start();
    }

    @AfterEach
    public void stopClient() throws Exception {
        if (this.client.isRunning()) {
            this.client.stop();
        }
    }

    @AfterAll
    public static void stopServer() throws Exception {
        server.stop();
    }

    @Test
    public void testViaCookieManager() throws Exception {
        CookieManager cookieMgr = new CookieManager();
        this.client.setCookieStore(cookieMgr.getCookieStore());
        HttpCookie cookie = new HttpCookie("hello", "world");
        cookie.setPath("/");
        cookie.setVersion(0);
        cookie.setMaxAge(100000L);
        cookieMgr.getCookieStore().add(server.getWsUri(), cookie);
        cookie = new HttpCookie("foo", "bar is the word");
        cookie.setPath("/");
        cookie.setMaxAge(100000L);
        cookieMgr.getCookieStore().add(server.getWsUri(), cookie);
        CompletableFuture serverConnFut = new CompletableFuture();
        server.addConnectFuture(serverConnFut);
        CookieTrackingSocket clientSocket = new CookieTrackingSocket();
        Future clientConnectFuture = this.client.connect((Object)clientSocket, server.getWsUri());
        try (BlockheadConnection serverConn = (BlockheadConnection)serverConnFut.get(2L, Timeouts.CONNECT_UNIT);){
            String serverCookies = this.confirmClientUpgradeAndCookies(clientSocket, clientConnectFuture, serverConn);
            MatcherAssert.assertThat((String)"Cookies seen at server side", (Object)serverCookies, (Matcher)Matchers.containsString((String)"hello=world"));
            MatcherAssert.assertThat((String)"Cookies seen at server side", (Object)serverCookies, (Matcher)Matchers.containsString((String)"foo=bar is the word"));
        }
    }

    @Test
    public void testViaServletUpgradeRequest() throws Exception {
        HttpCookie cookie = new HttpCookie("hello", "world");
        cookie.setPath("/");
        cookie.setMaxAge(100000L);
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        request.setCookies(Collections.singletonList(cookie));
        CompletableFuture serverConnFut = new CompletableFuture();
        server.addConnectFuture(serverConnFut);
        CookieTrackingSocket clientSocket = new CookieTrackingSocket();
        Future clientConnectFuture = this.client.connect((Object)clientSocket, server.getWsUri(), request);
        try (BlockheadConnection serverConn = (BlockheadConnection)serverConnFut.get(2L, Timeouts.CONNECT_UNIT);){
            String serverCookies = this.confirmClientUpgradeAndCookies(clientSocket, clientConnectFuture, serverConn);
            MatcherAssert.assertThat((String)"Cookies seen at server side", (Object)serverCookies, (Matcher)Matchers.containsString((String)"hello=world"));
        }
    }

    private String confirmClientUpgradeAndCookies(CookieTrackingSocket clientSocket, Future<Session> clientConnectFuture, BlockheadConnection serverConn) throws Exception {
        HttpFields upgradeRequestHeaders = serverConn.getUpgradeRequestHeaders();
        HttpField cookieField = upgradeRequestHeaders.getField(HttpHeader.COOKIE);
        TextFrame serverCookieFrame = new TextFrame();
        serverCookieFrame.setFin(true);
        serverCookieFrame.setPayload(cookieField.getValue());
        serverConn.write((WebSocketFrame)serverCookieFrame);
        Session session = clientConnectFuture.get(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)session.getUpgradeResponse().isSuccess(), (String)"UpgradeResponse.isSuccess()");
        clientSocket.awaitOpen(2, TimeUnit.SECONDS);
        String cookies = clientSocket.messageQueue.poll(2L, Timeouts.POLL_EVENT_UNIT);
        LOG.debug("Cookies seen at server: {}", new Object[]{cookies});
        serverConn.write((WebSocketFrame)new CloseInfo(1000).asFrame());
        return cookies;
    }

    public static class CookieTrackingSocket
    extends WebSocketAdapter {
        public LinkedBlockingQueue<String> messageQueue = new LinkedBlockingQueue();
        public LinkedBlockingQueue<Throwable> errorQueue = new LinkedBlockingQueue();
        private CountDownLatch openLatch = new CountDownLatch(1);

        public void onWebSocketConnect(Session sess) {
            this.openLatch.countDown();
            super.onWebSocketConnect(sess);
        }

        public void onWebSocketText(String message) {
            System.err.printf("onTEXT - %s%n", message);
            this.messageQueue.add(message);
        }

        public void onWebSocketError(Throwable cause) {
            System.err.printf("onERROR - %s%n", cause);
            this.errorQueue.add(cause);
        }

        public void awaitOpen(int duration, TimeUnit unit) throws InterruptedException {
            Assertions.assertTrue((boolean)this.openLatch.await(duration, unit), (String)"Open Latch");
        }
    }
}

