/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jetty.websocket.client.io.ConnectionManager;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class ConnectionManagerTest {
    private void assertToSocketAddress(String uriStr, String expectedHost, int expectedPort) throws URISyntaxException {
        URI uri = new URI(uriStr);
        InetSocketAddress addr = ConnectionManager.toSocketAddress((URI)uri);
        MatcherAssert.assertThat((String)("URI (" + uri + ").host"), (Object)addr.getHostName(), (Matcher)Matchers.is((Object)expectedHost));
        MatcherAssert.assertThat((String)("URI (" + uri + ").port"), (Object)addr.getPort(), (Matcher)Matchers.is((Object)expectedPort));
    }

    @Test
    public void testToSocketAddressAltWsPort() throws Exception {
        this.assertToSocketAddress("ws://localhost:8099", "localhost", 8099);
    }

    @Test
    public void testToSocketAddressAltWssPort() throws Exception {
        this.assertToSocketAddress("wss://localhost", "localhost", 443);
    }

    @Test
    public void testToSocketAddressDefaultWsPort() throws Exception {
        this.assertToSocketAddress("ws://localhost", "localhost", 80);
    }

    @Test
    public void testToSocketAddressDefaultWsPortPath() throws Exception {
        this.assertToSocketAddress("ws://localhost/sockets/chat", "localhost", 80);
    }

    @Test
    public void testToSocketAddressDefaultWssPort() throws Exception {
        this.assertToSocketAddress("wss://localhost:9443", "localhost", 9443);
    }

    @Test
    public void testToSocketAddressDefaultWssPortPath() throws Exception {
        this.assertToSocketAddress("wss://localhost/sockets/chat", "localhost", 443);
    }
}

