/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.SimpleEchoSocket;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class SimpleSecureEchoClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String destUri = "wss://echo.websocket.org";
        if (args.length > 0) {
            destUri = args[0];
        }
        SslContextFactory.Client ssl = new SslContextFactory.Client();
        ssl.addExcludeProtocols(new String[]{"tls/1.3"});
        ssl.setExcludeCipherSuites(new String[0]);
        HttpClient http = new HttpClient((SslContextFactory)ssl);
        WebSocketClient client = new WebSocketClient(http);
        SimpleEchoSocket socket = new SimpleEchoSocket();
        try {
            http.start();
            client.start();
            URI echoUri = new URI(destUri);
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            request.setHeader("Origin", "https://websocket.org/");
            client.connect((Object)socket, echoUri, request);
            System.out.printf("Connecting to : %s%n", echoUri);
            socket.awaitClose(5, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            SimpleSecureEchoClient.stop((LifeCycle)http);
            SimpleSecureEchoClient.stop((LifeCycle)client);
        }
    }

    private static void stop(LifeCycle lifeCycle) {
        try {
            lifeCycle.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

