/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ServletRequestLogTest {
    private static final Logger LOG = Log.getLogger(ServletRequestLogTest.class);

    public static Stream<Arguments> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{new HelloServlet(), "/test/", "GET /test/ HTTP/1.1 200"});
        data.add(new Object[]{new AsyncOnTimeoutCompleteServlet(), "/test/", "GET /test/ HTTP/1.1 200"});
        data.add(new Object[]{new AsyncOnTimeoutDispatchServlet(), "/test/", "GET /test/ HTTP/1.1 200"});
        data.add(new Object[]{new AsyncOnStartIOExceptionServlet(), "/test/", "GET /test/ HTTP/1.1 500"});
        data.add(new Object[]{new ResponseSendErrorServlet(), "/test/", "GET /test/ HTTP/1.1 500"});
        data.add(new Object[]{new ServletExceptionServlet(), "/test/", "GET /test/ HTTP/1.1 500"});
        data.add(new Object[]{new IOExceptionServlet(), "/test/", "GET /test/ HTTP/1.1 500"});
        data.add(new Object[]{new RuntimeExceptionServlet(), "/test/", "GET /test/ HTTP/1.1 500"});
        return data.stream().map(Arguments::of);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLogHandlerCollection(Servlet testServlet, String requestPath, final String expectedLogEntry) throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        HandlerCollection handlers = new HandlerCollection();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        DefaultHandler defaultHandler = new DefaultHandler();
        handlers.setHandlers(new Handler[]{contexts, defaultHandler});
        server.setHandler((Handler)handlers);
        final CaptureLog captureLog = new CaptureLog();
        server.setRequestLog((RequestLog)captureLog);
        ServletContextHandler app = new ServletContextHandler(1);
        app.setContextPath("/");
        contexts.addHandler((Handler)app);
        ServletHolder testHolder = new ServletHolder(testServlet);
        app.addServlet(testHolder, "/test/*");
        try (StacklessLogging scope = new StacklessLogging(new Class[]{HttpChannel.class});){
            server.start();
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(4L), () -> {
                connector.addBean((Object)new HttpChannel.Listener(){

                    public void onComplete(Request request) {
                        ServletRequestLogTest.this.assertRequestLog(expectedLogEntry, captureLog);
                    }
                });
                String host = connector.getHost();
                if (host == null) {
                    host = "localhost";
                }
                int port = connector.getLocalPort();
                URI serverUri = new URI("http", null, host, port, requestPath, null, null);
                HttpURLConnection connection = (HttpURLConnection)serverUri.toURL().openConnection();
                try {
                    connection.setAllowUserInteraction(false);
                }
                finally {
                    connection.disconnect();
                }
            });
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLogHandlerCollectionErrorHandlerServerBean(Servlet testServlet, String requestPath, final String expectedLogEntry) throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        ErrorHandler errorHandler = new ErrorHandler();
        server.addBean((Object)errorHandler);
        HandlerCollection handlers = new HandlerCollection();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        DefaultHandler defaultHandler = new DefaultHandler();
        handlers.setHandlers(new Handler[]{contexts, defaultHandler});
        server.setHandler((Handler)handlers);
        final CaptureLog captureLog = new CaptureLog();
        server.setRequestLog((RequestLog)captureLog);
        ServletContextHandler app = new ServletContextHandler(1);
        app.setContextPath("/");
        contexts.addHandler((Handler)app);
        ServletHolder testHolder = new ServletHolder(testServlet);
        app.addServlet(testHolder, "/test/*");
        try (StacklessLogging scope = new StacklessLogging(new Class[]{HttpChannel.class});){
            server.start();
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(4L), () -> {
                connector.addBean((Object)new HttpChannel.Listener(){

                    public void onComplete(Request request) {
                        ServletRequestLogTest.this.assertRequestLog(expectedLogEntry, captureLog);
                    }
                });
                String host = connector.getHost();
                if (host == null) {
                    host = "localhost";
                }
                int port = connector.getLocalPort();
                URI serverUri = new URI("http", null, host, port, requestPath, null, null);
                HttpURLConnection connection = (HttpURLConnection)serverUri.toURL().openConnection();
                try {
                    connection.setAllowUserInteraction(false);
                }
                finally {
                    connection.disconnect();
                }
            });
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLogHandlerCollectionSimpleErrorPageMapping(Servlet testServlet, String requestPath, final String expectedLogEntry) throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        HandlerCollection handlers = new HandlerCollection();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        DefaultHandler defaultHandler = new DefaultHandler();
        handlers.setHandlers(new Handler[]{contexts, defaultHandler});
        server.setHandler((Handler)handlers);
        final CaptureLog captureLog = new CaptureLog();
        server.setRequestLog((RequestLog)captureLog);
        ServletContextHandler app = new ServletContextHandler(1);
        app.setContextPath("/");
        contexts.addHandler((Handler)app);
        ServletHolder testHolder = new ServletHolder(testServlet);
        app.addServlet(testHolder, "/test");
        app.addServlet(CustomErrorServlet.class, "/errorpage");
        ErrorPageErrorHandler errorMapper = new ErrorPageErrorHandler();
        errorMapper.addErrorPage(500, "/errorpage");
        app.setErrorHandler((ErrorHandler)errorMapper);
        try (StacklessLogging scope = new StacklessLogging(new Class[]{HttpChannel.class});){
            server.start();
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(4L), () -> {
                connector.addBean((Object)new HttpChannel.Listener(){

                    public void onComplete(Request request) {
                        ServletRequestLogTest.this.assertRequestLog(expectedLogEntry, captureLog);
                    }
                });
                String host = connector.getHost();
                if (host == null) {
                    host = "localhost";
                }
                int port = connector.getLocalPort();
                URI serverUri = new URI("http", null, host, port, requestPath, null, null);
                HttpURLConnection connection = (HttpURLConnection)serverUri.toURL().openConnection();
                try {
                    connection.setAllowUserInteraction(false);
                }
                finally {
                    connection.disconnect();
                }
            });
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLogHandlerWrapped(Servlet testServlet, String requestPath, final String expectedLogEntry) throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        HandlerCollection handlers = new HandlerCollection();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        DefaultHandler defaultHandler = new DefaultHandler();
        handlers.setHandlers(new Handler[]{contexts, defaultHandler});
        server.setHandler((Handler)handlers);
        final CaptureLog captureLog = new CaptureLog();
        server.setRequestLog((RequestLog)captureLog);
        ServletContextHandler app = new ServletContextHandler(1);
        app.setContextPath("/");
        contexts.addHandler((Handler)app);
        ServletHolder testHolder = new ServletHolder(testServlet);
        app.addServlet(testHolder, "/test");
        app.addServlet(CustomErrorServlet.class, "/errorpage");
        ErrorPageErrorHandler errorMapper = new ErrorPageErrorHandler();
        errorMapper.addErrorPage(500, "/errorpage");
        app.setErrorHandler((ErrorHandler)errorMapper);
        try {
            server.start();
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(4L), () -> {
                connector.addBean((Object)new HttpChannel.Listener(){

                    public void onComplete(Request request) {
                        ServletRequestLogTest.this.assertRequestLog(expectedLogEntry, captureLog);
                    }
                });
                String host = connector.getHost();
                if (host == null) {
                    host = "localhost";
                }
                int port = connector.getLocalPort();
                URI serverUri = new URI("http", null, host, port, "/test", null, null);
                HttpURLConnection connection = (HttpURLConnection)serverUri.toURL().openConnection();
                try {
                    connection.setAllowUserInteraction(false);
                }
                finally {
                    connection.disconnect();
                }
            });
        }
        finally {
            server.stop();
        }
    }

    private void assertRequestLog(String expectedLogEntry, CaptureLog captureLog) {
        MatcherAssert.assertThat((String)"Request log size", captureLog.captured, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat((String)"Request log entry", (Object)captureLog.captured.get(0), (Matcher)Matchers.is((Object)expectedLogEntry));
    }

    public static class CaptureLog
    extends AbstractLifeCycle
    implements RequestLog {
        public List<String> captured = new ArrayList<String>();

        public void log(Request request, Response response) {
            int status = response.getCommittedMetaData().getStatus();
            this.captured.add(String.format("%s %s %s %03d", request.getMethod(), request.getRequestURI(), request.getProtocol(), status));
        }
    }

    private static class HelloServlet
    extends AbstractTestServlet {
        private HelloServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("text/plain");
            response.getWriter().print("Hello World");
        }
    }

    private static class AsyncOnTimeoutCompleteServlet
    extends AbstractTestServlet
    implements AsyncListener {
        private AsyncOnTimeoutCompleteServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            AsyncContext ac = request.startAsync();
            ac.setTimeout(1000L);
            ac.addListener((AsyncListener)this);
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            event.getAsyncContext().complete();
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }
    }

    private static class AsyncOnTimeoutDispatchServlet
    extends AbstractTestServlet
    implements AsyncListener {
        private AsyncOnTimeoutDispatchServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (request.getAttribute("deep") == null) {
                AsyncContext ac = request.startAsync();
                ac.setTimeout(1000L);
                ac.addListener((AsyncListener)this);
                request.setAttribute("deep", (Object)true);
            }
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            event.getAsyncContext().dispatch();
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }
    }

    private static class AsyncOnStartIOExceptionServlet
    extends AbstractTestServlet
    implements AsyncListener {
        private AsyncOnStartIOExceptionServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            AsyncContext ac = request.startAsync();
            ac.setTimeout(1000L);
            ac.addListener((AsyncListener)this);
        }

        public void onTimeout(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            event.getAsyncContext().complete();
            throw new IOException("Whoops");
        }

        public void onError(AsyncEvent event) throws IOException {
            LOG.warn("onError() -> {}", new Object[]{event});
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }
    }

    private static class ResponseSendErrorServlet
    extends AbstractTestServlet {
        private ResponseSendErrorServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.sendError(500, "FromResponseSendErrorServlet");
        }
    }

    private static class ServletExceptionServlet
    extends AbstractTestServlet {
        private ServletExceptionServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            throw new ServletException("FromServletExceptionServlet");
        }
    }

    private static class IOExceptionServlet
    extends AbstractTestServlet {
        private IOExceptionServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            throw new IOException("FromIOExceptionServlet");
        }
    }

    private static class RuntimeExceptionServlet
    extends AbstractTestServlet {
        private RuntimeExceptionServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            throw new RuntimeException("FromRuntimeExceptionServlet");
        }
    }

    public static class CustomErrorServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String reason = response instanceof Response ? ((Response)response).getReason() : null;
            int status = response.getStatus();
            response.setStatus(200);
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            out.printf("Error %d: %s%n", status, reason);
        }
    }

    private static abstract class AbstractTestServlet
    extends HttpServlet {
        private AbstractTestServlet() {
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }
    }
}

