/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ListenerHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.Decorator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class ServletLifeCycleTest {
    static final Queue<String> events = new ConcurrentLinkedQueue<String>();

    @Test
    public void testLifeCycle() throws Exception {
        Server server = new Server(0);
        LocalConnector connector = new LocalConnector(server);
        server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/");
        context.getObjectFactory().addDecorator((Decorator)new TestDecorator());
        ServletHandler sh = context.getServletHandler();
        sh.addListener(new ListenerHolder(TestListener.class));
        context.addEventListener(context.getServletContext().createListener(TestListener2.class));
        sh.addFilterWithMapping(TestFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        sh.addFilterWithMapping(new FilterHolder(context.getServletContext().createFilter(TestFilter2.class)), "/*", EnumSet.of(DispatcherType.REQUEST));
        sh.addServletWithMapping(TestServlet.class, "/1/*").setInitOrder(1);
        sh.addServletWithMapping(TestServlet2.class, "/2/*").setInitOrder(-1);
        sh.addServletWithMapping(new ServletHolder(context.getServletContext().createServlet(TestServlet3.class)){
            {
                this.setInitOrder(1);
            }
        }, "/3/*");
        MatcherAssert.assertThat(events, (Matcher)Matchers.contains((Object[])new String[]{"Decorate class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestListener2", "Decorate class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestFilter2", "Decorate class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestServlet3"}));
        events.clear();
        server.start();
        MatcherAssert.assertThat(events, (Matcher)Matchers.contains((Object[])new String[]{"Decorate class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestListener", "ContextInitialized class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestListener2", "ContextInitialized class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestListener", "Decorate class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestFilter", "init class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestFilter", "init class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestFilter2", "Decorate class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestServlet", "init class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestServlet", "init class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestServlet3"}));
        events.clear();
        connector.getResponse("GET /2/info HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat(events, (Matcher)Matchers.contains((Object[])new String[]{"Decorate class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestServlet2", "init class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestServlet2", "doFilter class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestFilter", "doFilter class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestFilter2", "service class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestServlet2"}));
        events.clear();
        server.stop();
        MatcherAssert.assertThat(events, (Matcher)Matchers.contains((Object[])new String[]{"Destroy class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestFilter2", "destroy class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestFilter2", "Destroy class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestFilter", "destroy class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestFilter", "Destroy class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestServlet3", "destroy class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestServlet3", "Destroy class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestServlet2", "destroy class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestServlet2", "Destroy class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestServlet", "destroy class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestServlet", "contextDestroyed class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestListener", "contextDestroyed class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestListener2", "Destroy class org.eclipse.jetty.servlet.ServletLifeCycleTest$TestListener"}));
        EventListener[] listeners = context.getEventListeners();
        MatcherAssert.assertThat((Object)listeners.length, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat(listeners[0].getClass(), (Matcher)Matchers.is(TestListener2.class));
    }

    public static class TestDecorator
    implements Decorator {
        public <T> T decorate(T o) {
            events.add("Decorate " + o.getClass());
            return o;
        }

        public void destroy(Object o) {
            events.add("Destroy " + o.getClass());
        }
    }

    public static class TestListener
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            events.add("ContextInitialized " + this.getClass());
        }

        public void contextDestroyed(ServletContextEvent sce) {
            events.add("contextDestroyed " + this.getClass());
        }
    }

    public static class TestListener2
    extends TestListener {
    }

    public static class TestFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
            events.add("init " + this.getClass());
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            events.add("doFilter " + this.getClass());
            chain.doFilter(request, response);
        }

        public void destroy() {
            events.add("destroy " + this.getClass());
        }
    }

    public static class TestFilter2
    extends TestFilter {
    }

    public static class TestServlet
    implements Servlet {
        public void init(ServletConfig config) throws ServletException {
            events.add("init " + this.getClass());
        }

        public ServletConfig getServletConfig() {
            return null;
        }

        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            events.add("service " + this.getClass());
        }

        public String getServletInfo() {
            return null;
        }

        public void destroy() {
            events.add("destroy " + this.getClass());
        }
    }

    public static class TestServlet2
    extends TestServlet {
    }

    public static class TestServlet3
    extends TestServlet {
    }
}

