/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Random;
import java.util.stream.Stream;
import javax.servlet.AsyncContext;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class SSLAsyncIOServletTest {
    private Scenario activeScenario;

    public static Stream<Arguments> scenarios() {
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        scenarios.add(new NormalScenario());
        scenarios.add(new SslScenario());
        return scenarios.stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private void prepare(Scenario scenario, HttpServlet servlet) throws Exception {
        this.activeScenario = scenario;
        scenario.start(servlet);
    }

    @AfterEach
    public void dispose() throws Exception {
        this.activeScenario.stop();
    }

    @ParameterizedTest
    @MethodSource(value={"scenarios"})
    public void testAsyncIOWritesWithAggregation(Scenario scenario) throws Exception {
        Random random = new Random();
        String chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        final byte[] content = new byte[50000];
        for (int i = 0; i < content.length; ++i) {
            content[i] = (byte)chars.charAt(random.nextInt(chars.length()));
        }
        this.prepare(scenario, new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                final AsyncContext asyncContext = request.startAsync();
                asyncContext.setTimeout(0L);
                int bufferSize = 4096;
                response.setBufferSize(4096);
                response.getOutputStream().setWriteListener(new WriteListener(){
                    private int writes;
                    private int written;

                    public void onWritePossible() throws IOException {
                        ServletOutputStream output = asyncContext.getResponse().getOutputStream();
                        do {
                            int toWrite;
                            if ((toWrite = content.length - this.written) == 0) {
                                asyncContext.complete();
                                return;
                            }
                            toWrite = Math.min(toWrite, 4096);
                            if (this.writes == 1) {
                                toWrite -= 16;
                            }
                            output.write(content, this.written, toWrite);
                            ++this.writes;
                            this.written += toWrite;
                        } while (output.isReady());
                    }

                    public void onError(Throwable t) {
                        asyncContext.complete();
                    }
                });
            }
        });
        try (Socket client = scenario.newClient();){
            String request = "GET " + scenario.getServletPath() + " HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.flush();
            InputStream inputStream = client.getInputStream();
            HttpTester.Response response = HttpTester.parseResponse((InputStream)inputStream);
            Assertions.assertEquals((int)200, (int)response.getStatus());
            Assertions.assertArrayEquals((byte[])content, (byte[])response.getContent().getBytes("UTF-8"));
        }
    }

    public static class NormalScenario
    implements Scenario {
        private Server server;
        private ServerConnector connector;
        private String contextPath;
        private String servletPath;

        @Override
        public String getServletPath() {
            return this.contextPath + this.servletPath;
        }

        @Override
        public void start(HttpServlet servlet) throws Exception {
            this.server = new Server();
            this.connector = new ServerConnector(this.server);
            this.server.addConnector((Connector)this.connector);
            this.contextPath = "/context";
            ServletContextHandler context = new ServletContextHandler((HandlerContainer)this.server, this.contextPath, true, false);
            this.servletPath = "/servlet";
            context.addServlet(new ServletHolder((Servlet)servlet), this.servletPath);
            this.server.start();
        }

        @Override
        public Socket newClient() throws IOException {
            return new Socket("localhost", this.connector.getLocalPort());
        }

        @Override
        public void stop() throws Exception {
            this.server.stop();
        }
    }

    public static class SslScenario
    implements Scenario {
        private Server server;
        private ServerConnector connector;
        private SslContextFactory sslContextFactory;
        private String contextPath;
        private String servletPath;

        @Override
        public String getServletPath() {
            return this.contextPath + this.servletPath;
        }

        @Override
        public void start(HttpServlet servlet) throws Exception {
            Path keystorePath = MavenTestingUtils.getTestResourcePath((String)"keystore.jks");
            Path truststorePath = MavenTestingUtils.getTestResourcePath((String)"truststore.jks");
            this.sslContextFactory = new SslContextFactory.Server();
            this.sslContextFactory.setKeyStorePath(keystorePath.toString());
            this.sslContextFactory.setKeyStorePassword("storepwd");
            this.sslContextFactory.setTrustStorePath(truststorePath.toString());
            this.sslContextFactory.setTrustStorePassword("storepwd");
            this.server = new Server();
            this.connector = new ServerConnector(this.server, this.sslContextFactory);
            this.server.addConnector((Connector)this.connector);
            this.contextPath = "/context";
            ServletContextHandler context = new ServletContextHandler((HandlerContainer)this.server, this.contextPath, true, false);
            this.servletPath = "/servlet";
            context.addServlet(new ServletHolder((Servlet)servlet), this.servletPath);
            this.server.start();
        }

        @Override
        public Socket newClient() throws IOException {
            return this.sslContextFactory.getSslContext().getSocketFactory().createSocket("localhost", this.connector.getLocalPort());
        }

        @Override
        public void stop() throws Exception {
            this.server.stop();
        }
    }

    public static interface Scenario {
        public String getServletPath();

        public void start(HttpServlet var1) throws Exception;

        public Socket newClient() throws IOException;

        public void stop() throws Exception;
    }
}

