/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.concurrent.LinkedBlockingQueue;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ListenerHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ComponentWrapTest {
    private static final Logger LOG = Log.getLogger(ComponentWrapTest.class);
    private Server server;
    private HttpClient client;

    @BeforeEach
    public void setUp() throws Exception {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(0);
        this.server.addConnector((Connector)connector);
        this.client = new HttpClient();
        this.client.start();
    }

    @AfterEach
    public void tearDown() {
        LifeCycle.stop((Object)this.client);
        LifeCycle.stop((Object)this.server);
    }

    @Test
    public void testSimpleFilterServletAndListener() throws Exception {
        EventQueue events = new EventQueue();
        WrapHandler wrapHandler = new WrapHandler(events);
        ServletContextHandler contextHandler = new ServletContextHandler();
        contextHandler.setContextPath("/");
        ServletHolder servletHolder = new ServletHolder((Servlet)new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                resp.setContentType("text/plain");
                resp.setCharacterEncoding("utf-8");
                resp.getWriter().println("hello");
            }
        });
        contextHandler.addServlet(servletHolder, "/hello");
        FilterHolder filterHolder = new FilterHolder(new Filter(){

            public void init(FilterConfig filterConfig) {
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                chain.doFilter(request, response);
            }

            public void destroy() {
            }
        });
        contextHandler.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        ListenerHolder listenerHolder = new ListenerHolder(LoggingRequestListener.class);
        contextHandler.getServletHandler().addListener(listenerHolder);
        contextHandler.addBean((Object)wrapHandler);
        this.server.setHandler((Handler)contextHandler);
        this.server.start();
        ContentResponse response = this.client.GET(this.server.getURI().resolve("/hello"));
        MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        ArrayList<String> expectedEvents = new ArrayList<String>();
        expectedEvents.add("TestWrapFilter.init()");
        expectedEvents.add("TestWrapServlet.init()");
        expectedEvents.add("TestWrapListener.requestInitialized()");
        expectedEvents.add("TestWrapFilter.doFilter()");
        expectedEvents.add("TestWrapServlet.service()");
        expectedEvents.add("TestWrapListener.requestDestroyed()");
        ArrayList<String> actualEvents = new ArrayList<String>();
        actualEvents.addAll(events);
        MatcherAssert.assertThat((String)"Metrics Events Count", (Object)actualEvents.size(), (Matcher)Matchers.is((Object)expectedEvents.size()));
    }

    public static class EventQueue
    extends LinkedBlockingQueue<String> {
        private static final Logger LOG = Log.getLogger(EventQueue.class);

        public void addEvent(String format, Object ... args) {
            Object lastArg;
            String eventText = String.format(format, args);
            this.offer(eventText);
            Throwable cause = null;
            if (args.length > 0 && (lastArg = args[args.length - 1]) instanceof Throwable) {
                cause = (Throwable)lastArg;
            }
            LOG.info("[EVENT] {}", new Object[]{eventText, cause});
        }
    }

    public static class WrapHandler
    implements FilterHolder.WrapFunction,
    ServletHolder.WrapFunction,
    ListenerHolder.WrapFunction {
        private EventQueue events;

        public WrapHandler(EventQueue events) {
            this.events = events;
        }

        public Filter wrapFilter(Filter filter) {
            return new TestWrapFilter(filter, this.events);
        }

        public EventListener wrapEventListener(EventListener listener) {
            if (listener instanceof ServletRequestListener) {
                return new TestWrapListener((ServletRequestListener)listener, this.events);
            }
            return listener;
        }

        public Servlet wrapServlet(Servlet servlet) {
            return new TestWrapServlet(servlet, this.events);
        }
    }

    public static class LoggingRequestListener
    implements ServletRequestListener {
        public void requestDestroyed(ServletRequestEvent sre) {
            LOG.info("requestDestroyed()", new Object[0]);
        }

        public void requestInitialized(ServletRequestEvent sre) {
            LOG.info("requestInitialized()", new Object[0]);
        }
    }

    public static class TestWrapListener
    extends ListenerHolder.Wrapper
    implements ServletRequestListener {
        private ServletRequestListener requestListener;
        private EventQueue events;

        public TestWrapListener(ServletRequestListener listener, EventQueue events) {
            super((EventListener)listener);
            this.requestListener = listener;
            this.events = events;
        }

        public void requestDestroyed(ServletRequestEvent sre) {
            this.events.addEvent("TestWrapListener.requestDestroyed()", new Object[0]);
            this.requestListener.requestDestroyed(sre);
        }

        public void requestInitialized(ServletRequestEvent sre) {
            this.events.addEvent("TestWrapListener.requestInitialized()", new Object[0]);
            this.requestListener.requestInitialized(sre);
        }
    }

    public static class TestWrapServlet
    extends ServletHolder.Wrapper {
        private EventQueue events;

        public TestWrapServlet(Servlet servlet, EventQueue events) {
            super(servlet);
            this.events = events;
        }

        public void init(ServletConfig config) throws ServletException {
            this.events.addEvent("TestWrapServlet.init()", new Object[0]);
            super.init(config);
        }

        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            this.events.addEvent("TestWrapServlet.service()", new Object[0]);
            super.service(req, res);
        }
    }

    public static class TestWrapFilter
    extends FilterHolder.Wrapper {
        private EventQueue events;

        public TestWrapFilter(Filter filter, EventQueue events) {
            super(filter);
            this.events = events;
        }

        public void init(FilterConfig filterConfig) throws ServletException {
            this.events.addEvent("TestWrapFilter.init()", new Object[0]);
            super.init(filterConfig);
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            this.events.addEvent("TestWrapFilter.doFilter()", new Object[0]);
            super.doFilter(request, response, chain);
        }
    }
}

