/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="Unstable")
@Disabled
public class SlowClientsTest {
    private Logger logger = Log.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSlowClientsWithSmallThreadPool() throws Exception {
        File keystore = MavenTestingUtils.getTestResourceFile((String)"keystore");
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystore.getAbsolutePath());
        sslContextFactory.setKeyStorePassword("storepwd");
        sslContextFactory.setKeyManagerPassword("keypwd");
        int maxThreads = 6;
        final int contentLength = 0x800000;
        QueuedThreadPool serverThreads = new QueuedThreadPool(maxThreads);
        serverThreads.setDetailedDump(true);
        Server server = new Server((ThreadPool)serverThreads);
        try {
            ServerConnector connector = new ServerConnector(server, 1, 1, (SslContextFactory)sslContextFactory);
            connector.setPort(8888);
            server.addConnector((Connector)connector);
            server.setHandler((Handler)new AbstractHandler(){

                public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    baseRequest.setHandled(true);
                    SlowClientsTest.this.logger.info("SERVING {}", new Object[]{target});
                    response.getOutputStream().write(new byte[contentLength]);
                    SlowClientsTest.this.logger.info("SERVED {}", new Object[]{target});
                }
            });
            server.start();
            SSLContext sslContext = sslContextFactory.getSslContext();
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(10L), () -> {
                CompletableFuture[] futures = new CompletableFuture[2 * maxThreads];
                ExecutorService executor = Executors.newFixedThreadPool(futures.length);
                for (int i = 0; i < futures.length; ++i) {
                    int k = i;
                    futures[i] = CompletableFuture.runAsync(() -> {
                        try (SSLSocket socket = (SSLSocket)sslContext.getSocketFactory().createSocket("localhost", connector.getLocalPort());){
                            int read;
                            socket.setSoTimeout(contentLength / 1024);
                            OutputStream output = socket.getOutputStream();
                            String target = "/" + k;
                            String request = "GET " + target + " HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
                            output.write(request.getBytes(StandardCharsets.UTF_8));
                            output.flush();
                            while (serverThreads.getIdleThreads() > 0) {
                                Thread.sleep(50L);
                            }
                            InputStream input = socket.getInputStream();
                            while ((read = input.read()) >= 0) {
                            }
                            this.logger.info("FINISHED {}", new Object[]{target});
                        }
                        catch (IOException x) {
                            throw new UncheckedIOException(x);
                        }
                        catch (InterruptedException x) {
                            throw new UncheckedIOException(new InterruptedIOException());
                        }
                    }, executor);
                }
                CompletableFuture.allOf(futures).join();
            });
        }
        finally {
            server.stop();
        }
    }
}

