/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.BufferedResponseHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BufferedResponseHandlerTest {
    private static Server _server;
    private static HttpConfiguration _config;
    private static LocalConnector _local;
    private static ContextHandler _contextHandler;
    private static BufferedResponseHandler _bufferedHandler;
    private static TestHandler _test;

    @BeforeAll
    public static void setUp() throws Exception {
        _server = new Server();
        _config = new HttpConfiguration();
        _config.setOutputBufferSize(1024);
        _config.setOutputAggregationSize(256);
        _local = new LocalConnector(_server, (ConnectionFactory)new HttpConnectionFactory(_config));
        _server.addConnector((Connector)_local);
        _bufferedHandler = new BufferedResponseHandler();
        _bufferedHandler.getPathIncludeExclude().include((Object)"/include/*");
        _bufferedHandler.getPathIncludeExclude().exclude((Object)"*.exclude");
        _bufferedHandler.getMimeIncludeExclude().exclude((Object)"text/excluded");
        _test = new TestHandler();
        _bufferedHandler.setHandler((Handler)_test);
        _contextHandler = new ContextHandler("/ctx");
        _contextHandler.setHandler((Handler)_bufferedHandler);
        _server.setHandler((Handler)_contextHandler);
        _server.start();
    }

    @AfterAll
    public static void tearDown() throws Exception {
        _server.stop();
    }

    @BeforeEach
    public void before() {
        BufferedResponseHandlerTest._test._bufferSize = -1;
        BufferedResponseHandlerTest._test._mimeType = null;
        BufferedResponseHandlerTest._test._content = new byte[128];
        Arrays.fill(BufferedResponseHandlerTest._test._content, (byte)88);
        BufferedResponseHandlerTest._test._content[BufferedResponseHandlerTest._test._content.length - 1] = 10;
        BufferedResponseHandlerTest._test._writes = 10;
        BufferedResponseHandlerTest._test._flush = false;
        BufferedResponseHandlerTest._test._close = false;
        BufferedResponseHandlerTest._test._reset = false;
    }

    @Test
    public void testNormal() throws Exception {
        String response = _local.getResponse("GET /ctx/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 0"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 7"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length: ")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Write: 8")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Write: 9")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Written: true")));
    }

    @Test
    public void testIncluded() throws Exception {
        String response = _local.getResponse("GET /ctx/include/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 0"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 9"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Written: true"));
    }

    @Test
    public void testExcludedByPath() throws Exception {
        String response = _local.getResponse("GET /ctx/include/path.exclude HTTP/1.1\r\nHost: localhost\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 0"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 7"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length: ")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Write: 8")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Write: 9")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Written: true")));
    }

    @Test
    public void testExcludedByMime() throws Exception {
        BufferedResponseHandlerTest._test._mimeType = "text/excluded";
        String response = _local.getResponse("GET /ctx/include/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 0"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 7"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length: ")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Write: 8")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Write: 9")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Written: true")));
    }

    @Test
    public void testFlushed() throws Exception {
        BufferedResponseHandlerTest._test._flush = true;
        String response = _local.getResponse("GET /ctx/include/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 0"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 9"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Written: true"));
    }

    @Test
    public void testClosed() throws Exception {
        BufferedResponseHandlerTest._test._close = true;
        String response = _local.getResponse("GET /ctx/include/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 0"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 9"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Written: true")));
    }

    @Test
    public void testBufferSizeSmall() throws Exception {
        BufferedResponseHandlerTest._test._bufferSize = 16;
        String response = _local.getResponse("GET /ctx/include/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 0"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 9"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Written: true"));
    }

    @Test
    public void testBufferSizeBig() throws Exception {
        BufferedResponseHandlerTest._test._bufferSize = 4096;
        String response = _local.getResponse("GET /ctx/include/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: "));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 0"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 9"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Written: true"));
    }

    @Test
    public void testOne() throws Exception {
        BufferedResponseHandlerTest._test._writes = 1;
        String response = _local.getResponse("GET /ctx/include/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: "));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 0"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Write: 1")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Written: true"));
    }

    @Test
    public void testFlushEmpty() throws Exception {
        BufferedResponseHandlerTest._test._writes = 1;
        BufferedResponseHandlerTest._test._flush = true;
        BufferedResponseHandlerTest._test._close = false;
        BufferedResponseHandlerTest._test._content = new byte[0];
        String response = _local.getResponse("GET /ctx/include/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: "));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 0"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Write: 1")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Written: true"));
    }

    @Test
    public void testReset() throws Exception {
        BufferedResponseHandlerTest._test._reset = true;
        String response = _local.getResponse("GET /ctx/include/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 0"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Write: 9"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Written: true"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"RESET")));
    }

    public static class TestHandler
    extends AbstractHandler {
        int _bufferSize;
        String _mimeType;
        byte[] _content;
        int _writes;
        boolean _flush;
        boolean _close;
        boolean _reset;

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            if (this._bufferSize > 0) {
                response.setBufferSize(this._bufferSize);
            }
            if (this._mimeType != null) {
                response.setContentType(this._mimeType);
            }
            if (this._reset) {
                response.getOutputStream().print("THIS WILL BE RESET");
                response.getOutputStream().flush();
                response.getOutputStream().print("THIS WILL BE RESET");
                response.resetBuffer();
            }
            for (int i = 0; i < this._writes; ++i) {
                response.addHeader("Write", Integer.toString(i));
                response.getOutputStream().write(this._content);
                if (!this._flush) continue;
                response.getOutputStream().flush();
            }
            if (this._close) {
                response.getOutputStream().close();
            }
            response.addHeader("Written", "true");
        }
    }
}

