/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.servlet.DispatcherType;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpComplianceSection;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelOverHttp;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.MultiPartCleanerListener;
import org.eclipse.jetty.server.MultiPartFormDataCompliance;
import org.eclipse.jetty.server.MultiParts;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDir;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDirExtension;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkDirExtension.class})
public class RequestTest {
    private static final Logger LOG = Log.getLogger(RequestTest.class);
    public WorkDir workDir;
    private Server _server;
    private LocalConnector _connector;
    private RequestHandler _handler;
    private boolean _normalizeAddress = true;

    @BeforeEach
    public void init() throws Exception {
        this._server = new Server();
        HttpConnectionFactory http = new HttpConnectionFactory(){

            public Connection newConnection(Connector connector, EndPoint endPoint) {
                HttpConnection conn = new HttpConnection(this.getHttpConfiguration(), connector, endPoint, this.getHttpCompliance(), this.isRecordHttpComplianceViolations()){

                    protected HttpChannelOverHttp newHttpChannel() {
                        return new HttpChannelOverHttp(this, this.getConnector(), this.getHttpConfiguration(), this.getEndPoint(), (HttpTransport)this){

                            protected String formatAddrOrHost(String addr) {
                                if (RequestTest.this._normalizeAddress) {
                                    return super.formatAddrOrHost(addr);
                                }
                                return addr;
                            }
                        };
                    }
                };
                return this.configure((AbstractConnection)conn, connector, endPoint);
            }
        };
        http.setInputBufferSize(1024);
        http.getHttpConfiguration().setRequestHeaderSize(512);
        http.getHttpConfiguration().setResponseHeaderSize(512);
        http.getHttpConfiguration().setOutputBufferSize(2048);
        http.getHttpConfiguration().setRequestCookieCompliance(CookieCompliance.RFC6265_LEGACY);
        http.getHttpConfiguration().addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        this._connector = new LocalConnector(this._server, (ConnectionFactory)http);
        this._server.addConnector((Connector)this._connector);
        this._connector.setIdleTimeout(500L);
        this._handler = new RequestHandler();
        this._server.setHandler((Handler)this._handler);
        ErrorHandler errors = new ErrorHandler();
        errors.setServer(this._server);
        errors.setShowStacks(true);
        this._server.addBean((Object)errors);
        this._server.start();
    }

    @AfterEach
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testParamExtraction() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                try {
                    request.getParameterMap();
                    return false;
                }
                catch (BadMessageException e) {
                    String rawQuery = request.getQueryString();
                    return rawQuery.equals("param=aaa%ZZbbb&other=value");
                }
            }
        };
        String request = "GET /?param=aaa%ZZbbb&other=value HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/html;charset=utf8\nConnection: close\n\n";
        String responses = this._connector.getResponse(request);
        Assertions.assertTrue((boolean)responses.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testParameterExtractionKeepOrderingIntact() throws Exception {
        final AtomicReference reference = new AtomicReference();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                reference.set(request.getParameterMap());
                return true;
            }
        };
        String request = "POST /?first=1&second=2&third=3&fourth=4 HTTP/1.1\r\nHost: whatever\r\nContent-Type: application/x-www-form-urlencoded\nConnection: close\nContent-Length: 34\n\nfifth=5&sixth=6&seventh=7&eighth=8";
        String responses = this._connector.getResponse(request);
        Assertions.assertTrue((boolean)responses.startsWith("HTTP/1.1 200"));
        MatcherAssert.assertThat(new ArrayList(((Map)reference.get()).keySet()), (Matcher)Matchers.is(Arrays.asList("first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth")));
    }

    @Test
    public void testParameterExtractionOrderingWithMerge() throws Exception {
        final AtomicReference reference = new AtomicReference();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                reference.set(request.getParameterMap());
                return true;
            }
        };
        String request = "POST /?a=1&b=2&c=3&a=4 HTTP/1.1\r\nHost: whatever\r\nContent-Type: application/x-www-form-urlencoded\nConnection: close\nContent-Length: 11\n\nc=5&b=6&a=7";
        String responses = this._connector.getResponse(request);
        Map returnedMap = (Map)reference.get();
        Assertions.assertTrue((boolean)responses.startsWith("HTTP/1.1 200"));
        MatcherAssert.assertThat(new ArrayList(returnedMap.keySet()), (Matcher)Matchers.is(Arrays.asList("a", "b", "c")));
        Assertions.assertTrue((boolean)Arrays.equals((Object[])returnedMap.get("a"), new String[]{"1", "4", "7"}));
        Assertions.assertTrue((boolean)Arrays.equals((Object[])returnedMap.get("b"), new String[]{"2", "6"}));
        Assertions.assertTrue((boolean)Arrays.equals((Object[])returnedMap.get("c"), new String[]{"3", "5"}));
    }

    @Test
    public void testParamExtractionBadSequence() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                request.getParameterMap();
                return false;
            }
        };
        String request = "GET /?test_%e0%x8%81=missing HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/html;charset=utf8\nConnection: close\n\n";
        String responses = this._connector.getResponse(request);
        MatcherAssert.assertThat((String)"Responses", (Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 400"));
    }

    @Test
    public void testParamExtractionTimeout() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                request.getParameterMap();
                return false;
            }
        };
        String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\nConnection: close\nContent-Length: 100\n\nname=value";
        LocalConnector.LocalEndPoint endp = this._connector.connect();
        endp.addInput(request);
        String response = BufferUtil.toString((ByteBuffer)endp.waitForResponse(false, 1L, TimeUnit.SECONDS));
        MatcherAssert.assertThat((String)"Responses", (Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 500"));
    }

    @Test
    public void testEmptyHeaders() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                Assertions.assertNotNull((Object)request.getLocale());
                Assertions.assertTrue((boolean)request.getLocales().hasMoreElements());
                Assertions.assertEquals((Object)"", (Object)request.getContentType());
                Assertions.assertNull((Object)request.getCharacterEncoding());
                Assertions.assertEquals((int)0, (int)request.getQueryString().length());
                Assertions.assertEquals((int)-1, (int)request.getContentLength());
                Assertions.assertNull((Object)request.getCookies());
                Assertions.assertEquals((Object)"", (Object)request.getHeader("Name"));
                Assertions.assertTrue((boolean)request.getHeaders("Name").hasMoreElements());
                Assertions.assertThrows(IllegalArgumentException.class, () -> request.getDateHeader("Name"));
                Assertions.assertEquals((long)-1L, (long)request.getDateHeader("Other"));
                return true;
            }
        };
        String request = "GET /? HTTP/1.1\r\nHost: whatever\r\nConnection: close\nContent-Type: \nAccept-Language: \nCookie: \nName: \n\n";
        String responses = this._connector.getResponse(request);
        Assertions.assertTrue((boolean)responses.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testMultiPartNoConfig() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                try {
                    request.getPart("stuff");
                    return false;
                }
                catch (IllegalStateException e) {
                    Assertions.assertTrue((boolean)e.getMessage().startsWith("No multipart config"));
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        String multipart = "--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"stuff\"\r\nContent-Type: text/plain;charset=ISO-8859-1\r\n\r\n000000000000000000000000000000000000000000000000000\r\n--AaB03x--\r\n";
        String request = "GET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: multipart/form-data; boundary=\"AaB03x\"\r\nContent-Length: " + multipart.getBytes().length + "\r\nConnection: close\r\n\r\n" + multipart;
        String responses = this._connector.getResponse(request);
        Assertions.assertTrue((boolean)responses.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testLocale() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                MatcherAssert.assertThat((Object)request.getLocale().getLanguage(), (Matcher)Matchers.is((Object)"da"));
                Enumeration locales = request.getLocales();
                Locale locale = (Locale)locales.nextElement();
                MatcherAssert.assertThat((Object)locale.getLanguage(), (Matcher)Matchers.is((Object)"da"));
                MatcherAssert.assertThat((Object)locale.getCountry(), (Matcher)Matchers.is((Object)""));
                locale = (Locale)locales.nextElement();
                MatcherAssert.assertThat((Object)locale.getLanguage(), (Matcher)Matchers.is((Object)"en"));
                MatcherAssert.assertThat((Object)locale.getCountry(), (Matcher)Matchers.is((Object)"AU"));
                locale = (Locale)locales.nextElement();
                MatcherAssert.assertThat((Object)locale.getLanguage(), (Matcher)Matchers.is((Object)"en"));
                MatcherAssert.assertThat((Object)locale.getCountry(), (Matcher)Matchers.is((Object)"GB"));
                locale = (Locale)locales.nextElement();
                MatcherAssert.assertThat((Object)locale.getLanguage(), (Matcher)Matchers.is((Object)"en"));
                MatcherAssert.assertThat((Object)locale.getCountry(), (Matcher)Matchers.is((Object)""));
                Assertions.assertFalse((boolean)locales.hasMoreElements());
                return true;
            }
        };
        String request = "GET / HTTP/1.1\r\nHost: whatever\r\nConnection: close\r\nAccept-Language: da, en-gb;q=0.8, en;q=0.7\r\nAccept-Language: XX;q=0, en-au;q=0.9\r\n\r\n";
        String response = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
    }

    @Test
    public void testMultiPart() throws Exception {
        final Path testTmpDir = this.workDir.getEmptyPathDir();
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath("/foo");
        contextHandler.setResourceBase(".");
        contextHandler.setHandler((Handler)new MultiPartRequestHandler(testTmpDir.toFile()));
        contextHandler.addEventListener((EventListener)new MultiPartCleanerListener(){

            public void requestDestroyed(ServletRequestEvent sre) {
                MultiParts m = (MultiParts)sre.getServletRequest().getAttribute("org.eclipse.jetty.multiParts");
                Assertions.assertNotNull((Object)m);
                ContextHandler.Context c = m.getContext();
                Assertions.assertNotNull((Object)c);
                Assertions.assertSame((Object)c, (Object)sre.getServletContext());
                Assertions.assertFalse((boolean)m.isEmpty());
                MatcherAssert.assertThat((String)"File count in temp dir", (Object)RequestTest.getFileCount(testTmpDir), (Matcher)Matchers.is((Object)2L));
                super.requestDestroyed(sre);
                MatcherAssert.assertThat((String)"File count in temp dir", (Object)RequestTest.getFileCount(testTmpDir), (Matcher)Matchers.is((Object)0L));
            }
        });
        this._server.stop();
        this._server.setHandler((Handler)contextHandler);
        this._server.start();
        String multipart = "--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"stuff\"; filename=\"foo.upload\"\r\nContent-Type: text/plain;charset=ISO-8859-1\r\n\r\n000000000000000000000000000000000000000000000000000\r\n--AaB03x--\r\n";
        String request = "GET /foo/x.html HTTP/1.1\r\nHost: whatever\r\nContent-Type: multipart/form-data; boundary=\"AaB03x\"\r\nContent-Length: " + multipart.getBytes().length + "\r\nConnection: close\r\n\r\n" + multipart;
        String responses = this._connector.getResponse(request);
        Assertions.assertTrue((boolean)responses.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testUtilMultiPart() throws Exception {
        final Path testTmpDir = this.workDir.getEmptyPathDir();
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath("/foo");
        contextHandler.setResourceBase(".");
        contextHandler.setHandler((Handler)new MultiPartRequestHandler(testTmpDir.toFile()));
        contextHandler.addEventListener((EventListener)new MultiPartCleanerListener(){

            public void requestDestroyed(ServletRequestEvent sre) {
                MultiParts m = (MultiParts)sre.getServletRequest().getAttribute("org.eclipse.jetty.multiParts");
                Assertions.assertNotNull((Object)m);
                ContextHandler.Context c = m.getContext();
                Assertions.assertNotNull((Object)c);
                Assertions.assertSame((Object)c, (Object)sre.getServletContext());
                Assertions.assertFalse((boolean)m.isEmpty());
                MatcherAssert.assertThat((String)"File count in temp dir", (Object)RequestTest.getFileCount(testTmpDir), (Matcher)Matchers.is((Object)2L));
                super.requestDestroyed(sre);
                MatcherAssert.assertThat((String)"File count in temp dir", (Object)RequestTest.getFileCount(testTmpDir), (Matcher)Matchers.is((Object)0L));
            }
        });
        this._server.stop();
        this._server.setHandler((Handler)contextHandler);
        ((HttpConnectionFactory)this._connector.getBean(HttpConnectionFactory.class)).getHttpConfiguration().setMultiPartFormDataCompliance(MultiPartFormDataCompliance.LEGACY);
        this._server.start();
        String multipart = "      --AaB03x\rcontent-disposition: form-data; name=\"field1\"\r\rJoe Blow\r--AaB03x\rcontent-disposition: form-data; name=\"stuff\"; filename=\"foo.upload\"\rContent-Type: text/plain;charset=ISO-8859-1\r\r000000000000000000000000000000000000000000000000000\r--AaB03x--\r";
        String request = "GET /foo/x.html HTTP/1.1\r\nHost: whatever\r\nContent-Type: multipart/form-data; boundary=\"AaB03x\"\r\nContent-Length: " + multipart.getBytes().length + "\r\nConnection: close\r\n\r\n" + multipart;
        String responses = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.containsString((String)"Violation: CR_LINE_TERMINATION"));
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.containsString((String)"Violation: NO_CRLF_AFTER_PREAMBLE"));
    }

    @Test
    public void testHttpMultiPart() throws Exception {
        Path testTmpDir = this.workDir.getEmptyPathDir();
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath("/foo");
        contextHandler.setResourceBase(".");
        contextHandler.setHandler((Handler)new MultiPartRequestHandler(testTmpDir.toFile()));
        this._server.stop();
        this._server.setHandler((Handler)contextHandler);
        ((HttpConnectionFactory)this._connector.getBean(HttpConnectionFactory.class)).getHttpConfiguration().setMultiPartFormDataCompliance(MultiPartFormDataCompliance.RFC7578);
        this._server.start();
        String multipart = "      --AaB03x\rcontent-disposition: form-data; name=\"field1\"\r\rJoe Blow\r--AaB03x\rcontent-disposition: form-data; name=\"stuff\"; filename=\"foo.upload\"\rContent-Type: text/plain;charset=ISO-8859-1\r\r000000000000000000000000000000000000000000000000000\r--AaB03x--\r";
        String request = "GET /foo/x.html HTTP/1.1\r\nHost: whatever\r\nContent-Type: multipart/form-data; boundary=\"AaB03x\"\r\nContent-Length: " + multipart.getBytes().length + "\r\nConnection: close\r\n\r\n" + multipart;
        String responses = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 500"));
    }

    @Test
    public void testBadMultiPart() throws Exception {
        final Path testTmpDir = this.workDir.getEmptyPathDir();
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath("/foo");
        contextHandler.setResourceBase(".");
        contextHandler.setHandler((Handler)new BadMultiPartRequestHandler(testTmpDir.toFile()));
        contextHandler.addEventListener((EventListener)new MultiPartCleanerListener(){

            public void requestDestroyed(ServletRequestEvent sre) {
                MultiParts m = (MultiParts)sre.getServletRequest().getAttribute("org.eclipse.jetty.multiParts");
                Assertions.assertNotNull((Object)m);
                ContextHandler.Context c = m.getContext();
                Assertions.assertNotNull((Object)c);
                Assertions.assertSame((Object)c, (Object)sre.getServletContext());
                super.requestDestroyed(sre);
                MatcherAssert.assertThat((String)"File count in temp dir", (Object)RequestTest.getFileCount(testTmpDir), (Matcher)Matchers.is((Object)0L));
            }
        });
        this._server.stop();
        this._server.setHandler((Handler)contextHandler);
        this._server.start();
        String multipart = "--AaB03x\r\ncontent-disposition: form-data; name=\"xxx\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data;  filename=\"foo.upload\"\r\nContent-Type: text/plain;charset=ISO-8859-1\r\n\r\n000000000000000000000000000000000000000000000000000\r\n--AaB03x--\r\n";
        String request = "GET /foo/x.html HTTP/1.1\r\nHost: whatever\r\nContent-Type: multipart/form-data; boundary=\"AaB03x\"\r\nContent-Length: " + multipart.getBytes().length + "\r\nConnection: close\r\n\r\n" + multipart;
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{HttpChannel.class});){
            String responses = this._connector.getResponse(request);
            Assertions.assertTrue((boolean)responses.startsWith("HTTP/1.1 500"));
        }
    }

    @Test
    public void testBadUtf8ParamExtraction() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                try {
                    request.getParameter("param");
                    return false;
                }
                catch (BadMessageException e) {
                    String rawQuery = request.getQueryString();
                    return rawQuery.equals("param=aaa%E7bbb");
                }
            }
        };
        String request = "GET /?param=aaa%E7bbb HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/html;charset=utf8\nConnection: close\n\n";
        LOG.info("Expecting NotUtf8Exception in state 36...", new Object[0]);
        String responses = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
    }

    @Test
    public void testEncodedParamExtraction() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                try {
                    request.getParameter("param");
                    return false;
                }
                catch (BadMessageException e) {
                    return e.getCode() == 415;
                }
            }
        };
        String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: application/x-www-form-urlencoded; charset=utf-8\nContent-Length: 10\nContent-Encoding: gzip\nConnection: close\n\n0123456789\n";
        String responses = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
    }

    @Test
    public void testContentLengthExceedsMaxInteger() throws Exception {
        long HUGE_LENGTH = 0x4FFFFFFF6L;
        this._handler._checker = (request, response) -> request.getContentLength() == -1 && request.getContentLengthLong() == 0x4FFFFFFF6L;
        String request2 = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: application/octet-stream\nContent-Length: 21474836470\nConnection: close\n\n<insert huge amount of content here>\n";
        System.out.println(request2);
        String responses = this._connector.getResponse(request2);
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
    }

    @Test
    public void testContentLengthExceedsMaxLong() throws Exception {
        String hugeLength = "92233720368547758070";
        this._handler._checker = (request, response) -> request.getHeader("Content-Length").equals(hugeLength) && request.getContentLength() == -1 && request.getContentLengthLong() == -1L;
        String request2 = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: application/octet-stream\nContent-Length: " + hugeLength + "\nConnection: close\n\n<insert huge amount of content here>\n";
        String responses = this._connector.getResponse(request2);
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 400"));
    }

    @Test
    public void testIdentityParamExtraction() throws Exception {
        this._handler._checker = (request, response) -> "bar".equals(request.getParameter("foo"));
        String request2 = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: application/x-www-form-urlencoded; charset=utf-8\nContent-Length: 7\nContent-Encoding: identity\nConnection: close\n\nfoo=bar\n";
        String responses = this._connector.getResponse(request2);
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
    }

    @Test
    public void testEncodedNotParams() throws Exception {
        this._handler._checker = (request, response) -> request.getParameter("param") == null;
        String request2 = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: application/octet-stream\nContent-Length: 10\nContent-Encoding: gzip\nConnection: close\n\n0123456789\n";
        String responses = this._connector.getResponse(request2);
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
    }

    @Test
    public void testInvalidHostHeader() throws Exception {
        ContextHandler context = new ContextHandler();
        context.addVirtualHosts(new String[]{"something"});
        this._server.stop();
        this._server.setHandler((Handler)context);
        this._server.start();
        String request = "GET / HTTP/1.1\nHost: whatever.com:xxxx\nContent-Type: text/html;charset=utf8\nConnection: close\n\n";
        String responses = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 400"));
    }

    @Test
    public void testContentTypeEncoding() throws Exception {
        final ArrayList results = new ArrayList();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                results.add(request.getContentType());
                results.add(request.getCharacterEncoding());
                return true;
            }
        };
        LocalConnector.LocalEndPoint endp = this._connector.executeRequest("GET / HTTP/1.1\nHost: whatever\nContent-Type: text/test\n\nGET / HTTP/1.1\nHost: whatever\nContent-Type: text/html;charset=utf8\n\nGET / HTTP/1.1\nHost: whatever\nContent-Type: text/html; charset=\"utf8\"\n\nGET / HTTP/1.1\nHost: whatever\nContent-Type: text/html; other=foo ; blah=\"charset=wrong;\" ; charset =   \" x=z; \"   ; more=values \nConnection: close\n\n");
        endp.getResponse();
        endp.getResponse();
        endp.getResponse();
        endp.getResponse();
        int i = 0;
        Assertions.assertEquals((Object)"text/test", results.get(i++));
        Assertions.assertEquals(null, results.get(i++));
        Assertions.assertEquals((Object)"text/html;charset=utf8", results.get(i++));
        Assertions.assertEquals((Object)"utf-8", results.get(i++));
        Assertions.assertEquals((Object)"text/html; charset=\"utf8\"", results.get(i++));
        Assertions.assertEquals((Object)"utf-8", results.get(i++));
        Assertions.assertTrue((boolean)((String)results.get(i++)).startsWith("text/html"));
        Assertions.assertEquals((Object)" x=z; ", results.get(i++));
    }

    @Test
    public void testConnectRequestURLSameAsHost() throws Exception {
        AtomicReference resultRequestURL = new AtomicReference();
        AtomicReference resultRequestURI = new AtomicReference();
        this._handler._checker = (request, response) -> {
            resultRequestURL.set(request.getRequestURL().toString());
            resultRequestURI.set(request.getRequestURI());
            return true;
        };
        String rawResponse = this._connector.getResponse("CONNECT myhost:9999 HTTP/1.1\nHost: myhost:9999\nConnection: close\n\n");
        HttpTester.Response response2 = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((Object)response2.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"request.getRequestURL", (Object)((String)resultRequestURL.get()), (Matcher)Matchers.is((Object)"http://myhost:9999"));
        MatcherAssert.assertThat((String)"request.getRequestURI", (Object)((String)resultRequestURI.get()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testConnectRequestURLDifferentThanHost() throws Exception {
        AtomicReference resultRequestURL = new AtomicReference();
        AtomicReference resultRequestURI = new AtomicReference();
        this._handler._checker = (request, response) -> {
            resultRequestURL.set(request.getRequestURL().toString());
            resultRequestURI.set(request.getRequestURI());
            return true;
        };
        String rawResponse = this._connector.getResponse("CONNECT myhost:9999 HTTP/1.1\nHost: otherhost:8888\nConnection: close\n\n");
        HttpTester.Response response2 = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((Object)response2.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"request.getRequestURL", (Object)((String)resultRequestURL.get()), (Matcher)Matchers.is((Object)"http://myhost:9999"));
        MatcherAssert.assertThat((String)"request.getRequestURI", (Object)((String)resultRequestURI.get()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testHostPort() throws Exception {
        final ArrayList results = new ArrayList();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                results.add(request.getRequestURL().toString());
                results.add(request.getRemoteAddr());
                results.add(request.getServerName());
                results.add(String.valueOf(request.getServerPort()));
                return true;
            }
        };
        results.clear();
        String response = this._connector.getResponse("GET / HTTP/1.1\nHost: myhost\nConnection: close\n\n");
        int i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"http://myhost/", results.get(i++));
        Assertions.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assertions.assertEquals((Object)"myhost", results.get(i++));
        Assertions.assertEquals((Object)"80", results.get(i++));
        results.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: myhost:8888\nConnection: close\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"http://myhost:8888/", results.get(i++));
        Assertions.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assertions.assertEquals((Object)"myhost", results.get(i++));
        Assertions.assertEquals((Object)"8888", results.get(i++));
        results.clear();
        response = this._connector.getResponse("GET http://myhost:8888/ HTTP/1.0\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"http://myhost:8888/", results.get(i++));
        Assertions.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assertions.assertEquals((Object)"myhost", results.get(i++));
        Assertions.assertEquals((Object)"8888", results.get(i++));
        results.clear();
        response = this._connector.getResponse("GET http://myhost:8888/ HTTP/1.1\nHost: wrong:666\nConnection: close\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"http://myhost:8888/", results.get(i++));
        Assertions.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assertions.assertEquals((Object)"myhost", results.get(i++));
        Assertions.assertEquals((Object)"8888", results.get(i++));
        results.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: 1.2.3.4\nConnection: close\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"http://1.2.3.4/", results.get(i++));
        Assertions.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assertions.assertEquals((Object)"1.2.3.4", results.get(i++));
        Assertions.assertEquals((Object)"80", results.get(i++));
        results.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: 1.2.3.4:8888\nConnection: close\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"http://1.2.3.4:8888/", results.get(i++));
        Assertions.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assertions.assertEquals((Object)"1.2.3.4", results.get(i++));
        Assertions.assertEquals((Object)"8888", results.get(i++));
        results.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: [::1]\nConnection: close\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"http://[::1]/", results.get(i++));
        Assertions.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assertions.assertEquals((Object)"[::1]", results.get(i++));
        Assertions.assertEquals((Object)"80", results.get(i++));
        results.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: [::1]:8888\nConnection: close\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"http://[::1]:8888/", results.get(i++));
        Assertions.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assertions.assertEquals((Object)"[::1]", results.get(i++));
        Assertions.assertEquals((Object)"8888", results.get(i++));
        results.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: [::1]\nx-forwarded-for: remote\nx-forwarded-proto: https\nConnection: close\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"https://[::1]/", results.get(i++));
        Assertions.assertEquals((Object)"remote", results.get(i++));
        Assertions.assertEquals((Object)"[::1]", results.get(i++));
        Assertions.assertEquals((Object)"443", results.get(i++));
        results.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: [::1]:8888\nConnection: close\nx-forwarded-for: remote\nx-forwarded-proto: https\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"https://[::1]:8888/", results.get(i++));
        Assertions.assertEquals((Object)"remote", results.get(i++));
        Assertions.assertEquals((Object)"[::1]", results.get(i++));
        Assertions.assertEquals((Object)"8888", results.get(i++));
    }

    @Test
    public void testIPv6() throws Exception {
        final ArrayList results = new ArrayList();
        InetAddress local = Inet6Address.getByAddress("localIPv6", new byte[]{0, 1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8});
        final InetSocketAddress localAddr = new InetSocketAddress(local, 32768);
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) {
                ((Request)request).setRemoteAddr(localAddr);
                results.add(request.getRemoteAddr());
                results.add(request.getRemoteHost());
                results.add(Integer.toString(request.getRemotePort()));
                results.add(request.getServerName());
                results.add(Integer.toString(request.getServerPort()));
                results.add(request.getLocalAddr());
                results.add(Integer.toString(request.getLocalPort()));
                return true;
            }
        };
        this._normalizeAddress = true;
        String response = this._connector.getResponse("GET / HTTP/1.1\nHost: [::1]:8888\nConnection: close\n\n");
        int i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"[1:2:3:4:5:6:7:8]", results.get(i++));
        Assertions.assertEquals((Object)"localIPv6", results.get(i++));
        Assertions.assertEquals((Object)"32768", results.get(i++));
        Assertions.assertEquals((Object)"[::1]", results.get(i++));
        Assertions.assertEquals((Object)"8888", results.get(i++));
        Assertions.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assertions.assertEquals((Object)"0", results.get(i));
        this._normalizeAddress = false;
        results.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: [::1]:8888\nConnection: close\n\n");
        i = 0;
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((Object)"1:2:3:4:5:6:7:8", results.get(i++));
        Assertions.assertEquals((Object)"localIPv6", results.get(i++));
        Assertions.assertEquals((Object)"32768", results.get(i++));
        Assertions.assertEquals((Object)"[::1]", results.get(i++));
        Assertions.assertEquals((Object)"8888", results.get(i++));
        Assertions.assertEquals((Object)"0.0.0.0", results.get(i++));
        Assertions.assertEquals((Object)"0", results.get(i));
    }

    @Test
    public void testContent() throws Exception {
        final AtomicInteger length = new AtomicInteger();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                int len = request.getContentLength();
                ServletInputStream in = request.getInputStream();
                for (int i = 0; i < len; ++i) {
                    int b = in.read();
                    if (b >= 0) continue;
                    return false;
                }
                if (in.read() > 0) {
                    return false;
                }
                length.set(len);
                return true;
            }
        };
        String content = "";
        for (int l = 0; l < 1024; ++l) {
            String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: multipart/form-data-test\r\nContent-Length: " + l + "\r\nConnection: close\r\n\r\n" + content;
            Log.getRootLogger().debug("test l={}", (long)l);
            String response = this._connector.getResponse(request);
            Log.getRootLogger().debug(response, new Object[0]);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
            Assertions.assertEquals((int)l, (int)length.get());
            content = content + "x";
        }
    }

    @Test
    public void testEncodedForm() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                String actual = request.getParameter("name2");
                return "test2".equals(actual);
            }
        };
        String content = "name1=test&name2=test2&name3=&name4=test";
        String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\r\nContent-Length: " + content.length() + "\r\nConnection: close\r\n\r\n" + content;
        String response = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
    }

    @Test
    public void testEncodedFormUnknownMethod() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                return request.getParameter("name1") == null && request.getParameter("name2") == null && request.getParameter("name3") == null;
            }
        };
        String content = "name1=test&name2=test2&name3=&name4=test";
        String request = "UNKNOWN / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\r\nContent-Length: " + content.length() + "\r\nConnection: close\r\n\r\n" + content;
        String response = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
    }

    @Test
    public void testEncodedFormExtraMethod() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                String actual = request.getParameter("name2");
                return "test2".equals(actual);
            }
        };
        ((HttpConnectionFactory)this._connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration().addFormEncodedMethod("Extra");
        String content = "name1=test&name2=test2&name3=&name4=test";
        String request = "EXTRA / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\r\nContent-Length: " + content.length() + "\r\nConnection: close\r\n\r\n" + content;
        String response = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
    }

    @Test
    public void test8859EncodedForm() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                request.setCharacterEncoding(StandardCharsets.ISO_8859_1.name());
                String actual = request.getParameter("name2");
                return "test\u00e4".equals(actual);
            }
        };
        String content = "name1=test&name2=test%E4&name3=&name4=test";
        String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\r\nContent-Length: " + content.length() + "\r\nConnection: close\r\n\r\n" + content;
        String response = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
    }

    @Test
    public void testUTF8EncodedForm() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                String actual = request.getParameter("name2");
                return "test\u00e4".equals(actual);
            }
        };
        String content = "name1=test&name2=test%C3%A4&name3=&name4=test";
        String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\r\nContent-Length: " + content.length() + "\r\nConnection: close\r\n\r\n" + content;
        String response = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
    }

    @Test
    @Disabled(value="See issue #1175")
    public void testMultiPartFormDataReadInputThenParams() throws Exception {
        final File tmpdir = MavenTestingUtils.getTargetTestingDir((String)"multipart");
        FS.ensureEmpty((File)tmpdir);
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if (baseRequest.getDispatcherType() != DispatcherType.REQUEST) {
                    return;
                }
                MultipartConfigElement multipartConfig = new MultipartConfigElement(tmpdir.getAbsolutePath());
                request.setAttribute("org.eclipse.jetty.multipartConfig", (Object)multipartConfig);
                baseRequest.setHandled(true);
                int length = request.getContentLength();
                ServletInputStream in = request.getInputStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IO.copy((InputStream)in, (OutputStream)out, (long)length);
                response.setIntHeader("x-request-content-length", request.getContentLength());
                response.setIntHeader("x-request-content-read", out.size());
                String foo = request.getParameter("foo");
                String bar = request.getParameter("bar");
                response.setHeader("x-foo", foo == null ? "null" : foo);
                response.setHeader("x-bar", bar == null ? "null" : bar);
            }
        };
        this._server.stop();
        this._server.setHandler((Handler)handler);
        this._server.start();
        String multipart = "--AaBbCc\r\ncontent-disposition: form-data; name=\"bar\"\r\n\r\nBarContent\r\n--AaBbCc\r\ncontent-disposition: form-data; name=\"stuff\"\r\nContent-Type: text/plain;charset=ISO-8859-1\r\n\r\n000000000000000000000000000000000000000000000000000\r\n--AaBbCc--\r\n";
        String request = "POST /?foo=FooUri HTTP/1.1\r\nHost: whatever\r\nContent-Type: multipart/form-data; boundary=\"AaBbCc\"\r\nContent-Length: " + multipart.getBytes().length + "\r\nConnection: close\r\n\r\n" + multipart;
        HttpTester.Response response = HttpTester.parseResponse((String)this._connector.getResponse(request));
        MatcherAssert.assertThat((String)"response.x-foo", (Object)response.get("x-foo"), (Matcher)Matchers.is((Object)"FooUri"));
        MatcherAssert.assertThat((String)"response.x-bar", (Object)response.get("x-bar"), (Matcher)Matchers.is((Object)"null"));
    }

    @Test
    public void testPartialRead() throws Exception {
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                BufferedReader reader = request.getReader();
                byte[] b = ("read=" + ((Reader)reader).read() + "\n").getBytes(StandardCharsets.UTF_8);
                response.setContentLength(b.length);
                response.getOutputStream().write(b);
                response.flushBuffer();
            }
        };
        this._server.stop();
        this._server.setHandler((Handler)handler);
        this._server.start();
        String requests = "GET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/plane\r\nContent-Length: 10\r\n\r\n0123456789\r\nGET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/plane\r\nContent-Length: 10\r\nConnection: close\r\n\r\nABCDEFGHIJ\r\n";
        LocalConnector.LocalEndPoint endp = this._connector.executeRequest(requests);
        String responses = endp.getResponse() + endp.getResponse();
        int index = responses.indexOf("read=48");
        Assertions.assertTrue((index > 0 ? 1 : 0) != 0);
        index = responses.indexOf("read=65", index + 7);
        Assertions.assertTrue((index > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueryAfterRead() throws Exception {
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                BufferedReader reader = request.getReader();
                String in = IO.toString((Reader)reader);
                String param = request.getParameter("param");
                byte[] b = ("read='" + in + "' param=" + param + "\n").getBytes(StandardCharsets.UTF_8);
                response.setContentLength(b.length);
                response.getOutputStream().write(b);
                response.flushBuffer();
            }
        };
        this._server.stop();
        this._server.setHandler((Handler)handler);
        this._server.start();
        String request = "POST /?param=right HTTP/1.1\r\nHost: whatever\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: 11\r\nConnection: close\r\n\r\nparam=wrong\r\n";
        String responses = this._connector.getResponse(request);
        Assertions.assertTrue((responses.indexOf("read='param=wrong' param=right") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSessionAfterRedirect() throws Exception {
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                response.sendRedirect("/foo");
                try {
                    request.getSession(true);
                    Assertions.fail((String)"Session should not be created after response committed");
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (Exception e) {
                    Assertions.fail((String)"Session creation after response commit should throw IllegalStateException");
                }
            }
        };
        this._server.stop();
        this._server.setHandler((Handler)handler);
        this._server.start();
        String response = this._connector.getResponse("GET / HTTP/1.1\nHost: myhost\nConnection: close\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 302 Found"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Location: http://myhost/foo"));
    }

    @Test
    public void testPartialInput() throws Exception {
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                ServletInputStream in = request.getInputStream();
                byte[] b = ("read=" + in.read() + "\n").getBytes(StandardCharsets.UTF_8);
                response.setContentLength(b.length);
                response.getOutputStream().write(b);
                response.flushBuffer();
            }
        };
        this._server.stop();
        this._server.setHandler((Handler)handler);
        this._server.start();
        String requests = "GET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/plane\r\nContent-Length: 10\r\n\r\n0123456789\r\nGET / HTTP/1.1\r\nHost: whatever\r\nContent-Type: text/plane\r\nContent-Length: 10\r\nConnection: close\r\n\r\nABCDEFGHIJ\r\n";
        LocalConnector.LocalEndPoint endp = this._connector.executeRequest(requests);
        String responses = endp.getResponse() + endp.getResponse();
        int index = responses.indexOf("read=48");
        Assertions.assertTrue((index > 0 ? 1 : 0) != 0);
        index = responses.indexOf("read=65", index + 7);
        Assertions.assertTrue((index > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConnectionClose() throws Exception {
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.getOutputStream().println("Hello World");
                return true;
            }
        };
        String response = this._connector.getResponse("GET / HTTP/1.1\nHost: whatever\n\n", 200L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Connection: close")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: whatever\nConnection: close\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Connection: close"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: whatever\nConnection: Other, close\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Connection: close"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
        response = this._connector.getResponse("GET / HTTP/1.0\nHost: whatever\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Connection: close")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
        response = this._connector.getResponse("GET / HTTP/1.0\nHost: whatever\nConnection: Other, close\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
        response = this._connector.getResponse("GET / HTTP/1.0\nHost: whatever\nConnection: Other,,keep-alive\n\n", 200L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Connection: keep-alive"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.setHeader("Connection", "TE");
                response.addHeader("Connection", "Other");
                response.getOutputStream().println("Hello World");
                return true;
            }
        };
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: whatever\n\n", 200L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Connection: TE"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Connection: Other"));
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: whatever\nConnection: close\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Connection: close"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
    }

    @Test
    public void testCookies() throws Exception {
        final ArrayList cookies = new ArrayList();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                Cookie[] ca = request.getCookies();
                if (ca != null) {
                    cookies.addAll(Arrays.asList(ca));
                }
                response.getOutputStream().println("Hello World");
                return true;
            }
        };
        cookies.clear();
        String response = this._connector.getResponse("GET / HTTP/1.1\nHost: whatever\nConnection: close\n\n");
        Assertions.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assertions.assertEquals((int)0, (int)cookies.size());
        cookies.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: whatever\nCookie: name=quoted=\"\\\"badly\\\"\"\nConnection: close\n\n");
        Assertions.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assertions.assertEquals((int)1, (int)cookies.size());
        Assertions.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assertions.assertEquals((Object)"quoted=\"\\\"badly\\\"\"", (Object)((Cookie)cookies.get(0)).getValue());
        cookies.clear();
        response = this._connector.getResponse("GET / HTTP/1.1\nHost: whatever\nCookie: name=value; other=\"quoted=;value\"\nConnection: close\n\n");
        Assertions.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assertions.assertEquals((int)2, (int)cookies.size());
        Assertions.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assertions.assertEquals((Object)"value", (Object)((Cookie)cookies.get(0)).getValue());
        Assertions.assertEquals((Object)"other", (Object)((Cookie)cookies.get(1)).getName());
        Assertions.assertEquals((Object)"quoted=;value", (Object)((Cookie)cookies.get(1)).getValue());
        cookies.clear();
        LocalConnector.LocalEndPoint endp = this._connector.executeRequest("GET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: name=value; other=\"quoted=;value\"\n\nGET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: name=value; other=\"quoted=;value\"\nConnection: close\n\n");
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        Assertions.assertEquals((int)4, (int)cookies.size());
        Assertions.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assertions.assertEquals((Object)"value", (Object)((Cookie)cookies.get(0)).getValue());
        Assertions.assertEquals((Object)"other", (Object)((Cookie)cookies.get(1)).getName());
        Assertions.assertEquals((Object)"quoted=;value", (Object)((Cookie)cookies.get(1)).getValue());
        Assertions.assertSame(cookies.get(0), cookies.get(2));
        Assertions.assertSame(cookies.get(1), cookies.get(3));
        cookies.clear();
        endp = this._connector.executeRequest("GET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: name=value; other=\"quoted=;value\"\n\nGET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: name=value; other=\"othervalue\"\nConnection: close\n\n");
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        Assertions.assertEquals((int)4, (int)cookies.size());
        Assertions.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assertions.assertEquals((Object)"value", (Object)((Cookie)cookies.get(0)).getValue());
        Assertions.assertEquals((Object)"other", (Object)((Cookie)cookies.get(1)).getName());
        Assertions.assertEquals((Object)"quoted=;value", (Object)((Cookie)cookies.get(1)).getValue());
        Assertions.assertNotSame(cookies.get(0), cookies.get(2));
        Assertions.assertNotSame(cookies.get(1), cookies.get(3));
        cookies.clear();
        response = this._connector.getResponse("GET /other HTTP/1.1\nHost: whatever\nOther: header\nCookie: __utmz=14316.133020.1.1.utr=gna.de|ucn=(real)|utd=reral|utct=/games/hen-one,gnt-50-ba-keys:key,2072262.html\nConnection: close\n\n");
        Assertions.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assertions.assertEquals((int)1, (int)cookies.size());
        Assertions.assertEquals((Object)"__utmz", (Object)((Cookie)cookies.get(0)).getName());
        Assertions.assertEquals((Object)"14316.133020.1.1.utr=gna.de|ucn=(real)|utd=reral|utct=/games/hen-one,gnt-50-ba-keys:key,2072262.html", (Object)((Cookie)cookies.get(0)).getValue());
    }

    @Test
    public void testBadCookies() throws Exception {
        final ArrayList cookies = new ArrayList();
        this._handler._checker = new RequestTester(){

            @Override
            public boolean check(HttpServletRequest request, HttpServletResponse response) throws IOException {
                Cookie[] ca = request.getCookies();
                if (ca != null) {
                    cookies.addAll(Arrays.asList(ca));
                }
                response.getOutputStream().println("Hello World");
                return true;
            }
        };
        cookies.clear();
        String response = this._connector.getResponse("GET / HTTP/1.1\nHost: whatever\nCookie: Path=value\nCookie: name=value\nConnection: close\n\n");
        Assertions.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
        Assertions.assertEquals((int)1, (int)cookies.size());
        Assertions.assertEquals((Object)"name", (Object)((Cookie)cookies.get(0)).getName());
        Assertions.assertEquals((Object)"value", (Object)((Cookie)cookies.get(0)).getValue());
    }

    @Test
    public void testHashDOSKeys() throws Exception {
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{HttpChannel.class});){
            this._server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", (Object)-1);
            this._server.setAttribute("org.eclipse.jetty.server.Request.maxFormKeys", (Object)1000);
            StringBuilder buf = new StringBuilder(4000000);
            buf.append("a=b");
            File evilKeys = new File("/tmp/keys_mapping_to_zero_2m");
            if (evilKeys.exists()) {
                try (BufferedReader in = new BufferedReader(new FileReader(evilKeys));){
                    String key = null;
                    while ((key = in.readLine()) != null) {
                        buf.append("&").append(key).append("=").append("x");
                    }
                }
            } else {
                for (int i = 0; i < 2000; ++i) {
                    buf.append("&").append("K").append(i).append("=").append("x");
                }
            }
            buf.append("&c=d");
            this._handler._checker = new RequestTester(){

                @Override
                public boolean check(HttpServletRequest request, HttpServletResponse response) {
                    return "b".equals(request.getParameter("a")) && request.getParameter("c") == null;
                }
            };
            String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\r\nContent-Length: " + buf.length() + "\r\nConnection: close\r\n\r\n" + buf;
            long start = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            String rawResponse = this._connector.getResponse(request);
            HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
            MatcherAssert.assertThat((String)"Response body content", (Object)response.getContent(), (Matcher)Matchers.containsString((String)BadMessageException.class.getName()));
            MatcherAssert.assertThat((String)"Response body content", (Object)response.getContent(), (Matcher)Matchers.containsString((String)IllegalStateException.class.getName()));
            long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            Assertions.assertTrue((now - start < 5000L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testHashDOSSize() throws Exception {
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{HttpChannel.class});){
            LOG.info("Expecting maxFormSize limit and too much data exceptions...", new Object[0]);
            this._server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", (Object)3396);
            this._server.setAttribute("org.eclipse.jetty.server.Request.maxFormKeys", (Object)1000);
            StringBuilder buf = new StringBuilder(4000000);
            buf.append("a=b");
            for (int i = 0; i < 500; ++i) {
                buf.append("&").append("K").append(i).append("=").append("x");
            }
            buf.append("&c=d");
            this._handler._checker = new RequestTester(){

                @Override
                public boolean check(HttpServletRequest request, HttpServletResponse response) {
                    return "b".equals(request.getParameter("a")) && request.getParameter("c") == null;
                }
            };
            String request = "POST / HTTP/1.1\r\nHost: whatever\r\nContent-Type: " + MimeTypes.Type.FORM_ENCODED.asString() + "\r\nContent-Length: " + buf.length() + "\r\nConnection: close\r\n\r\n" + buf;
            long start = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            String rawResponse = this._connector.getResponse(request);
            HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
            MatcherAssert.assertThat((String)"Response.status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
            MatcherAssert.assertThat((String)"Response body content", (Object)response.getContent(), (Matcher)Matchers.containsString((String)BadMessageException.class.getName()));
            MatcherAssert.assertThat((String)"Response body content", (Object)response.getContent(), (Matcher)Matchers.containsString((String)IllegalStateException.class.getName()));
            long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            Assertions.assertTrue((now - start < 5000L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNotSupportedCharacterEncoding() throws UnsupportedEncodingException {
        Request request = new Request(null, null);
        Assertions.assertThrows(UnsupportedEncodingException.class, () -> request.setCharacterEncoding("doesNotExist"));
    }

    @Test
    public void testGetterSafeFromNullPointerException() {
        Request request = new Request(null, null);
        Assertions.assertNull((Object)request.getAuthType());
        Assertions.assertNull((Object)request.getAuthentication());
        Assertions.assertNull((Object)request.getContentType());
        Assertions.assertNull((Object)request.getCookies());
        Assertions.assertNull((Object)request.getContext());
        Assertions.assertNull((Object)request.getContextPath());
        Assertions.assertNull((Object)request.getHttpFields());
        Assertions.assertNull((Object)request.getHttpURI());
        Assertions.assertNotNull((Object)request.getScheme());
        Assertions.assertNotNull((Object)request.getServerName());
        Assertions.assertNotNull((Object)request.getServerPort());
        Assertions.assertNotNull((Object)request.getAttributeNames());
        Assertions.assertFalse((boolean)request.getAttributeNames().hasMoreElements());
        request.getParameterMap();
        Assertions.assertNull((Object)request.getQueryString());
        Assertions.assertNotNull((Object)request.getQueryParameters());
        Assertions.assertEquals((int)0, (int)request.getQueryParameters().size());
        Assertions.assertNotNull((Object)request.getParameterMap());
        Assertions.assertEquals((int)0, (int)request.getParameterMap().size());
    }

    @Test
    public void testEncoding() throws Exception {
        this._handler._checker = (request, response) -> "/foo/bar".equals(request.getPathInfo());
        String request2 = "GET /f%6f%6F/b%u0061r HTTP/1.0\r\nHost: whatever\r\n\r\n";
        ((HttpConnectionFactory)this._connector.getBean(HttpConnectionFactory.class)).setHttpCompliance(HttpCompliance.RFC7230);
        MatcherAssert.assertThat((Object)this._connector.getResponse(request2), (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
        HttpCompliance.CUSTOM0.sections().clear();
        HttpCompliance.CUSTOM0.sections().addAll(HttpCompliance.RFC7230.sections());
        HttpCompliance.CUSTOM0.sections().add(HttpComplianceSection.NO_UTF16_ENCODINGS);
        ((HttpConnectionFactory)this._connector.getBean(HttpConnectionFactory.class)).setHttpCompliance(HttpCompliance.CUSTOM0);
        MatcherAssert.assertThat((Object)this._connector.getResponse(request2), (Matcher)Matchers.startsWith((String)"HTTP/1.1 400"));
    }

    @Test
    public void testAmbiguousParameters() throws Exception {
        this._handler._checker = (request, response) -> true;
        String request2 = "GET /ambiguous/..;/path HTTP/1.0\r\nHost: whatever\r\n\r\n";
        ((HttpConnectionFactory)this._connector.getBean(HttpConnectionFactory.class)).setHttpCompliance(HttpCompliance.RFC7230);
        MatcherAssert.assertThat((Object)this._connector.getResponse(request2), (Matcher)Matchers.startsWith((String)"HTTP/1.1 400"));
        HttpCompliance.CUSTOM0.sections().clear();
        HttpCompliance.CUSTOM0.sections().addAll(HttpCompliance.RFC7230.sections());
        HttpCompliance.CUSTOM0.sections().remove(HttpComplianceSection.NO_AMBIGUOUS_PATH_PARAMETERS);
        ((HttpConnectionFactory)this._connector.getBean(HttpConnectionFactory.class)).setHttpCompliance(HttpCompliance.CUSTOM0);
        MatcherAssert.assertThat((Object)this._connector.getResponse(request2), (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
    }

    @Test
    public void testAmbiguousSegments() throws Exception {
        this._handler._checker = (request, response) -> true;
        String request2 = "GET /ambiguous/%2e%2e/path HTTP/1.0\r\nHost: whatever\r\n\r\n";
        ((HttpConnectionFactory)this._connector.getBean(HttpConnectionFactory.class)).setHttpCompliance(HttpCompliance.RFC7230_NO_AMBIGUOUS_URIS);
        MatcherAssert.assertThat((Object)this._connector.getResponse(request2), (Matcher)Matchers.startsWith((String)"HTTP/1.1 400"));
        ((HttpConnectionFactory)this._connector.getBean(HttpConnectionFactory.class)).setHttpCompliance(HttpCompliance.RFC7230);
        MatcherAssert.assertThat((Object)this._connector.getResponse(request2), (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
        ((HttpConnectionFactory)this._connector.getBean(HttpConnectionFactory.class)).setHttpCompliance(HttpCompliance.RFC2616);
        MatcherAssert.assertThat((Object)this._connector.getResponse(request2), (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
    }

    @Test
    public void testAmbiguousSeparators() throws Exception {
        this._handler._checker = (request, response) -> true;
        String request2 = "GET /ambiguous/%2f/path HTTP/1.0\r\nHost: whatever\r\n\r\n";
        ((HttpConnectionFactory)this._connector.getBean(HttpConnectionFactory.class)).setHttpCompliance(HttpCompliance.RFC7230_NO_AMBIGUOUS_URIS);
        MatcherAssert.assertThat((Object)this._connector.getResponse(request2), (Matcher)Matchers.startsWith((String)"HTTP/1.1 400"));
        ((HttpConnectionFactory)this._connector.getBean(HttpConnectionFactory.class)).setHttpCompliance(HttpCompliance.RFC7230);
        MatcherAssert.assertThat((Object)this._connector.getResponse(request2), (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
        ((HttpConnectionFactory)this._connector.getBean(HttpConnectionFactory.class)).setHttpCompliance(HttpCompliance.RFC2616);
        MatcherAssert.assertThat((Object)this._connector.getResponse(request2), (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
    }

    public void setComplianceModes(HttpComplianceSection ... complianceSections) {
        this.setComplianceModes((HttpCompliance)null, complianceSections);
    }

    public void setComplianceModes(HttpCompliance compliance, HttpComplianceSection ... additionalSections) {
        HttpCompliance.CUSTOM0.sections().clear();
        if (compliance != null) {
            HttpCompliance.CUSTOM0.sections().addAll(compliance.sections());
        }
        HttpCompliance.CUSTOM0.sections().addAll(Arrays.asList(additionalSections));
        ((HttpConnectionFactory)this._connector.getBean(HttpConnectionFactory.class)).setHttpCompliance(HttpCompliance.CUSTOM0);
    }

    @Test
    public void testAmbiguousPaths() throws Exception {
        this._handler._checker = (request, response) -> {
            response.getOutputStream().println("servletPath=" + request.getServletPath());
            response.getOutputStream().println("pathInfo=" + request.getPathInfo());
            return true;
        };
        String request2 = "GET /unnormal/.././path/ambiguous%2f%2e%2e/info HTTP/1.0\r\nHost: whatever\r\n\r\n";
        this.setComplianceModes(HttpCompliance.RFC7230, new HttpComplianceSection[0]);
        MatcherAssert.assertThat((Object)this._connector.getResponse(request2), (Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)"HTTP/1.1 200"), (Matcher)Matchers.containsString((String)"pathInfo=/path/info")));
        this.setComplianceModes(HttpComplianceSection.NO_AMBIGUOUS_PATH_SEPARATORS);
        MatcherAssert.assertThat((Object)this._connector.getResponse(request2), (Matcher)Matchers.startsWith((String)"HTTP/1.1 400"));
    }

    @Test
    public void testAmbiguousEncoding() throws Exception {
        this._handler._checker = (request, response) -> true;
        String request2 = "GET /ambiguous/encoded/%25/path HTTP/1.0\r\nHost: whatever\r\n\r\n";
        this.setComplianceModes(HttpCompliance.RFC7230, new HttpComplianceSection[0]);
        MatcherAssert.assertThat((Object)this._connector.getResponse(request2), (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
        this.setComplianceModes(HttpCompliance.RFC7230, HttpComplianceSection.NO_AMBIGUOUS_PATH_ENCODING);
        MatcherAssert.assertThat((Object)this._connector.getResponse(request2), (Matcher)Matchers.startsWith((String)"HTTP/1.1 400"));
    }

    @Test
    public void testAmbiguousDoubleSlash() throws Exception {
        this._handler._checker = (request, response) -> true;
        String request2 = "GET /ambiguous/doubleSlash// HTTP/1.0\r\nHost: whatever\r\n\r\n";
        this.setComplianceModes(HttpCompliance.RFC7230, new HttpComplianceSection[0]);
        MatcherAssert.assertThat((Object)this._connector.getResponse(request2), (Matcher)Matchers.startsWith((String)"HTTP/1.1 200"));
        this.setComplianceModes(HttpCompliance.RFC7230, HttpComplianceSection.NO_AMBIGUOUS_EMPTY_SEGMENT);
        MatcherAssert.assertThat((Object)this._connector.getResponse(request2), (Matcher)Matchers.startsWith((String)"HTTP/1.1 400"));
    }

    private static long getFileCount(Path path) {
        long l;
        block8: {
            Stream<Path> s = Files.list(path);
            try {
                l = s.count();
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to get file list count: " + path, e);
                }
            }
            s.close();
        }
        return l;
    }

    private class RequestHandler
    extends AbstractHandler {
        private RequestTester _checker;
        private String _content;

        private RequestHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ((Request)request).setHandled(true);
            if (request.getContentLength() > 0 && !request.getContentType().startsWith(MimeTypes.Type.FORM_ENCODED.asString()) && !request.getContentType().startsWith("multipart/form-data")) {
                this._content = IO.toString((InputStream)request.getInputStream());
            }
            if (this._checker != null && this._checker.check(request, response)) {
                response.setStatus(200);
            } else {
                response.sendError(500);
            }
        }
    }

    static interface RequestTester {
        public boolean check(HttpServletRequest var1, HttpServletResponse var2) throws IOException;
    }

    private class MultiPartRequestHandler
    extends AbstractHandler {
        File tmpDir;

        public MultiPartRequestHandler(File tmpDir) {
            this.tmpDir = tmpDir;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ((Request)request).setHandled(true);
            try {
                MultipartConfigElement mpce = new MultipartConfigElement(this.tmpDir.getAbsolutePath(), -1L, -1L, 2);
                request.setAttribute("org.eclipse.jetty.multipartConfig", (Object)mpce);
                String field1 = request.getParameter("field1");
                Assertions.assertNotNull((Object)field1);
                Part foo = request.getPart("stuff");
                Assertions.assertNotNull((Object)foo);
                Assertions.assertTrue((foo.getSize() > 0L ? 1 : 0) != 0);
                response.setStatus(200);
                List violations = (List)request.getAttribute("org.eclipse.jetty.http.compliance.violations");
                if (violations != null) {
                    for (String v : violations) {
                        response.addHeader("Violation", v);
                    }
                }
            }
            catch (IllegalStateException e) {
                Assertions.assertTrue((boolean)e.getMessage().startsWith("No multipart config"));
                response.setStatus(200);
            }
            catch (Exception e) {
                response.sendError(500);
            }
        }
    }

    private class BadMultiPartRequestHandler
    extends AbstractHandler {
        File tmpDir;

        public BadMultiPartRequestHandler(File tmpDir) {
            this.tmpDir = tmpDir;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ((Request)request).setHandled(true);
            try {
                MultipartConfigElement mpce = new MultipartConfigElement(this.tmpDir.getAbsolutePath(), -1L, -1L, 2);
                request.setAttribute("org.eclipse.jetty.multipartConfig", (Object)mpce);
                request.getPart("xxx");
            }
            catch (RuntimeException e) {
                response.sendError(500);
            }
        }
    }
}

