/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.TypeUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProxyProtocolTest {
    private Server server;
    private ServerConnector connector;

    private void start(Handler handler) throws Exception {
        this.server = new Server();
        this.connector = new ServerConnector(this.server, new ConnectionFactory[]{new ProxyConnectionFactory(), new HttpConnectionFactory()});
        this.server.addConnector((Connector)this.connector);
        this.server.setHandler(handler);
        this.server.start();
    }

    @AfterEach
    public void destroy() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void testProxyProtocolV1() throws Exception {
        String remoteAddr = "192.168.0.0";
        int remotePort = 12345;
        this.start((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if ("192.168.0.0".equals(request.getRemoteAddr()) && 12345 == request.getRemotePort()) {
                    baseRequest.setHandled(true);
                }
            }
        });
        try (Socket socket = new Socket("localhost", this.connector.getLocalPort());){
            String request1 = "PROXY TCP4 192.168.0.0 127.0.0.0 12345 8080\r\nGET /1 HTTP/1.1\r\nHost: localhost\r\n\r\n";
            OutputStream output = socket.getOutputStream();
            output.write(request1.getBytes(StandardCharsets.UTF_8));
            output.flush();
            InputStream input = socket.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            String response1 = reader.readLine();
            Assertions.assertTrue((boolean)response1.startsWith("HTTP/1.1 200 "));
            while (!reader.readLine().isEmpty()) {
            }
            String request2 = "GET /2 HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
            output.write(request2.getBytes(StandardCharsets.UTF_8));
            output.flush();
            String response2 = reader.readLine();
            Assertions.assertTrue((boolean)response2.startsWith("HTTP/1.1 200 "));
            while (reader.readLine() != null) {
            }
        }
    }

    @Test
    public void testProxyProtocolV2() throws Exception {
        String remoteAddr = "192.168.0.1";
        int remotePort = 12345;
        this.start((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if ("192.168.0.1".equals(request.getRemoteAddr()) && 12345 == request.getRemotePort()) {
                    baseRequest.setHandled(true);
                }
            }
        });
        try (Socket socket = new Socket("localhost", this.connector.getLocalPort());){
            String proxy = "0D0A0D0A000D0A515549540A21110015C0A800017f00000130391F90040000040003ABCDEF";
            String request1 = "GET /1 HTTP/1.1\r\nHost: localhost\r\n\r\n";
            OutputStream output = socket.getOutputStream();
            output.write(TypeUtil.fromHexString((String)proxy));
            output.write(request1.getBytes(StandardCharsets.UTF_8));
            output.flush();
            InputStream input = socket.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            String response1 = reader.readLine();
            Assertions.assertTrue((boolean)response1.startsWith("HTTP/1.1 200 "));
            while (!reader.readLine().isEmpty()) {
            }
            String request2 = "GET /2 HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
            output.write(request2.getBytes(StandardCharsets.UTF_8));
            output.flush();
            String response2 = reader.readLine();
            Assertions.assertTrue((boolean)response2.startsWith("HTTP/1.1 200 "));
            while (reader.readLine() != null) {
            }
        }
    }

    @Test
    public void testProxyProtocolV2Local() throws Exception {
        this.start((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
            }
        });
        try (Socket socket = new Socket("localhost", this.connector.getLocalPort());){
            String proxy = "0D0A0D0A000D0A515549540A20110015C0A800017f00000130391F90040000040003ABCDEF";
            String request1 = "GET /1 HTTP/1.1\r\nHost: localhost\r\n\r\n";
            OutputStream output = socket.getOutputStream();
            output.write(TypeUtil.fromHexString((String)proxy));
            output.write(request1.getBytes(StandardCharsets.UTF_8));
            output.flush();
            InputStream input = socket.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            String response1 = reader.readLine();
            Assertions.assertTrue((boolean)response1.startsWith("HTTP/1.1 200 "));
            while (!reader.readLine().isEmpty()) {
            }
            String request2 = "GET /2 HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
            output.write(request2.getBytes(StandardCharsets.UTF_8));
            output.flush();
            String response2 = reader.readLine();
            Assertions.assertTrue((boolean)response2.startsWith("HTTP/1.1 200 "));
            while (reader.readLine() != null) {
            }
        }
    }
}

