/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.AcceptRateLimit;
import org.eclipse.jetty.server.ConnectionLimit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class NotAcceptingTest {
    private final long idleTimeout = 2000L;
    Server server;
    LocalConnector localConnector;
    ServerConnector blockingConnector;
    ServerConnector asyncConnector;

    @BeforeEach
    public void before() {
        this.server = new Server();
        this.localConnector = new LocalConnector(this.server);
        this.localConnector.setIdleTimeout(2000L);
        this.server.addConnector((Connector)this.localConnector);
        this.blockingConnector = new ServerConnector(this.server, 1, 1);
        this.blockingConnector.setPort(0);
        this.blockingConnector.setIdleTimeout(2000L);
        this.blockingConnector.setAcceptQueueSize(10);
        this.server.addConnector((Connector)this.blockingConnector);
        this.asyncConnector = new ServerConnector(this.server, 0, 1);
        this.asyncConnector.setPort(0);
        this.asyncConnector.setIdleTimeout(2000L);
        this.asyncConnector.setAcceptQueueSize(10);
        this.server.addConnector((Connector)this.asyncConnector);
    }

    @AfterEach
    public void after() throws Exception {
        this.server.stop();
        this.server = null;
    }

    @Test
    public void testServerConnectorBlockingAccept() throws Exception {
        TestHandler handler = new TestHandler();
        this.server.setHandler((Handler)handler);
        this.server.start();
        try (Socket client0 = new Socket("localhost", this.blockingConnector.getLocalPort());){
            HttpTester.Input in0 = HttpTester.from((InputStream)client0.getInputStream());
            client0.getOutputStream().write("GET /one HTTP/1.1\r\nHost:localhost\r\n\r\n".getBytes());
            String uri = handler.exchange.exchange("data");
            MatcherAssert.assertThat((Object)uri, (Matcher)Matchers.is((Object)"/one"));
            HttpTester.Response response = HttpTester.parseResponse((HttpTester.Input)in0);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"data"));
            this.blockingConnector.setAccepting(false);
            client0.getOutputStream().write("GET /two HTTP/1.1\r\nHost:localhost\r\n\r\n".getBytes());
            uri = handler.exchange.exchange("more data");
            MatcherAssert.assertThat((Object)uri, (Matcher)Matchers.is((Object)"/two"));
            response = HttpTester.parseResponse((HttpTester.Input)in0);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"more data"));
            try (Socket client1 = new Socket("localhost", this.blockingConnector.getLocalPort());){
                HttpTester.Input in1 = HttpTester.from((InputStream)client1.getInputStream());
                client1.getOutputStream().write("GET /three HTTP/1.1\r\nHost:localhost\r\n\r\n".getBytes());
                uri = handler.exchange.exchange("new connection");
                MatcherAssert.assertThat((Object)uri, (Matcher)Matchers.is((Object)"/three"));
                response = HttpTester.parseResponse((HttpTester.Input)in1);
                MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
                MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"new connection"));
                try (Socket client2 = new Socket("localhost", this.blockingConnector.getLocalPort());){
                    HttpTester.Input in2 = HttpTester.from((InputStream)client2.getInputStream());
                    client2.getOutputStream().write("GET /four HTTP/1.1\r\nHost:localhost\r\n\r\n".getBytes());
                    try {
                        uri = handler.exchange.exchange("delayed connection", 2000L, TimeUnit.MILLISECONDS);
                        Assertions.fail((String)("Failed near URI: " + uri));
                    }
                    catch (TimeoutException e) {
                        this.blockingConnector.setAccepting(true);
                        uri = handler.exchange.exchange("delayed connection");
                        MatcherAssert.assertThat((Object)uri, (Matcher)Matchers.is((Object)"/four"));
                        response = HttpTester.parseResponse((HttpTester.Input)in2);
                        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
                        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"delayed connection"));
                    }
                }
            }
        }
    }

    @Test
    @Disabled
    public void testLocalConnector() throws Exception {
        this.server.setHandler((Handler)new HelloHandler());
        this.server.start();
        try (LocalConnector.LocalEndPoint client0 = this.localConnector.connect();){
            client0.addInputAndExecute(BufferUtil.toBuffer((String)"GET /one HTTP/1.1\r\nHost:localhost\r\n\r\n"));
            HttpTester.Response response = HttpTester.parseResponse((String)client0.getResponse());
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"Hello\n"));
            this.localConnector.setAccepting(false);
            client0.addInputAndExecute(BufferUtil.toBuffer((String)"GET /two HTTP/1.1\r\nHost:localhost\r\n\r\n"));
            response = HttpTester.parseResponse((String)client0.getResponse());
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"Hello\n"));
            LocalConnector.LocalEndPoint[] local = new LocalConnector.LocalEndPoint[10];
            for (int i = 0; i < 10; ++i) {
                LocalConnector.LocalEndPoint client = this.localConnector.connect();
                try {
                    block20: {
                        try {
                            local[i] = client;
                            client.addInputAndExecute(BufferUtil.toBuffer((String)"GET /three HTTP/1.1\r\nHost:localhost\r\n\r\n"));
                            response = HttpTester.parseResponse((String)client.getResponse(false, 2000L, TimeUnit.MILLISECONDS));
                            if (i != local.length - 1) break block20;
                            Assertions.fail((String)"Expected TimeoutException");
                        }
                        catch (TimeoutException e) {
                            if (client == null) break;
                            client.close();
                            break;
                        }
                    }
                    if (client == null) continue;
                }
                catch (Throwable throwable) {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                client.close();
            }
            client0.addInputAndExecute(BufferUtil.toBuffer((String)"GET /four HTTP/1.1\r\nHost:localhost\r\n\r\n"));
            response = HttpTester.parseResponse((String)client0.getResponse());
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"Hello\n"));
            this.localConnector.setAccepting(true);
            try (LocalConnector.LocalEndPoint client = this.localConnector.connect();){
                client.addInputAndExecute(BufferUtil.toBuffer((String)"GET /five HTTP/1.1\r\nHost:localhost\r\n\r\n"));
                response = HttpTester.parseResponse((String)client.getResponse());
                MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
                MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"Hello\n"));
            }
        }
    }

    @Test
    public void testServerConnectorAsyncAccept() throws Exception {
        TestHandler handler = new TestHandler();
        this.server.setHandler((Handler)handler);
        this.server.start();
        try (Socket client0 = new Socket("localhost", this.asyncConnector.getLocalPort());){
            HttpTester.Input in0 = HttpTester.from((InputStream)client0.getInputStream());
            client0.getOutputStream().write("GET /one HTTP/1.1\r\nHost:localhost\r\n\r\n".getBytes());
            String uri = handler.exchange.exchange("data");
            MatcherAssert.assertThat((Object)uri, (Matcher)Matchers.is((Object)"/one"));
            HttpTester.Response response = HttpTester.parseResponse((HttpTester.Input)in0);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"data"));
            this.asyncConnector.setAccepting(false);
            client0.getOutputStream().write("GET /two HTTP/1.1\r\nHost:localhost\r\n\r\n".getBytes());
            uri = handler.exchange.exchange("more data");
            MatcherAssert.assertThat((Object)uri, (Matcher)Matchers.is((Object)"/two"));
            response = HttpTester.parseResponse((HttpTester.Input)in0);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"more data"));
            try (Socket client1 = new Socket("localhost", this.asyncConnector.getLocalPort());){
                HttpTester.Input in1 = HttpTester.from((InputStream)client1.getInputStream());
                client1.getOutputStream().write("GET /three HTTP/1.1\r\nHost:localhost\r\n\r\n".getBytes());
                try {
                    uri = handler.exchange.exchange("delayed connection", 2000L, TimeUnit.MILLISECONDS);
                    Assertions.fail((String)uri);
                }
                catch (TimeoutException e) {
                    this.asyncConnector.setAccepting(true);
                    uri = handler.exchange.exchange("delayed connection");
                    MatcherAssert.assertThat((Object)uri, (Matcher)Matchers.is((Object)"/three"));
                    response = HttpTester.parseResponse((HttpTester.Input)in1);
                    MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
                    MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"delayed connection"));
                }
            }
        }
    }

    @Test
    public void testAcceptRateLimit() throws Exception {
        Socket async1;
        AcceptRateLimit limit = new AcceptRateLimit(4, 1L, TimeUnit.HOURS, this.server);
        this.server.addBean((Object)limit);
        this.server.setHandler((Handler)new HelloHandler());
        this.server.start();
        try (Socket async0 = new Socket("localhost", this.asyncConnector.getLocalPort());){
            async1 = new Socket("localhost", this.asyncConnector.getLocalPort());
            try (Socket async2 = new Socket("localhost", this.asyncConnector.getLocalPort());){
                String expectedContent = "Hello" + System.lineSeparator();
                Socket[] socketArray = new Socket[]{async2};
                int n = socketArray.length;
                for (int i = 0; i < n; ++i) {
                    Socket client = socketArray[i];
                    HttpTester.Input in = HttpTester.from((InputStream)client.getInputStream());
                    client.getOutputStream().write("GET /test HTTP/1.1\r\nHost:localhost\r\n\r\n".getBytes());
                    HttpTester.Response response = HttpTester.parseResponse((HttpTester.Input)in);
                    MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
                    MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)expectedContent));
                }
                MatcherAssert.assertThat((Object)this.localConnector.isAccepting(), (Matcher)Matchers.is((Object)true));
                MatcherAssert.assertThat((Object)this.blockingConnector.isAccepting(), (Matcher)Matchers.is((Object)true));
                MatcherAssert.assertThat((Object)this.asyncConnector.isAccepting(), (Matcher)Matchers.is((Object)true));
            }
            finally {
                async1.close();
            }
        }
        limit.age(45L, TimeUnit.MINUTES);
        async0 = new Socket("localhost", this.asyncConnector.getLocalPort());
        try {
            async1 = new Socket("localhost", this.asyncConnector.getLocalPort());
            try {
                String expectedContent = "Hello" + System.lineSeparator();
                for (Socket client : new Socket[]{async1}) {
                    HttpTester.Input in = HttpTester.from((InputStream)client.getInputStream());
                    client.getOutputStream().write("GET /test HTTP/1.1\r\nHost:localhost\r\n\r\n".getBytes());
                    HttpTester.Response response = HttpTester.parseResponse((HttpTester.Input)in);
                    MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
                    MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)expectedContent));
                }
                MatcherAssert.assertThat((Object)this.localConnector.isAccepting(), (Matcher)Matchers.is((Object)false));
                MatcherAssert.assertThat((Object)this.blockingConnector.isAccepting(), (Matcher)Matchers.is((Object)false));
                MatcherAssert.assertThat((Object)this.asyncConnector.isAccepting(), (Matcher)Matchers.is((Object)false));
            }
            finally {
                async1.close();
            }
        }
        finally {
            async0.close();
        }
        limit.age(45L, TimeUnit.MINUTES);
        MatcherAssert.assertThat((Object)this.localConnector.isAccepting(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.blockingConnector.isAccepting(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.asyncConnector.isAccepting(), (Matcher)Matchers.is((Object)false));
        limit.run();
        MatcherAssert.assertThat((Object)this.localConnector.isAccepting(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.blockingConnector.isAccepting(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.asyncConnector.isAccepting(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testConnectionLimit() throws Exception {
        this.server.addBean((Object)new ConnectionLimit(9, this.server));
        this.server.setHandler((Handler)new HelloHandler());
        this.server.start();
        Log.getLogger(ConnectionLimit.class).debug("CONNECT:", new Object[0]);
        try (LocalConnector.LocalEndPoint local0 = this.localConnector.connect();
             LocalConnector.LocalEndPoint local1 = this.localConnector.connect();
             LocalConnector.LocalEndPoint local2 = this.localConnector.connect();
             Socket blocking0 = new Socket("localhost", this.blockingConnector.getLocalPort());
             Socket blocking1 = new Socket("localhost", this.blockingConnector.getLocalPort());
             Socket blocking2 = new Socket("localhost", this.blockingConnector.getLocalPort());
             Socket async0 = new Socket("localhost", this.asyncConnector.getLocalPort());
             Socket async1 = new Socket("localhost", this.asyncConnector.getLocalPort());
             Socket async2 = new Socket("localhost", this.asyncConnector.getLocalPort());){
            String expectedContent = "Hello" + System.lineSeparator();
            Log.getLogger(ConnectionLimit.class).debug("LOCAL:", new Object[0]);
            for (LocalConnector.LocalEndPoint localEndPoint : new LocalConnector.LocalEndPoint[]{local0, local1, local2}) {
                localEndPoint.addInputAndExecute(BufferUtil.toBuffer((String)"GET /test HTTP/1.1\r\nHost:localhost\r\n\r\n"));
                HttpTester.Response response = HttpTester.parseResponse((String)localEndPoint.getResponse());
                MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
                MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)expectedContent));
            }
            Log.getLogger(ConnectionLimit.class).debug("NETWORK:", new Object[0]);
            for (Socket socket : new Socket[]{blocking0, blocking1, blocking2, async0, async1, async2}) {
                HttpTester.Input in = HttpTester.from((InputStream)socket.getInputStream());
                socket.getOutputStream().write("GET /test HTTP/1.1\r\nHost:localhost\r\n\r\n".getBytes());
                HttpTester.Response response = HttpTester.parseResponse((HttpTester.Input)in);
                MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
                MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)expectedContent));
            }
            MatcherAssert.assertThat((Object)this.localConnector.isAccepting(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)this.blockingConnector.isAccepting(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)this.asyncConnector.isAccepting(), (Matcher)Matchers.is((Object)false));
            HttpTester.Input input = HttpTester.from((InputStream)async1.getInputStream());
            async1.getOutputStream().write("GET /test HTTP/1.1\r\nHost:localhost\r\nConnection: close\r\n\r\n".getBytes());
            HttpTester.Response response = HttpTester.parseResponse((HttpTester.Input)input);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)expectedContent));
        }
        NotAcceptingTest.waitFor(() -> ((LocalConnector)this.localConnector).isAccepting(), Matchers.is((Object)true), 4000L, TimeUnit.MILLISECONDS);
        NotAcceptingTest.waitFor(() -> ((ServerConnector)this.blockingConnector).isAccepting(), Matchers.is((Object)true), 4000L, TimeUnit.MILLISECONDS);
        NotAcceptingTest.waitFor(() -> ((ServerConnector)this.asyncConnector).isAccepting(), Matchers.is((Object)true), 4000L, TimeUnit.MILLISECONDS);
    }

    public static <T> void waitFor(Supplier<T> value, Matcher<T> matcher, long wait, TimeUnit units) {
        long start = System.nanoTime();
        while (true) {
            try {
                matcher.matches(value.get());
                return;
            }
            catch (Throwable e) {
                if (System.nanoTime() - start > units.toNanos(wait)) {
                    throw e;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public static class TestHandler
    extends AbstractHandler {
        final Exchanger<String> exchange = new Exchanger();
        transient int handled;

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            try {
                String content = this.exchange.exchange(baseRequest.getRequestURI());
                baseRequest.setHandled(true);
                ++this.handled;
                response.setContentType("text/html;charset=utf-8");
                response.setStatus(200);
                response.getWriter().print(content);
            }
            catch (InterruptedException e) {
                throw new ServletException((Throwable)e);
            }
        }

        public int getHandled() {
            return this.handled;
        }
    }

    public static class HelloHandler
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setContentType("text/html;charset=utf-8");
            response.setStatus(200);
            response.getWriter().println("Hello");
        }
    }
}

